/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.util;

import com.couchbase.client.core.annotation.Stability;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.util.HashSet;
import java.util.Set;

@Stability.Internal
public class CbAnnotations {
    private CbAnnotations() {
        throw new AssertionError((Object)"not instantiable");
    }

    public static <T extends Annotation> T findAnnotation(AnnotatedElement element, Class<T> annotationClass) {
        for (Annotation a : element.getAnnotations()) {
            T meta = CbAnnotations.findAnnotation(a, annotationClass);
            if (meta == null) continue;
            return meta;
        }
        return null;
    }

    public static <T extends Annotation> T findAnnotation(Annotation annotation, Class<T> annotationClass) {
        return CbAnnotations.findAnnotationRecursive(annotation, annotationClass, new HashSet<Class>());
    }

    private static <T extends Annotation> T findAnnotationRecursive(Annotation annotation, Class<T> annotationClass, Set<Class> seen) {
        Class<? extends Annotation> c = annotation.annotationType();
        if (!seen.add(c)) {
            return null;
        }
        if (c.equals(annotationClass)) {
            return (T)((Annotation)annotationClass.cast(annotation));
        }
        for (Annotation meta : c.getAnnotations()) {
            T found = CbAnnotations.findAnnotationRecursive(meta, annotationClass, seen);
            if (found == null) continue;
            return found;
        }
        return null;
    }
}

