/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.node;

import com.couchbase.client.core.CoreContext;
import com.couchbase.client.core.cnc.events.node.NodePartitionLengthNotEqualEvent;
import com.couchbase.client.core.config.BucketCapabilities;
import com.couchbase.client.core.config.BucketConfig;
import com.couchbase.client.core.config.ClusterConfig;
import com.couchbase.client.core.config.CouchbaseBucketConfig;
import com.couchbase.client.core.config.MemcachedBucketConfig;
import com.couchbase.client.core.config.NodeInfo;
import com.couchbase.client.core.error.FeatureNotAvailableException;
import com.couchbase.client.core.msg.CancellationReason;
import com.couchbase.client.core.msg.Request;
import com.couchbase.client.core.msg.Response;
import com.couchbase.client.core.msg.TargetedRequest;
import com.couchbase.client.core.msg.kv.DurabilityLevel;
import com.couchbase.client.core.msg.kv.KeyValueRequest;
import com.couchbase.client.core.msg.kv.ObserveViaSeqnoRequest;
import com.couchbase.client.core.msg.kv.ReplicaGetRequest;
import com.couchbase.client.core.msg.kv.SyncDurabilityRequest;
import com.couchbase.client.core.node.Locator;
import com.couchbase.client.core.node.Node;
import com.couchbase.client.core.node.NodeIdentifier;
import com.couchbase.client.core.node.NodeState;
import com.couchbase.client.core.retry.RetryOrchestrator;
import com.couchbase.client.core.retry.RetryReason;
import java.util.List;
import java.util.Optional;
import java.util.zip.CRC32;

public class KeyValueLocator
implements Locator {
    @Override
    public void dispatch(Request<? extends Response> request, List<Node> nodes, ClusterConfig config, CoreContext ctx) {
        if (request instanceof TargetedRequest) {
            KeyValueLocator.dispatchTargeted((TargetedRequest)((Object)request), nodes, ctx);
        } else {
            KeyValueRequest r = (KeyValueRequest)request;
            String bucket = r.bucket();
            BucketConfig bucketConfig = config.bucketConfig(bucket);
            if (bucketConfig == null) {
                RetryOrchestrator.maybeRetry(ctx, request, ctx.core().configurationProvider().bucketConfigLoadInProgress() ? RetryReason.BUCKET_OPEN_IN_PROGRESS : RetryReason.BUCKET_NOT_AVAILABLE);
                return;
            }
            if (bucketConfig instanceof CouchbaseBucketConfig) {
                KeyValueLocator.couchbaseBucket(r, nodes, (CouchbaseBucketConfig)bucketConfig, ctx);
            } else if (bucketConfig instanceof MemcachedBucketConfig) {
                KeyValueLocator.memcacheBucket(r, nodes, (MemcachedBucketConfig)bucketConfig, ctx);
            } else {
                throw new IllegalStateException("Unsupported Bucket Type: " + bucketConfig + " for request " + request);
            }
        }
    }

    private static void dispatchTargeted(TargetedRequest request, List<Node> nodes, CoreContext ctx) {
        for (Node node : nodes) {
            if (node.state() != NodeState.CONNECTED && node.state() != NodeState.DEGRADED || !request.target().equals(node.identifier())) continue;
            node.send((Request)((Object)request));
            return;
        }
        KeyValueLocator.handleTargetNotAvailable(request, nodes, ctx);
    }

    private static void handleTargetNotAvailable(TargetedRequest request, List<Node> nodes, CoreContext ctx) {
        for (Node node : nodes) {
            if (!request.target().equals(node.identifier())) continue;
            RetryOrchestrator.maybeRetry(ctx, (Request)((Object)request), RetryReason.NODE_NOT_AVAILABLE);
            return;
        }
        ((Request)((Object)request)).cancel(CancellationReason.TARGET_NODE_REMOVED);
    }

    private static void couchbaseBucket(KeyValueRequest<?> request, List<Node> nodes, CouchbaseBucketConfig config, CoreContext ctx) {
        if (!KeyValueLocator.precheckCouchbaseBucket(request, config)) {
            return;
        }
        int partitionId = KeyValueLocator.partitionForKey(request.key(), config.numberOfPartitions());
        request.partition((short)partitionId);
        int nodeId = KeyValueLocator.calculateNodeId(partitionId, request, config);
        if (nodeId < 0) {
            RetryOrchestrator.maybeRetry(ctx, request, RetryReason.NODE_NOT_AVAILABLE);
            return;
        }
        NodeInfo nodeInfo = config.nodeAtIndex(nodeId);
        for (Node node : nodes) {
            if (!node.identifier().equals(nodeInfo.identifier())) continue;
            node.send(request);
            return;
        }
        if (KeyValueLocator.handleNotEqualNodeSizes(config.nodes().size(), nodes.size(), ctx)) {
            RetryOrchestrator.maybeRetry(ctx, request, RetryReason.NODE_NOT_AVAILABLE);
            return;
        }
        if (!ctx.core().configurationProvider().bucketConfigLoadInProgress()) {
            throw new IllegalStateException("Node not found for request" + request);
        }
        RetryOrchestrator.maybeRetry(ctx, request, RetryReason.BUCKET_OPEN_IN_PROGRESS);
    }

    private static boolean precheckCouchbaseBucket(KeyValueRequest<?> request, CouchbaseBucketConfig config) {
        Optional<DurabilityLevel> level;
        if (request instanceof SyncDurabilityRequest && (level = ((SyncDurabilityRequest)((Object)request)).durabilityLevel()).isPresent() && level.get() != DurabilityLevel.NONE && !config.bucketCapabilities().contains((Object)BucketCapabilities.DURABLE_WRITE)) {
            request.fail(new FeatureNotAvailableException("Synchronous Durability is currently not available on this bucket"));
            return false;
        }
        return true;
    }

    private static int calculateNodeId(int partitionId, KeyValueRequest<?> request, CouchbaseBucketConfig config) {
        boolean useFastForward;
        boolean bl = useFastForward = config.hasFastForwardMap() && request.context().retryAttempts() % 2 == 1;
        if (request instanceof ReplicaGetRequest) {
            return config.nodeIndexForReplica(partitionId, ((ReplicaGetRequest)request).replica() - 1, useFastForward);
        }
        if (request instanceof ObserveViaSeqnoRequest && ((ObserveViaSeqnoRequest)request).replica() > 0) {
            return config.nodeIndexForReplica(partitionId, ((ObserveViaSeqnoRequest)request).replica() - 1, useFastForward);
        }
        return config.nodeIndexForActive(partitionId, useFastForward);
    }

    private static void memcacheBucket(KeyValueRequest<?> request, List<Node> nodes, MemcachedBucketConfig config, CoreContext ctx) {
        if (!KeyValueLocator.precheckMemcacheBucket(request, config)) {
            return;
        }
        NodeIdentifier identifier = config.nodeForId(request.key());
        request.partition((short)0);
        for (Node node : nodes) {
            if (!node.identifier().equals(identifier)) continue;
            node.send(request);
            return;
        }
        if (KeyValueLocator.handleNotEqualNodeSizes(config.nodes().size(), nodes.size(), ctx)) {
            RetryOrchestrator.maybeRetry(ctx, request, RetryReason.NODE_NOT_AVAILABLE);
            return;
        }
        throw new IllegalStateException("Node not found for request" + request);
    }

    private static boolean precheckMemcacheBucket(KeyValueRequest<?> request, MemcachedBucketConfig config) {
        Optional<DurabilityLevel> level;
        if (request instanceof SyncDurabilityRequest && (level = ((SyncDurabilityRequest)((Object)request)).durabilityLevel()).isPresent() && level.get() != DurabilityLevel.NONE && !config.bucketCapabilities().contains((Object)BucketCapabilities.DURABLE_WRITE)) {
            request.fail(new FeatureNotAvailableException("Synchronous Durability is not available for memcache buckets"));
            return false;
        }
        return true;
    }

    private static boolean handleNotEqualNodeSizes(int configNodeSize, int actualNodeSize, CoreContext ctx) {
        if (configNodeSize != actualNodeSize) {
            ctx.environment().eventBus().publish(new NodePartitionLengthNotEqualEvent(ctx, actualNodeSize, configNodeSize));
            return true;
        }
        return false;
    }

    public static int partitionForKey(byte[] id, int numPartitions) {
        CRC32 crc32 = new CRC32();
        crc32.update(id, 0, id.length);
        long rv = crc32.getValue() >> 16 & 0x7FFFL;
        return (int)rv & numPartitions - 1;
    }
}

