/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.msg.kv;

import com.couchbase.client.core.CoreContext;
import com.couchbase.client.core.cnc.RequestSpan;
import com.couchbase.client.core.deps.io.netty.buffer.ByteBuf;
import com.couchbase.client.core.deps.io.netty.buffer.ByteBufAllocator;
import com.couchbase.client.core.deps.io.netty.util.ReferenceCountUtil;
import com.couchbase.client.core.io.CollectionIdentifier;
import com.couchbase.client.core.io.netty.kv.KeyValueChannelContext;
import com.couchbase.client.core.io.netty.kv.MemcacheProtocol;
import com.couchbase.client.core.msg.kv.GetRequest;
import com.couchbase.client.core.retry.RetryStrategy;
import java.time.Duration;
import java.util.Map;

public class ReplicaGetRequest
extends GetRequest {
    private final short replica;

    public ReplicaGetRequest(String key, Duration timeout, CoreContext ctx, CollectionIdentifier collectionIdentifier, RetryStrategy retryStrategy, short replica, RequestSpan span) {
        super(key, timeout, ctx, collectionIdentifier, retryStrategy, span);
        this.replica = replica;
    }

    public short replica() {
        return this.replica;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ByteBuf encode(ByteBufAllocator alloc, int opaque, KeyValueChannelContext ctx) {
        ByteBuf byteBuf;
        ByteBuf key = null;
        try {
            key = this.encodedKeyWithCollection(alloc, ctx);
            byteBuf = MemcacheProtocol.request(alloc, MemcacheProtocol.Opcode.GET_REPLICA, MemcacheProtocol.noDatatype(), this.partition(), opaque, MemcacheProtocol.noCas(), MemcacheProtocol.noExtras(), key, MemcacheProtocol.noBody());
        }
        catch (Throwable throwable) {
            ReferenceCountUtil.release(key);
            throw throwable;
        }
        ReferenceCountUtil.release(key);
        return byteBuf;
    }

    @Override
    public Map<String, Object> serviceContext() {
        Map<String, Object> ctx = super.serviceContext();
        ctx.put("isReplica", true);
        ctx.put("replicaNum", this.replica);
        return ctx;
    }

    @Override
    public String name() {
        return "get_replica";
    }
}

