/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.io.netty.query;

import com.couchbase.client.core.endpoint.BaseEndpoint;
import com.couchbase.client.core.endpoint.EndpointContext;
import com.couchbase.client.core.error.CouchbaseException;
import com.couchbase.client.core.error.ErrorCodeAndMessage;
import com.couchbase.client.core.error.context.QueryErrorContext;
import com.couchbase.client.core.io.netty.chunk.ChunkedMessageHandler;
import com.couchbase.client.core.io.netty.query.QueryChunkResponseParser;
import com.couchbase.client.core.msg.query.QueryChunkHeader;
import com.couchbase.client.core.msg.query.QueryChunkRow;
import com.couchbase.client.core.msg.query.QueryChunkTrailer;
import com.couchbase.client.core.msg.query.QueryRequest;
import com.couchbase.client.core.msg.query.QueryResponse;
import com.couchbase.client.core.retry.RetryReason;
import java.util.List;
import java.util.Optional;

public class QueryMessageHandler
extends ChunkedMessageHandler<QueryChunkHeader, QueryChunkRow, QueryChunkTrailer, QueryResponse, QueryRequest> {
    public QueryMessageHandler(BaseEndpoint endpoint, EndpointContext endpointContext) {
        super(endpoint, endpointContext, new QueryChunkResponseParser());
    }

    @Override
    protected Optional<RetryReason> qualifiesForRetry(CouchbaseException exception) {
        QueryErrorContext errorContext;
        List<ErrorCodeAndMessage> errors;
        if (exception.context() instanceof QueryErrorContext && !(errors = (errorContext = (QueryErrorContext)exception.context()).errors()).isEmpty()) {
            return QueryMessageHandler.mapError(errors.get(0));
        }
        return Optional.empty();
    }

    private static Optional<RetryReason> mapError(ErrorCodeAndMessage error) {
        int code = error.code();
        if (code == 4040 || code == 4050 || code == 4070) {
            return Optional.empty();
        }
        if (code == 5000 && error.message().contains("queryport.indexNotFound")) {
            return Optional.of(RetryReason.QUERY_INDEX_NOT_FOUND);
        }
        return Optional.empty();
    }
}

