/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.cnc.events.endpoint;

import com.couchbase.client.core.cnc.AbstractEvent;
import com.couchbase.client.core.cnc.Context;
import com.couchbase.client.core.cnc.Event;
import com.couchbase.client.core.endpoint.EndpointContext;
import java.time.Duration;

public class EndpointConnectionFailedEvent
extends AbstractEvent {
    private final long attempt;
    private final Throwable cause;

    public EndpointConnectionFailedEvent(Duration duration, EndpointContext context, long attempt, Throwable cause) {
        super(Event.Severity.WARN, Event.Category.ENDPOINT, duration, (Context)context);
        this.attempt = attempt;
        this.cause = cause;
    }

    public long attempt() {
        return this.attempt;
    }

    @Override
    public Throwable cause() {
        return this.cause;
    }

    @Override
    public String description() {
        String msg = this.cause == null ? "" : " because of " + this.cause.getClass().getSimpleName() + ": " + this.cause.getMessage();
        return "Connect attempt " + this.attempt + " failed" + msg;
    }
}

