/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.cnc;

import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.cnc.Context;
import com.couchbase.client.core.cnc.Event;
import com.couchbase.client.core.env.LoggerConfig;
import com.couchbase.client.core.logging.RedactableArgument;
import com.couchbase.client.core.msg.RequestContext;
import com.couchbase.client.core.util.CbCollections;
import java.io.PrintStream;
import java.time.Duration;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.stream.Collectors;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

public class LoggingEventConsumer
implements Consumer<Event> {
    private static final boolean SLF4J_AVAILABLE = LoggingEventConsumer.slf4JOnClasspath();
    private final Map<String, Logger> loggers = new HashMap<String, Logger>(Event.Category.values().length);
    private final LoggerConfig loggerConfig;

    public static LoggingEventConsumer create() {
        return new LoggingEventConsumer(LoggerConfig.create());
    }

    public static LoggingEventConsumer create(LoggerConfig loggerConfig) {
        return new LoggingEventConsumer(loggerConfig);
    }

    private LoggingEventConsumer(LoggerConfig loggerConfig) {
        this.loggerConfig = loggerConfig;
    }

    private Logger createLogger(String name) {
        Logger logger = this.loggerConfig.customLogger() != null ? this.loggerConfig.customLogger() : (SLF4J_AVAILABLE && !this.loggerConfig.disableSlf4J() ? new Slf4JLogger(name) : (this.loggerConfig.fallbackToConsole() ? new ConsoleLogger(name) : new JdkLogger(name)));
        return logger;
    }

    @Override
    public void accept(Event event) {
        boolean diagnosticContext;
        String description;
        if (event.severity() == Event.Severity.TRACING) {
            return;
        }
        StringBuilder logLineBuilder = new StringBuilder();
        logLineBuilder.append("[").append(event.category()).append("]");
        logLineBuilder.append("[").append(event.getClass().getSimpleName()).append("]");
        if (!event.duration().isZero()) {
            logLineBuilder.append("[").append(LoggingEventConsumer.convertEventDuration(event.duration())).append("]");
        }
        if ((description = event.description()) != null && !description.isEmpty()) {
            logLineBuilder.append(" ").append(description);
        }
        if (event.context() != null) {
            logLineBuilder.append(" ").append(event.context().exportAsString(Context.ExportFormat.JSON));
        }
        String logLine = logLineBuilder.toString();
        Logger logger = this.loggers.get(event.category());
        if (logger == null) {
            logger = this.createLogger(event.category());
            this.loggers.put(event.category(), logger);
        }
        boolean bl = diagnosticContext = this.loggerConfig.diagnosticContextEnabled() && event.context() instanceof RequestContext;
        if (diagnosticContext) {
            logger.attachContext(((RequestContext)event.context()).clientContext());
        }
        switch (event.severity()) {
            case VERBOSE: {
                if (event.cause() != null) {
                    logger.trace(logLine, event.cause());
                    break;
                }
                logger.trace(logLine);
                break;
            }
            case DEBUG: {
                if (event.cause() != null) {
                    logger.debug(logLine, event.cause());
                    break;
                }
                logger.debug(logLine);
                break;
            }
            case INFO: {
                if (event.cause() != null) {
                    logger.info(logLine, event.cause());
                    break;
                }
                logger.info(logLine);
                break;
            }
            case WARN: {
                if (event.cause() != null) {
                    logger.warn(logLine, event.cause());
                    break;
                }
                logger.warn(logLine);
                break;
            }
            case ERROR: {
                if (event.cause() != null) {
                    logger.error(logLine, event.cause());
                    break;
                }
                logger.error(logLine);
            }
        }
        if (diagnosticContext) {
            logger.clearContext();
        }
    }

    private static String convertEventDuration(Duration duration) {
        long nanos = duration.toNanos();
        if (nanos < 1000L) {
            return nanos + "ns";
        }
        if (nanos < 10000000L) {
            return TimeUnit.NANOSECONDS.toMicros(nanos) + "us";
        }
        if (nanos < 10000000000L) {
            return TimeUnit.NANOSECONDS.toMillis(nanos) + "ms";
        }
        return TimeUnit.NANOSECONDS.toSeconds(nanos) + "s";
    }

    private static boolean slf4JOnClasspath() {
        try {
            Class.forName("org.slf4j.Logger");
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    private static String formatHelper(String from, Object ... arguments) {
        if (from != null) {
            String computed = from;
            if (arguments != null && arguments.length != 0) {
                for (Object argument : arguments) {
                    computed = computed.replaceFirst("\\{\\}", Matcher.quoteReplacement(argument.toString()));
                }
            }
            return computed;
        }
        return null;
    }

    static class ConsoleLogger
    implements Logger {
        private final String name;
        private final PrintStream err;
        private final PrintStream log;

        ConsoleLogger(String name) {
            this.name = name;
            this.log = System.out;
            this.err = System.err;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public boolean isTraceEnabled() {
            return true;
        }

        @Override
        public synchronized void trace(String msg) {
            this.log.format("[TRACE] (%s) %s\n", Thread.currentThread().getName(), msg);
        }

        @Override
        public synchronized void trace(String format, Object ... arguments) {
            this.log.format("[TRACE] (%s) %s\n", Thread.currentThread().getName(), LoggingEventConsumer.formatHelper(format, arguments));
        }

        @Override
        public synchronized void trace(String msg, Throwable t) {
            this.log.format("[TRACE] (%s) %s - %s\n", Thread.currentThread().getName(), msg, t);
            t.printStackTrace(this.log);
        }

        @Override
        public boolean isDebugEnabled() {
            return true;
        }

        @Override
        public synchronized void debug(String msg) {
            this.log.format("[DEBUG] (%s) %s\n", Thread.currentThread().getName(), msg);
        }

        @Override
        public synchronized void debug(String format, Object ... arguments) {
            this.log.format("[DEBUG] (%s) %s\n", Thread.currentThread().getName(), LoggingEventConsumer.formatHelper(format, arguments));
        }

        @Override
        public synchronized void debug(String msg, Throwable t) {
            this.log.format("[DEBUG] (%s) %s - %s\n", Thread.currentThread().getName(), msg, t);
            t.printStackTrace(this.log);
        }

        @Override
        public boolean isInfoEnabled() {
            return true;
        }

        @Override
        public synchronized void info(String msg) {
            this.log.format("[ INFO] (%s) %s\n", Thread.currentThread().getName(), msg);
        }

        @Override
        public synchronized void info(String format, Object ... arguments) {
            this.log.format("[ INFO] (%s) %s\n", Thread.currentThread().getName(), LoggingEventConsumer.formatHelper(format, arguments));
        }

        @Override
        public synchronized void info(String msg, Throwable t) {
            this.log.format("[ INFO] (%s) %s - %s\n", Thread.currentThread().getName(), msg, t);
            t.printStackTrace(this.log);
        }

        @Override
        public boolean isWarnEnabled() {
            return true;
        }

        @Override
        public synchronized void warn(String msg) {
            this.err.format("[ WARN] (%s) %s\n", Thread.currentThread().getName(), msg);
        }

        @Override
        public synchronized void warn(String format, Object ... arguments) {
            this.err.format("[ WARN] (%s) %s\n", Thread.currentThread().getName(), LoggingEventConsumer.formatHelper(format, arguments));
        }

        @Override
        public synchronized void warn(String msg, Throwable t) {
            this.err.format("[ WARN] (%s) %s - %s\n", Thread.currentThread().getName(), msg, t);
            t.printStackTrace(this.err);
        }

        @Override
        public boolean isErrorEnabled() {
            return true;
        }

        @Override
        public synchronized void error(String msg) {
            this.err.format("[ERROR] (%s) %s\n", Thread.currentThread().getName(), msg);
        }

        @Override
        public synchronized void error(String format, Object ... arguments) {
            this.err.format("[ERROR] (%s) %s\n", Thread.currentThread().getName(), LoggingEventConsumer.formatHelper(format, arguments));
        }

        @Override
        public synchronized void error(String msg, Throwable t) {
            this.err.format("[ERROR] (%s) %s - %s\n", Thread.currentThread().getName(), msg, t);
            t.printStackTrace(this.err);
        }
    }

    static class JdkLogger
    implements Logger {
        private final java.util.logging.Logger logger;

        JdkLogger(String name) {
            this.logger = java.util.logging.Logger.getLogger(name);
        }

        @Override
        public String getName() {
            return this.logger.getName();
        }

        @Override
        public boolean isTraceEnabled() {
            return this.logger.isLoggable(Level.FINEST);
        }

        @Override
        public void trace(String msg) {
            this.logger.log(Level.FINEST, msg);
        }

        @Override
        public void trace(String format, Object ... arguments) {
            this.logger.log(Level.FINEST, LoggingEventConsumer.formatHelper(format, arguments));
        }

        @Override
        public void trace(String msg, Throwable t) {
            this.logger.log(Level.FINEST, msg, t);
        }

        @Override
        public boolean isDebugEnabled() {
            return this.logger.isLoggable(Level.FINE);
        }

        @Override
        public void debug(String msg) {
            this.logger.log(Level.FINE, msg);
        }

        @Override
        public void debug(String format, Object ... arguments) {
            this.logger.log(Level.FINE, LoggingEventConsumer.formatHelper(format, arguments));
        }

        @Override
        public void debug(String msg, Throwable t) {
            this.logger.log(Level.FINE, msg, t);
        }

        @Override
        public boolean isInfoEnabled() {
            return this.logger.isLoggable(Level.INFO);
        }

        @Override
        public void info(String msg) {
            this.logger.log(Level.INFO, msg);
        }

        @Override
        public void info(String format, Object ... arguments) {
            this.logger.log(Level.INFO, LoggingEventConsumer.formatHelper(format, arguments));
        }

        @Override
        public void info(String msg, Throwable t) {
            this.logger.log(Level.INFO, msg, t);
        }

        @Override
        public boolean isWarnEnabled() {
            return this.logger.isLoggable(Level.WARNING);
        }

        @Override
        public void warn(String msg) {
            this.logger.log(Level.WARNING, msg);
        }

        @Override
        public void warn(String format, Object ... arguments) {
            this.logger.log(Level.WARNING, LoggingEventConsumer.formatHelper(format, arguments));
        }

        @Override
        public void warn(String msg, Throwable t) {
            this.logger.log(Level.WARNING, msg, t);
        }

        @Override
        public boolean isErrorEnabled() {
            return this.logger.isLoggable(Level.SEVERE);
        }

        @Override
        public void error(String msg) {
            this.logger.log(Level.SEVERE, msg);
        }

        @Override
        public void error(String format, Object ... arguments) {
            this.logger.log(Level.SEVERE, LoggingEventConsumer.formatHelper(format, arguments));
        }

        @Override
        public void error(String msg, Throwable t) {
            this.logger.log(Level.SEVERE, msg, t);
        }
    }

    static class Slf4JLogger
    implements Logger {
        private final org.slf4j.Logger logger;

        Slf4JLogger(String name) {
            this.logger = LoggerFactory.getLogger((String)name);
        }

        @Override
        public String getName() {
            return this.logger.getName();
        }

        @Override
        public boolean isTraceEnabled() {
            return this.logger.isTraceEnabled();
        }

        @Override
        public void trace(String msg) {
            this.logger.trace(msg);
        }

        @Override
        public void trace(String format, Object ... arguments) {
            this.logger.trace(format, arguments);
        }

        @Override
        public void trace(String msg, Throwable t) {
            this.logger.trace(msg, t);
        }

        @Override
        public boolean isDebugEnabled() {
            return this.logger.isDebugEnabled();
        }

        @Override
        public void debug(String msg) {
            this.logger.debug(msg);
        }

        @Override
        public void debug(String format, Object ... arguments) {
            this.logger.debug(format, arguments);
        }

        @Override
        public void debug(String msg, Throwable t) {
            this.logger.debug(msg, t);
        }

        @Override
        public boolean isInfoEnabled() {
            return this.logger.isInfoEnabled();
        }

        @Override
        public void info(String msg) {
            this.logger.info(msg);
        }

        @Override
        public void info(String format, Object ... arguments) {
            this.logger.info(format, arguments);
        }

        @Override
        public void info(String msg, Throwable t) {
            this.logger.info(msg, t);
        }

        @Override
        public boolean isWarnEnabled() {
            return this.logger.isWarnEnabled();
        }

        @Override
        public void warn(String msg) {
            this.logger.warn(msg);
        }

        @Override
        public void warn(String format, Object ... arguments) {
            this.logger.warn(format, arguments);
        }

        @Override
        public void warn(String msg, Throwable t) {
            this.logger.warn(msg, t);
        }

        @Override
        public boolean isErrorEnabled() {
            return this.logger.isErrorEnabled();
        }

        @Override
        public void error(String msg) {
            this.logger.error(msg);
        }

        @Override
        public void error(String format, Object ... arguments) {
            this.logger.error(format, arguments);
        }

        @Override
        public void error(String msg, Throwable t) {
            this.logger.error(msg, t);
        }

        @Override
        public void attachContext(Map<String, Object> context) {
            if (CbCollections.isNullOrEmpty(context)) {
                return;
            }
            MDC.setContextMap(context.entrySet().stream().collect(Collectors.toMap(e -> RedactableArgument.redactUser(e.getKey()).toString(), e -> {
                Object v = e.getValue();
                return v == null ? "" : RedactableArgument.redactUser(v.toString()).toString();
            })));
        }

        @Override
        public void clearContext() {
            MDC.clear();
        }
    }

    @Stability.Internal
    public static interface Logger {
        public String getName();

        public boolean isTraceEnabled();

        public void trace(String var1);

        public void trace(String var1, Object ... var2);

        public void trace(String var1, Throwable var2);

        public boolean isDebugEnabled();

        public void debug(String var1);

        public void debug(String var1, Object ... var2);

        public void debug(String var1, Throwable var2);

        public boolean isInfoEnabled();

        public void info(String var1);

        public void info(String var1, Object ... var2);

        public void info(String var1, Throwable var2);

        public boolean isWarnEnabled();

        public void warn(String var1);

        public void warn(String var1, Object ... var2);

        public void warn(String var1, Throwable var2);

        public boolean isErrorEnabled();

        public void error(String var1);

        public void error(String var1, Object ... var2);

        public void error(String var1, Throwable var2);

        default public void attachContext(Map<String, Object> context) {
        }

        default public void clearContext() {
        }
    }
}

