/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.service;

import com.couchbase.client.core.cnc.events.service.IdleEndpointRemovedEvent;
import com.couchbase.client.core.cnc.events.service.ServiceConnectInitiatedEvent;
import com.couchbase.client.core.cnc.events.service.ServiceDisconnectInitiatedEvent;
import com.couchbase.client.core.cnc.events.service.ServiceStateChangedEvent;
import com.couchbase.client.core.diagnostics.EndpointDiagnostics;
import com.couchbase.client.core.endpoint.Endpoint;
import com.couchbase.client.core.endpoint.EndpointState;
import com.couchbase.client.core.msg.Request;
import com.couchbase.client.core.msg.Response;
import com.couchbase.client.core.retry.RetryOrchestrator;
import com.couchbase.client.core.retry.RetryReason;
import com.couchbase.client.core.service.EndpointSelectionStrategy;
import com.couchbase.client.core.service.Service;
import com.couchbase.client.core.service.ServiceConfig;
import com.couchbase.client.core.service.ServiceContext;
import com.couchbase.client.core.service.ServiceState;
import com.couchbase.client.core.util.CompositeStateful;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Stream;
import reactor.core.publisher.Flux;

abstract class PooledService
implements Service {
    private static final Duration DEFAULT_IDLE_TIME_CHECK_INTERVAL = Duration.ofSeconds(5L);
    private final ServiceConfig serviceConfig;
    private final List<Endpoint> endpoints;
    private final CompositeStateful<Endpoint, EndpointState, ServiceState> endpointStates;
    private final ServiceContext serviceContext;
    private final boolean fixedPool;
    private final AtomicBoolean disconnected;

    PooledService(ServiceConfig serviceConfig, ServiceContext serviceContext) {
        this.serviceConfig = serviceConfig;
        this.endpoints = new CopyOnWriteArrayList<Endpoint>();
        ServiceState initialState = serviceConfig.minEndpoints() > 0 ? ServiceState.DISCONNECTED : ServiceState.IDLE;
        this.endpointStates = CompositeStateful.create(initialState, endpointStates -> {
            if (endpointStates.isEmpty()) {
                return initialState;
            }
            ServiceState state = ServiceState.DISCONNECTED;
            int connected = 0;
            int connecting = 0;
            int disconnecting = 0;
            for (EndpointState endpointState : endpointStates) {
                switch (endpointState) {
                    case CONNECTED: {
                        ++connected;
                        break;
                    }
                    case CONNECTING: {
                        ++connecting;
                        break;
                    }
                    case DISCONNECTING: {
                        ++disconnecting;
                        break;
                    }
                }
            }
            if (endpointStates.size() == connected) {
                state = ServiceState.CONNECTED;
            } else if (connected > 0) {
                state = ServiceState.DEGRADED;
            } else if (connecting > 0) {
                state = ServiceState.CONNECTING;
            } else if (disconnecting > 0) {
                state = ServiceState.DISCONNECTING;
            }
            return state;
        }, (from, to) -> serviceContext.environment().eventBus().publish(new ServiceStateChangedEvent(serviceContext, (ServiceState)((Object)from), (ServiceState)((Object)to))));
        this.disconnected = new AtomicBoolean(false);
        this.serviceContext = serviceContext;
        this.fixedPool = serviceConfig.minEndpoints() == serviceConfig.maxEndpoints();
        this.scheduleCleanIdleConnections();
    }

    protected ServiceContext serviceContext() {
        return this.serviceContext;
    }

    private void scheduleCleanIdleConnections() {
        Duration idleTime = this.serviceConfig.idleTime();
        if (idleTime != null && !idleTime.isZero()) {
            this.serviceContext.environment().timer().schedule(this::cleanIdleConnections, this.idleTimeCheckInterval());
        }
    }

    protected Duration idleTimeCheckInterval() {
        return DEFAULT_IDLE_TIME_CHECK_INTERVAL;
    }

    private synchronized void cleanIdleConnections() {
        if (this.disconnected.get()) {
            return;
        }
        ArrayList<Endpoint> endpoints = new ArrayList<Endpoint>(this.endpoints);
        Collections.shuffle(endpoints);
        for (Endpoint endpoint : endpoints) {
            boolean idleTooLong;
            if (this.endpoints.size() == this.serviceConfig.minEndpoints()) break;
            long actualIdleTime = System.nanoTime() - endpoint.lastResponseReceived();
            boolean receivedDisconnect = endpoint.receivedDisconnectSignal();
            boolean bl = idleTooLong = endpoint.outstandingRequests() == 0L && actualIdleTime >= this.serviceConfig.idleTime().toNanos();
            if (!receivedDisconnect && !idleTooLong) continue;
            this.serviceContext.environment().eventBus().publish(new IdleEndpointRemovedEvent(endpoint.context()));
            this.endpoints.remove(endpoint);
            this.endpointStates.deregister(endpoint);
            if (receivedDisconnect) continue;
            endpoint.disconnect();
        }
        this.scheduleCleanIdleConnections();
    }

    protected abstract Endpoint createEndpoint();

    protected abstract EndpointSelectionStrategy selectionStrategy();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <R extends Request<? extends Response>> void send(R request) {
        Endpoint found;
        if (request.completed()) {
            return;
        }
        Endpoint endpoint = found = this.endpoints.isEmpty() ? null : this.selectionStrategy().select(request, this.endpoints);
        if (found != null) {
            found.send(request);
            return;
        }
        if (!this.fixedPool && this.endpoints.size() < this.serviceConfig.maxEndpoints()) {
            PooledService pooledService = this;
            synchronized (pooledService) {
                if (!this.disconnected.get()) {
                    Endpoint endpoint2 = this.createEndpoint();
                    this.endpointStates.register(endpoint2, endpoint2);
                    endpoint2.connect();
                    this.endpoints.add(endpoint2);
                }
            }
            RetryOrchestrator.maybeRetry(this.serviceContext, request, RetryReason.ENDPOINT_TEMPORARILY_NOT_AVAILABLE);
        } else {
            RetryOrchestrator.maybeRetry(this.serviceContext, request, RetryReason.ENDPOINT_NOT_AVAILABLE);
        }
    }

    @Override
    public synchronized void connect() {
        if (this.state() == ServiceState.DISCONNECTED && !this.disconnected.get()) {
            this.serviceContext.environment().eventBus().publish(new ServiceConnectInitiatedEvent(this.serviceContext, this.serviceConfig.minEndpoints()));
            for (int i = 0; i < this.serviceConfig.minEndpoints(); ++i) {
                Endpoint endpoint = this.createEndpoint();
                this.endpointStates.register(endpoint, endpoint);
                endpoint.connect();
                this.endpoints.add(endpoint);
            }
        }
    }

    @Override
    public synchronized void disconnect() {
        if (this.disconnected.compareAndSet(false, true)) {
            this.serviceContext.environment().eventBus().publish(new ServiceDisconnectInitiatedEvent(this.serviceContext, this.endpoints.size()));
            for (Endpoint endpoint : this.endpoints) {
                endpoint.disconnect();
                this.endpointStates.deregister(endpoint);
            }
            this.endpoints.clear();
        }
    }

    @Override
    public ServiceContext context() {
        return this.serviceContext;
    }

    @Override
    public ServiceState state() {
        return this.endpointStates.state();
    }

    @Override
    public Flux<ServiceState> states() {
        return this.endpointStates.states();
    }

    @Override
    public Stream<EndpointDiagnostics> diagnostics() {
        return this.endpoints.stream().map(v -> v.diagnostics());
    }
}

