/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.node;

import com.couchbase.client.core.CoreContext;
import com.couchbase.client.core.logging.RedactableArgument;
import com.couchbase.client.core.node.NodeIdentifier;
import java.util.Map;
import java.util.Optional;

public class NodeContext
extends CoreContext {
    private final NodeIdentifier nodeIdentifier;
    private final Optional<String> alternateAddress;

    public NodeContext(CoreContext ctx, NodeIdentifier nodeIdentifier, Optional<String> alternateAddress) {
        super(ctx.core(), ctx.id(), ctx.environment(), ctx.authenticator());
        this.nodeIdentifier = nodeIdentifier;
        this.alternateAddress = alternateAddress;
    }

    public String remoteHostname() {
        return this.nodeIdentifier.address();
    }

    @Override
    public Optional<String> alternateAddress() {
        return this.alternateAddress;
    }

    @Override
    public void injectExportableParams(Map<String, Object> input) {
        super.injectExportableParams(input);
        input.put("remote", RedactableArgument.redactSystem(this.remoteHostname()));
        input.put("managerPort", RedactableArgument.redactSystem(this.nodeIdentifier.managerPort()));
        this.alternateAddress.ifPresent(a -> input.put("alternateRemote", a));
    }
}

