/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.error;

import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.deps.com.fasterxml.jackson.annotation.JsonAnySetter;
import com.couchbase.client.core.deps.com.fasterxml.jackson.annotation.JsonProperty;
import com.couchbase.client.core.deps.com.fasterxml.jackson.core.type.TypeReference;
import com.couchbase.client.core.json.Mapper;
import com.couchbase.client.core.util.CbCollections;
import com.couchbase.client.core.util.CbStrings;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ErrorCodeAndMessage {
    private final int code;
    private final String message;
    @JsonAnySetter
    private final Map<String, Object> context = new HashMap<String, Object>();

    public ErrorCodeAndMessage(@JsonProperty(value="code") int code, @JsonProperty(value="msg") String message) {
        this.code = code;
        this.message = CbStrings.nullToEmpty(message);
    }

    public int code() {
        return this.code;
    }

    public String message() {
        return this.message;
    }

    public Map<String, Object> context() {
        return Collections.unmodifiableMap(this.context);
    }

    public String toString() {
        return this.code + " " + this.message + (!this.context.isEmpty() ? " Context: " + this.context : "");
    }

    @Stability.Internal
    public static List<ErrorCodeAndMessage> fromJsonArray(byte[] jsonArray) {
        try {
            return Collections.unmodifiableList(Mapper.decodeInto(jsonArray, new TypeReference<List<ErrorCodeAndMessage>>(){}));
        }
        catch (Exception e) {
            return CbCollections.listOf(new ErrorCodeAndMessage(0, "Failed to decode errors: " + new String(jsonArray, StandardCharsets.UTF_8)));
        }
    }
}

