/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.deps.org.jctools.queues;

import com.couchbase.client.core.deps.org.jctools.queues.MessagePassingQueue;
import com.couchbase.client.core.deps.org.jctools.queues.SpscArrayQueueL3Pad;
import com.couchbase.client.core.deps.org.jctools.util.UnsafeRefArrayAccess;

public class SpscArrayQueue<E>
extends SpscArrayQueueL3Pad<E> {
    public SpscArrayQueue(int capacity) {
        super(Math.max(capacity, 4));
    }

    @Override
    public boolean offer(E e) {
        if (null == e) {
            throw new NullPointerException();
        }
        Object[] buffer = this.buffer;
        long mask = this.mask;
        long producerIndex = this.producerIndex;
        if (producerIndex >= this.producerLimit && !this.offerSlowPath(buffer, mask, producerIndex)) {
            return false;
        }
        long offset = SpscArrayQueue.calcElementOffset(producerIndex, mask);
        UnsafeRefArrayAccess.soElement(buffer, offset, e);
        this.soProducerIndex(producerIndex + 1L);
        return true;
    }

    private boolean offerSlowPath(E[] buffer, long mask, long producerIndex) {
        int lookAheadStep = this.lookAheadStep;
        if (null == UnsafeRefArrayAccess.lvElement(buffer, SpscArrayQueue.calcElementOffset(producerIndex + (long)lookAheadStep, mask))) {
            this.producerLimit = producerIndex + (long)lookAheadStep;
        } else {
            long offset = SpscArrayQueue.calcElementOffset(producerIndex, mask);
            if (null != UnsafeRefArrayAccess.lvElement(buffer, offset)) {
                return false;
            }
        }
        return true;
    }

    @Override
    public E poll() {
        Object[] buffer = this.buffer;
        long consumerIndex = this.consumerIndex;
        long offset = this.calcElementOffset(consumerIndex);
        Object e = UnsafeRefArrayAccess.lvElement(buffer, offset);
        if (null == e) {
            return null;
        }
        UnsafeRefArrayAccess.soElement(buffer, offset, null);
        this.soConsumerIndex(consumerIndex + 1L);
        return (E)e;
    }

    @Override
    public E peek() {
        return (E)UnsafeRefArrayAccess.lvElement(this.buffer, this.calcElementOffset(this.consumerIndex));
    }

    @Override
    public boolean relaxedOffer(E message) {
        return this.offer(message);
    }

    @Override
    public E relaxedPoll() {
        return this.poll();
    }

    @Override
    public E relaxedPeek() {
        return this.peek();
    }

    @Override
    public int drain(MessagePassingQueue.Consumer<E> c) {
        return this.drain(c, this.capacity());
    }

    @Override
    public int fill(MessagePassingQueue.Supplier<E> s) {
        return this.fill(s, this.capacity());
    }

    @Override
    public int drain(MessagePassingQueue.Consumer<E> c, int limit) {
        Object[] buffer = this.buffer;
        long mask = this.mask;
        long consumerIndex = this.consumerIndex;
        for (int i = 0; i < limit; ++i) {
            long index = consumerIndex + (long)i;
            long offset = SpscArrayQueue.calcElementOffset(index, mask);
            Object e = UnsafeRefArrayAccess.lvElement(buffer, offset);
            if (null == e) {
                return i;
            }
            UnsafeRefArrayAccess.soElement(buffer, offset, null);
            this.soConsumerIndex(index + 1L);
            c.accept(e);
        }
        return limit;
    }

    @Override
    public int fill(MessagePassingQueue.Supplier<E> s, int limit) {
        Object[] buffer = this.buffer;
        long mask = this.mask;
        int lookAheadStep = this.lookAheadStep;
        long producerIndex = this.producerIndex;
        for (int i = 0; i < limit; ++i) {
            long index = producerIndex + (long)i;
            long lookAheadElementOffset = SpscArrayQueue.calcElementOffset(index + (long)lookAheadStep, mask);
            if (null == UnsafeRefArrayAccess.lvElement(buffer, lookAheadElementOffset)) {
                int lookAheadLimit = Math.min(lookAheadStep, limit - i);
                for (int j = 0; j < lookAheadLimit; ++j) {
                    long offset = SpscArrayQueue.calcElementOffset(index + (long)j, mask);
                    UnsafeRefArrayAccess.soElement(buffer, offset, s.get());
                    this.soProducerIndex(index + (long)j + 1L);
                }
                i += lookAheadLimit - 1;
                continue;
            }
            long offset = SpscArrayQueue.calcElementOffset(index, mask);
            if (null != UnsafeRefArrayAccess.lvElement(buffer, offset)) {
                return i;
            }
            UnsafeRefArrayAccess.soElement(buffer, offset, s.get());
            this.soProducerIndex(index + 1L);
        }
        return limit;
    }

    @Override
    public void drain(MessagePassingQueue.Consumer<E> c, MessagePassingQueue.WaitStrategy w, MessagePassingQueue.ExitCondition exit) {
        Object[] buffer = this.buffer;
        long mask = this.mask;
        long consumerIndex = this.consumerIndex;
        int counter = 0;
        while (exit.keepRunning()) {
            for (int i = 0; i < 4096; ++i) {
                long offset = SpscArrayQueue.calcElementOffset(consumerIndex, mask);
                Object e = UnsafeRefArrayAccess.lvElement(buffer, offset);
                if (null == e) {
                    counter = w.idle(counter);
                    continue;
                }
                counter = 0;
                UnsafeRefArrayAccess.soElement(buffer, offset, null);
                this.soConsumerIndex(++consumerIndex);
                c.accept(e);
            }
        }
    }

    @Override
    public void fill(MessagePassingQueue.Supplier<E> s, MessagePassingQueue.WaitStrategy w, MessagePassingQueue.ExitCondition e) {
        Object[] buffer = this.buffer;
        long mask = this.mask;
        int lookAheadStep = this.lookAheadStep;
        long producerIndex = this.producerIndex;
        int counter = 0;
        while (e.keepRunning()) {
            long lookAheadElementOffset = SpscArrayQueue.calcElementOffset(producerIndex + (long)lookAheadStep, mask);
            if (null == UnsafeRefArrayAccess.lvElement(buffer, lookAheadElementOffset)) {
                for (int j = 0; j < lookAheadStep; ++j) {
                    long offset = SpscArrayQueue.calcElementOffset(producerIndex, mask);
                    UnsafeRefArrayAccess.soElement(buffer, offset, s.get());
                    this.soProducerIndex(++producerIndex);
                }
                continue;
            }
            long offset = SpscArrayQueue.calcElementOffset(producerIndex, mask);
            if (null != UnsafeRefArrayAccess.lvElement(buffer, offset)) {
                counter = w.idle(counter);
                continue;
            }
            counter = 0;
            UnsafeRefArrayAccess.soElement(buffer, offset, s.get());
            this.soProducerIndex(++producerIndex);
        }
    }
}

