/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.deps.org.jctools.queues;

import com.couchbase.client.core.deps.org.jctools.queues.MessagePassingQueue;
import com.couchbase.client.core.deps.org.jctools.queues.SpmcArrayQueueL3Pad;
import com.couchbase.client.core.deps.org.jctools.util.PortableJvmInfo;
import com.couchbase.client.core.deps.org.jctools.util.UnsafeRefArrayAccess;

public class SpmcArrayQueue<E>
extends SpmcArrayQueueL3Pad<E> {
    public SpmcArrayQueue(int capacity) {
        super(capacity);
    }

    @Override
    public boolean offer(E e) {
        if (null == e) {
            throw new NullPointerException();
        }
        Object[] buffer = this.buffer;
        long mask = this.mask;
        long currProducerIndex = this.lvProducerIndex();
        long offset = SpmcArrayQueue.calcElementOffset(currProducerIndex, mask);
        if (null != UnsafeRefArrayAccess.lvElement(buffer, offset)) {
            long size = currProducerIndex - this.lvConsumerIndex();
            if (size > mask) {
                return false;
            }
            while (null != UnsafeRefArrayAccess.lvElement(buffer, offset)) {
            }
        }
        UnsafeRefArrayAccess.spElement(buffer, offset, e);
        this.soProducerIndex(currProducerIndex + 1L);
        return true;
    }

    @Override
    public E poll() {
        long currentConsumerIndex;
        long currProducerIndexCache = this.lvProducerIndexCache();
        do {
            if ((currentConsumerIndex = this.lvConsumerIndex()) < currProducerIndexCache) continue;
            long currProducerIndex = this.lvProducerIndex();
            if (currentConsumerIndex >= currProducerIndex) {
                return null;
            }
            currProducerIndexCache = currProducerIndex;
            this.svProducerIndexCache(currProducerIndex);
        } while (!this.casConsumerIndex(currentConsumerIndex, currentConsumerIndex + 1L));
        return (E)this.removeElement(this.buffer, currentConsumerIndex, this.mask);
    }

    private E removeElement(E[] buffer, long index, long mask) {
        long offset = SpmcArrayQueue.calcElementOffset(index, mask);
        E e = UnsafeRefArrayAccess.lpElement(buffer, offset);
        UnsafeRefArrayAccess.soElement(buffer, offset, null);
        return e;
    }

    @Override
    public E peek() {
        long currentConsumerIndex;
        Object e;
        long mask = this.mask;
        long currProducerIndexCache = this.lvProducerIndexCache();
        do {
            if ((currentConsumerIndex = this.lvConsumerIndex()) < currProducerIndexCache) continue;
            long currProducerIndex = this.lvProducerIndex();
            if (currentConsumerIndex >= currProducerIndex) {
                return null;
            }
            this.svProducerIndexCache(currProducerIndex);
        } while (null == (e = UnsafeRefArrayAccess.lvElement(this.buffer, SpmcArrayQueue.calcElementOffset(currentConsumerIndex, mask))));
        return (E)e;
    }

    @Override
    public boolean relaxedOffer(E e) {
        if (null == e) {
            throw new NullPointerException("Null is not a valid element");
        }
        Object[] buffer = this.buffer;
        long mask = this.mask;
        long producerIndex = this.lvProducerIndex();
        long offset = SpmcArrayQueue.calcElementOffset(producerIndex, mask);
        if (null != UnsafeRefArrayAccess.lvElement(buffer, offset)) {
            return false;
        }
        UnsafeRefArrayAccess.spElement(buffer, offset, e);
        this.soProducerIndex(producerIndex + 1L);
        return true;
    }

    @Override
    public E relaxedPoll() {
        return this.poll();
    }

    @Override
    public E relaxedPeek() {
        Object[] buffer = this.buffer;
        long mask = this.mask;
        long consumerIndex = this.lvConsumerIndex();
        return (E)UnsafeRefArrayAccess.lvElement(buffer, SpmcArrayQueue.calcElementOffset(consumerIndex, mask));
    }

    @Override
    public int drain(MessagePassingQueue.Consumer<E> c) {
        int sum;
        int drained;
        int capacity = this.capacity();
        for (sum = 0; sum < capacity; sum += drained) {
            drained = 0;
            drained = this.drain(c, PortableJvmInfo.RECOMENDED_POLL_BATCH);
            if (drained == 0) break;
        }
        return sum;
    }

    @Override
    public int fill(MessagePassingQueue.Supplier<E> s) {
        return this.fill(s, this.capacity());
    }

    @Override
    public int drain(MessagePassingQueue.Consumer<E> c, int limit) {
        int remaining;
        long currentConsumerIndex;
        Object[] buffer = this.buffer;
        long mask = this.mask;
        long currProducerIndexCache = this.lvProducerIndexCache();
        int adjustedLimit = 0;
        do {
            if ((currentConsumerIndex = this.lvConsumerIndex()) < currProducerIndexCache) continue;
            long currProducerIndex = this.lvProducerIndex();
            if (currentConsumerIndex >= currProducerIndex) {
                return 0;
            }
            currProducerIndexCache = currProducerIndex;
            this.svProducerIndexCache(currProducerIndex);
        } while (!this.casConsumerIndex(currentConsumerIndex, currentConsumerIndex + (long)(adjustedLimit = Math.min(remaining = (int)(currProducerIndexCache - currentConsumerIndex), limit))));
        for (int i = 0; i < adjustedLimit; ++i) {
            c.accept(this.removeElement(buffer, currentConsumerIndex + (long)i, mask));
        }
        return adjustedLimit;
    }

    @Override
    public int fill(MessagePassingQueue.Supplier<E> s, int limit) {
        Object[] buffer = this.buffer;
        long mask = this.mask;
        long producerIndex = this.producerIndex;
        for (int i = 0; i < limit; ++i) {
            long offset = SpmcArrayQueue.calcElementOffset(producerIndex, mask);
            if (null != UnsafeRefArrayAccess.lvElement(buffer, offset)) {
                return i;
            }
            UnsafeRefArrayAccess.soElement(buffer, offset, s.get());
            this.soProducerIndex(++producerIndex);
        }
        return limit;
    }

    @Override
    public void drain(MessagePassingQueue.Consumer<E> c, MessagePassingQueue.WaitStrategy w, MessagePassingQueue.ExitCondition exit) {
        int idleCounter = 0;
        while (exit.keepRunning()) {
            if (this.drain(c, PortableJvmInfo.RECOMENDED_POLL_BATCH) == 0) {
                idleCounter = w.idle(idleCounter);
                continue;
            }
            idleCounter = 0;
        }
    }

    @Override
    public void fill(MessagePassingQueue.Supplier<E> s, MessagePassingQueue.WaitStrategy w, MessagePassingQueue.ExitCondition e) {
        Object[] buffer = this.buffer;
        long mask = this.mask;
        long producerIndex = this.producerIndex;
        int counter = 0;
        while (e.keepRunning()) {
            for (int i = 0; i < 4096; ++i) {
                long offset = SpmcArrayQueue.calcElementOffset(producerIndex, mask);
                if (null != UnsafeRefArrayAccess.lvElement(buffer, offset)) {
                    counter = w.idle(counter);
                    continue;
                }
                counter = 0;
                UnsafeRefArrayAccess.soElement(buffer, offset, s.get());
                this.soProducerIndex(++producerIndex);
            }
        }
    }
}

