/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.node;

import com.couchbase.client.core.config.BucketConfig;
import com.couchbase.client.core.config.ClusterConfig;
import com.couchbase.client.core.config.CouchbaseBucketConfig;
import com.couchbase.client.core.config.MemcachedBucketConfig;
import com.couchbase.client.core.error.FeatureNotAvailableException;
import com.couchbase.client.core.msg.Request;
import com.couchbase.client.core.msg.Response;
import com.couchbase.client.core.msg.ScopedRequest;
import com.couchbase.client.core.node.Node;
import com.couchbase.client.core.node.RoundRobinLocator;
import com.couchbase.client.core.service.ServiceType;

public class ViewLocator
extends RoundRobinLocator {
    public ViewLocator() {
        super(ServiceType.VIEWS);
    }

    @Override
    protected boolean checkServiceNotAvailable(Request<? extends Response> request, ClusterConfig config) {
        if (request instanceof ScopedRequest) {
            String bucket = ((ScopedRequest)((Object)request)).bucket();
            BucketConfig bucketConfig = config.bucketConfig(bucket);
            if (bucketConfig instanceof MemcachedBucketConfig) {
                request.fail(new FeatureNotAvailableException("Memcached buckets do not support view queries"));
                return false;
            }
            if (bucketConfig instanceof CouchbaseBucketConfig && ((CouchbaseBucketConfig)bucketConfig).ephemeral()) {
                request.fail(new FeatureNotAvailableException("Ephemeral buckets do not support view queries"));
                return false;
            }
        }
        return true;
    }

    @Override
    protected boolean nodeCanBeUsed(Node node, Request<? extends Response> request, ClusterConfig config) {
        if (request instanceof ScopedRequest && config.bucketConfig(((ScopedRequest)((Object)request)).bucket()) instanceof CouchbaseBucketConfig) {
            return ((CouchbaseBucketConfig)config.bucketConfig(((ScopedRequest)((Object)request)).bucket())).hasPrimaryPartitionsOnNode(node.identifier().address());
        }
        return false;
    }
}

