/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.msg.kv;

import com.couchbase.client.core.CoreContext;
import com.couchbase.client.core.cnc.InternalSpan;
import com.couchbase.client.core.deps.io.netty.buffer.ByteBuf;
import com.couchbase.client.core.deps.io.netty.buffer.ByteBufAllocator;
import com.couchbase.client.core.deps.io.netty.util.ReferenceCountUtil;
import com.couchbase.client.core.io.CollectionIdentifier;
import com.couchbase.client.core.io.netty.kv.KeyValueChannelContext;
import com.couchbase.client.core.io.netty.kv.MemcacheProtocol;
import com.couchbase.client.core.msg.kv.BaseKeyValueRequest;
import com.couchbase.client.core.msg.kv.UnlockResponse;
import com.couchbase.client.core.retry.RetryStrategy;
import java.time.Duration;
import java.util.Optional;

public class UnlockRequest
extends BaseKeyValueRequest<UnlockResponse> {
    public static final String OPERATION_NAME = "unlock";
    private final long cas;

    public UnlockRequest(Duration timeout, CoreContext ctx, CollectionIdentifier collectionIdentifier, RetryStrategy retryStrategy, String key, long cas, InternalSpan span) {
        super(timeout, ctx, retryStrategy, key, collectionIdentifier, span);
        this.cas = cas;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ByteBuf encode(ByteBufAllocator alloc, int opaque, KeyValueChannelContext ctx) {
        ByteBuf byteBuf;
        ByteBuf key = null;
        try {
            key = this.encodedKeyWithCollection(alloc, ctx);
            byteBuf = MemcacheProtocol.request(alloc, MemcacheProtocol.Opcode.UNLOCK, MemcacheProtocol.noDatatype(), this.partition(), opaque, this.cas, MemcacheProtocol.noExtras(), key, MemcacheProtocol.noBody());
        }
        catch (Throwable throwable) {
            ReferenceCountUtil.release(key);
            throw throwable;
        }
        ReferenceCountUtil.release(key);
        return byteBuf;
    }

    @Override
    public UnlockResponse decode(ByteBuf response, KeyValueChannelContext ctx) {
        return new UnlockResponse(MemcacheProtocol.decodeStatus(response), MemcacheProtocol.cas(response), Optional.empty());
    }
}

