/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.msg.kv;

import com.couchbase.client.core.CoreContext;
import com.couchbase.client.core.cnc.InternalSpan;
import com.couchbase.client.core.deps.io.netty.buffer.ByteBuf;
import com.couchbase.client.core.deps.io.netty.buffer.ByteBufAllocator;
import com.couchbase.client.core.deps.io.netty.buffer.Unpooled;
import com.couchbase.client.core.deps.io.netty.util.ReferenceCountUtil;
import com.couchbase.client.core.env.CompressionConfig;
import com.couchbase.client.core.error.DurabilityLevelNotAvailableException;
import com.couchbase.client.core.error.context.KeyValueErrorContext;
import com.couchbase.client.core.io.CollectionIdentifier;
import com.couchbase.client.core.io.netty.kv.KeyValueChannelContext;
import com.couchbase.client.core.io.netty.kv.MemcacheProtocol;
import com.couchbase.client.core.msg.ResponseStatus;
import com.couchbase.client.core.msg.kv.BaseKeyValueRequest;
import com.couchbase.client.core.msg.kv.DurabilityLevel;
import com.couchbase.client.core.msg.kv.ReplaceResponse;
import com.couchbase.client.core.msg.kv.SyncDurabilityRequest;
import com.couchbase.client.core.retry.RetryStrategy;
import java.time.Duration;
import java.util.Optional;

public class ReplaceRequest
extends BaseKeyValueRequest<ReplaceResponse>
implements SyncDurabilityRequest {
    public static final String OPERATION_NAME = "replace";
    private final byte[] content;
    private final long expiration;
    private final int flags;
    private final long cas;
    private final Optional<DurabilityLevel> syncReplicationType;

    public ReplaceRequest(String key, byte[] content, long expiration, int flags, Duration timeout, long cas, CoreContext ctx, CollectionIdentifier collectionIdentifier, RetryStrategy retryStrategy, Optional<DurabilityLevel> syncReplicationType, InternalSpan span) {
        super(timeout, ctx, retryStrategy, key, collectionIdentifier, span);
        this.content = content;
        this.expiration = expiration;
        this.flags = flags;
        this.cas = cas;
        this.syncReplicationType = syncReplicationType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public ByteBuf encode(ByteBufAllocator alloc, int opaque, KeyValueChannelContext ctx) {
        ByteBuf byteBuf;
        ByteBuf key = null;
        ByteBuf content = null;
        ByteBuf extras = null;
        ByteBuf flexibleExtras = null;
        try {
            ByteBuf request;
            key = this.encodedKeyWithCollection(alloc, ctx);
            byte datatype = 0;
            CompressionConfig config = ctx.compressionConfig();
            if (config != null && config.enabled() && this.content.length >= config.minSize()) {
                ByteBuf maybeCompressed = MemcacheProtocol.tryCompression(this.content, config.minRatio());
                if (maybeCompressed != null) {
                    datatype = (byte)(datatype | MemcacheProtocol.Datatype.SNAPPY.datatype());
                    content = maybeCompressed;
                } else {
                    content = Unpooled.wrappedBuffer(this.content);
                }
            } else {
                content = Unpooled.wrappedBuffer(this.content);
            }
            extras = alloc.buffer(8);
            extras.writeInt(this.flags);
            extras.writeInt((int)this.expiration);
            if (this.syncReplicationType.isPresent()) {
                if (!ctx.syncReplicationEnabled()) throw new DurabilityLevelNotAvailableException(KeyValueErrorContext.incompleteRequest(this));
                flexibleExtras = MemcacheProtocol.flexibleSyncReplication(alloc, this.syncReplicationType.get(), this.timeout(), this.context());
                request = MemcacheProtocol.flexibleRequest(alloc, MemcacheProtocol.Opcode.REPLACE, datatype, this.partition(), opaque, this.cas, flexibleExtras, extras, key, content);
            } else {
                request = MemcacheProtocol.request(alloc, MemcacheProtocol.Opcode.REPLACE, datatype, this.partition(), opaque, this.cas, extras, key, content);
            }
            byteBuf = request;
        }
        catch (Throwable throwable) {
            ReferenceCountUtil.release(key);
            ReferenceCountUtil.release(extras);
            ReferenceCountUtil.release(flexibleExtras);
            ReferenceCountUtil.release(content);
            throw throwable;
        }
        ReferenceCountUtil.release(key);
        ReferenceCountUtil.release(extras);
        ReferenceCountUtil.release(flexibleExtras);
        ReferenceCountUtil.release(content);
        return byteBuf;
    }

    @Override
    public ReplaceResponse decode(ByteBuf response, KeyValueChannelContext ctx) {
        ResponseStatus status = MemcacheProtocol.decodeStatus(response);
        return new ReplaceResponse(status, MemcacheProtocol.cas(response), MemcacheProtocol.extractToken(ctx.mutationTokensEnabled(), this.partition(), response, ctx.bucket().get()));
    }

    @Override
    public Optional<DurabilityLevel> durabilityLevel() {
        return this.syncReplicationType;
    }
}

