/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.io.netty.kv;

import com.couchbase.client.core.cnc.events.io.InvalidPacketDetectedEvent;
import com.couchbase.client.core.deps.io.netty.buffer.ByteBuf;
import com.couchbase.client.core.deps.io.netty.channel.ChannelDuplexHandler;
import com.couchbase.client.core.deps.io.netty.channel.ChannelHandlerContext;
import com.couchbase.client.core.deps.io.netty.channel.ChannelPromise;
import com.couchbase.client.core.deps.io.netty.util.ReferenceCountUtil;
import com.couchbase.client.core.endpoint.EndpointContext;
import com.couchbase.client.core.io.IoContext;
import com.couchbase.client.core.io.netty.kv.MemcacheProtocol;

public class MemcacheProtocolVerificationHandler
extends ChannelDuplexHandler {
    private final EndpointContext endpointContext;

    public MemcacheProtocolVerificationHandler(EndpointContext endpointContext) {
        this.endpointContext = endpointContext;
    }

    @Override
    public void write(ChannelHandlerContext ctx, Object request, ChannelPromise promise) {
        if (request instanceof ByteBuf && !MemcacheProtocol.verifyRequest((ByteBuf)request)) {
            this.handleEventAndCloseChannel(ctx, (ByteBuf)request);
            return;
        }
        ctx.write(request, promise);
    }

    @Override
    public void channelRead(ChannelHandlerContext ctx, Object response) {
        if (response instanceof ByteBuf && !MemcacheProtocol.verifyResponse((ByteBuf)response)) {
            this.handleEventAndCloseChannel(ctx, (ByteBuf)response);
            return;
        }
        ctx.fireChannelRead(response);
    }

    private void handleEventAndCloseChannel(ChannelHandlerContext ctx, ByteBuf msg) {
        IoContext ioContext = new IoContext(this.endpointContext, ctx.channel().localAddress(), ctx.channel().remoteAddress(), this.endpointContext.bucket());
        byte[] packet = new byte[msg.readableBytes()];
        msg.readBytes(packet);
        ReferenceCountUtil.release(msg);
        this.endpointContext.environment().eventBus().publish(new InvalidPacketDetectedEvent(ioContext, packet));
        ctx.close();
    }
}

