/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.io.netty;

import com.couchbase.client.core.cnc.EventBus;
import com.couchbase.client.core.cnc.events.io.ChannelClosedProactivelyEvent;
import com.couchbase.client.core.cnc.events.io.InvalidRequestDetectedEvent;
import com.couchbase.client.core.cnc.events.io.UnsupportedResponseTypeReceivedEvent;
import com.couchbase.client.core.deps.io.netty.channel.ChannelDuplexHandler;
import com.couchbase.client.core.deps.io.netty.channel.ChannelHandler;
import com.couchbase.client.core.deps.io.netty.channel.ChannelHandlerContext;
import com.couchbase.client.core.deps.io.netty.channel.ChannelPromise;
import com.couchbase.client.core.deps.io.netty.handler.codec.http.FullHttpRequest;
import com.couchbase.client.core.deps.io.netty.handler.codec.http.FullHttpResponse;
import com.couchbase.client.core.deps.io.netty.handler.codec.http.HttpHeaderNames;
import com.couchbase.client.core.deps.io.netty.handler.codec.http.HttpObjectAggregator;
import com.couchbase.client.core.deps.io.netty.handler.codec.http.HttpResponseStatus;
import com.couchbase.client.core.deps.io.netty.util.ReferenceCountUtil;
import com.couchbase.client.core.deps.io.netty.util.concurrent.Future;
import com.couchbase.client.core.deps.io.netty.util.concurrent.GenericFutureListener;
import com.couchbase.client.core.endpoint.BaseEndpoint;
import com.couchbase.client.core.endpoint.EndpointContext;
import com.couchbase.client.core.io.IoContext;
import com.couchbase.client.core.io.netty.HandlerUtils;
import com.couchbase.client.core.io.netty.HttpChannelContext;
import com.couchbase.client.core.io.netty.HttpProtocol;
import com.couchbase.client.core.msg.NonChunkedHttpRequest;
import com.couchbase.client.core.msg.Request;
import com.couchbase.client.core.msg.Response;
import com.couchbase.client.core.msg.ResponseStatus;
import com.couchbase.client.core.retry.RetryOrchestrator;
import com.couchbase.client.core.retry.RetryReason;
import com.couchbase.client.core.service.ServiceType;
import java.nio.charset.StandardCharsets;

@ChannelHandler.Sharable
public abstract class NonChunkedHttpMessageHandler
extends ChannelDuplexHandler {
    static final String IDENTIFIER = NonChunkedHttpMessageHandler.class.getSimpleName();
    private static final String AGG_IDENTIFIER = HttpObjectAggregator.class.getSimpleName();
    private final EventBus eventBus;
    private final ServiceType serviceType;
    private NonChunkedHttpRequest<Response> currentRequest;
    private String remoteHost;
    private IoContext ioContext;
    private final BaseEndpoint endpoint;
    private final EndpointContext endpointContext;
    private long dispatchTimingStart;
    private HttpChannelContext channelContext;

    protected NonChunkedHttpMessageHandler(BaseEndpoint endpoint, ServiceType serviceType) {
        this.endpoint = endpoint;
        this.endpointContext = endpoint.context();
        this.eventBus = this.endpointContext.environment().eventBus();
        this.serviceType = serviceType;
    }

    protected abstract Exception failRequestWith(HttpResponseStatus var1, String var2);

    @Override
    public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) {
        if (this.currentRequest != null) {
            RetryOrchestrator.maybeRetry(this.endpointContext, (Request)msg, RetryReason.NOT_PIPELINED_REQUEST_IN_FLIGHT);
            if (this.endpoint != null) {
                this.endpoint.decrementOutstandingRequests();
            }
            return;
        }
        if (msg instanceof NonChunkedHttpRequest) {
            try {
                this.currentRequest = (NonChunkedHttpRequest)msg;
                FullHttpRequest encoded = (FullHttpRequest)((NonChunkedHttpRequest)msg).encode();
                encoded.headers().set((CharSequence)HttpHeaderNames.HOST, (Object)this.remoteHost);
                encoded.headers().set((CharSequence)HttpHeaderNames.USER_AGENT, (Object)this.endpointContext.environment().userAgent().formattedLong());
                this.dispatchTimingStart = System.nanoTime();
                if (this.currentRequest.internalSpan() != null) {
                    this.currentRequest.internalSpan().startDispatch();
                }
                ctx.write(encoded, promise);
            }
            catch (Throwable t) {
                this.currentRequest.response().completeExceptionally(t);
                if (this.endpoint != null) {
                    this.endpoint.decrementOutstandingRequests();
                }
            }
        } else {
            if (this.endpoint != null) {
                this.endpoint.decrementOutstandingRequests();
            }
            this.eventBus.publish(new InvalidRequestDetectedEvent(this.ioContext, this.serviceType, msg));
            ctx.channel().close().addListener((GenericFutureListener<? extends Future<? super Void>>)((GenericFutureListener<Future>)f -> this.eventBus.publish(new ChannelClosedProactivelyEvent(this.ioContext, ChannelClosedProactivelyEvent.Reason.INVALID_REQUEST_DETECTED))));
        }
    }

    @Override
    public void channelActive(ChannelHandlerContext ctx) throws Exception {
        this.ioContext = new IoContext(this.endpointContext, ctx.channel().localAddress(), ctx.channel().remoteAddress(), this.endpointContext.bucket());
        this.channelContext = new HttpChannelContext(ctx.channel().id());
        this.remoteHost = HttpProtocol.remoteHttpHost(ctx.channel().remoteAddress());
        ctx.pipeline().get(HttpObjectAggregator.class).channelActive(ctx);
        ctx.fireChannelActive();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void channelRead(ChannelHandlerContext ctx, Object msg) {
        block14: {
            try {
                if (msg instanceof FullHttpResponse) {
                    try {
                        this.currentRequest.context().dispatchLatency(System.nanoTime() - this.dispatchTimingStart);
                        if (this.currentRequest.internalSpan() != null) {
                            this.currentRequest.internalSpan().stopDispatch();
                        }
                        FullHttpResponse httpResponse = (FullHttpResponse)msg;
                        ResponseStatus responseStatus = HttpProtocol.decodeStatus(httpResponse.status());
                        if (!this.currentRequest.completed()) {
                            if (responseStatus == ResponseStatus.SUCCESS) {
                                Response response = this.currentRequest.decode(httpResponse, this.channelContext);
                                this.currentRequest.succeed(response);
                            } else {
                                String body = httpResponse.content().toString(StandardCharsets.UTF_8);
                                this.currentRequest.fail(this.failRequestWith(httpResponse.status(), body));
                            }
                        } else {
                            this.ioContext.environment().orphanReporter().report(this.currentRequest);
                        }
                        this.currentRequest = null;
                        this.endpoint.markRequestCompletion();
                        break block14;
                    }
                    catch (Throwable ex) {
                        try {
                            this.currentRequest.fail(ex);
                            break block14;
                        }
                        catch (Throwable throwable) {
                            throw throwable;
                        }
                        finally {
                            this.currentRequest = null;
                            this.endpoint.markRequestCompletion();
                        }
                    }
                }
                this.ioContext.environment().eventBus().publish(new UnsupportedResponseTypeReceivedEvent(this.ioContext, msg));
                HandlerUtils.closeChannelWithReason(this.ioContext, ctx, ChannelClosedProactivelyEvent.Reason.INVALID_RESPONSE_FORMAT_DETECTED);
            }
            finally {
                ReferenceCountUtil.release(msg);
            }
        }
    }

    @Override
    public void handlerAdded(ChannelHandlerContext ctx) {
        ctx.pipeline().addBefore(IDENTIFIER, AGG_IDENTIFIER, new HttpObjectAggregator(Integer.MAX_VALUE));
    }

    @Override
    public void channelInactive(ChannelHandlerContext ctx) {
        if (this.currentRequest != null) {
            RetryOrchestrator.maybeRetry(this.ioContext, this.currentRequest, RetryReason.CHANNEL_CLOSED_WHILE_IN_FLIGHT);
        }
        ctx.fireChannelInactive();
    }

    @Override
    public void handlerRemoved(ChannelHandlerContext ctx) {
        ctx.pipeline().remove(HttpObjectAggregator.class);
    }
}

