/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.cnc.events.io;

import com.couchbase.client.core.cnc.AbstractEvent;
import com.couchbase.client.core.cnc.Context;
import com.couchbase.client.core.cnc.Event;
import com.couchbase.client.core.deps.io.netty.buffer.ByteBufUtil;
import com.couchbase.client.core.deps.io.netty.buffer.Unpooled;
import com.couchbase.client.core.io.IoContext;
import java.time.Duration;

public class SaslAuthenticationFailedEvent
extends AbstractEvent {
    private final String description;
    private final byte[] lastPacket;

    public SaslAuthenticationFailedEvent(Duration duration, IoContext context, String description, byte[] lastPacket) {
        super(Event.Severity.ERROR, Event.Category.IO, duration, (Context)context);
        this.description = description;
        this.lastPacket = lastPacket;
    }

    @Override
    public String description() {
        if (this.lastPacket != null && this.lastPacket.length > 0) {
            return this.description + "; Last Packet: \n" + ByteBufUtil.prettyHexDump(Unpooled.copiedBuffer(this.lastPacket)) + "\n";
        }
        return this.description;
    }

    public byte[] lastPacket() {
        return this.lastPacket;
    }
}

