/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.msg;

import com.couchbase.client.core.deps.com.fasterxml.jackson.annotation.JsonValue;
import com.couchbase.client.core.retry.RetryReason;
import java.util.Objects;

public class CancellationReason {
    public static final CancellationReason STOPPED_LISTENING = new CancellationReason("STOPPED_LISTENING", null);
    public static final CancellationReason TIMEOUT = new CancellationReason("TIMEOUT", null);
    public static final CancellationReason CANCELLED_VIA_CONTEXT = new CancellationReason("CANCELLED_VIA_CONTEXT", null);
    public static final CancellationReason SHUTDOWN = new CancellationReason("SHUTDOWN", null);
    public static final CancellationReason OTHER = new CancellationReason("OTHER", null);
    public static final CancellationReason TOO_MANY_REQUESTS_IN_RETRY = new CancellationReason("TOO_MANY_REQUESTS_IN_RETRY", null);
    private final String identifier;
    private final Object innerReason;

    private CancellationReason(String identifier, Object innerReason) {
        this.innerReason = innerReason;
        this.identifier = identifier;
    }

    public static CancellationReason noMoreRetries(RetryReason retryReason) {
        return new CancellationReason("NO_MORE_RETRIES", (Object)retryReason);
    }

    public Object innerReason() {
        return this.innerReason;
    }

    public String identifier() {
        return this.identifier;
    }

    @JsonValue
    public String toString() {
        String inner = this.innerReason != null ? " (" + this.innerReason.toString() + ")" : "";
        return this.identifier + inner;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CancellationReason that = (CancellationReason)o;
        return Objects.equals(this.identifier, that.identifier) && Objects.equals(this.innerReason, that.innerReason);
    }

    public int hashCode() {
        return Objects.hash(this.identifier, this.innerReason);
    }
}

