/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.error.context;

import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.error.context.ErrorContext;
import com.couchbase.client.core.logging.RedactableArgument;
import java.util.Map;

@Stability.Uncommitted
public class ReducedSearchErrorContext
extends ErrorContext {
    private final String indexName;
    private final Map<String, Object> searchQuery;

    public ReducedSearchErrorContext(String indexName, Map<String, Object> searchQuery) {
        super(null);
        this.indexName = indexName;
        this.searchQuery = searchQuery;
    }

    @Override
    public void injectExportableParams(Map<String, Object> input) {
        super.injectExportableParams(input);
        if (this.indexName != null) {
            input.put("indexName", RedactableArgument.redactMeta(this.indexName));
        }
        if (this.searchQuery != null) {
            input.put("query", RedactableArgument.redactUser(this.searchQuery));
        }
    }
}

