/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.error;

import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.error.CouchbaseException;
import com.couchbase.client.core.logging.RedactableArgument;
import java.util.Objects;

@Stability.Volatile
public class BucketNotFoundException
extends CouchbaseException {
    private final String bucketName;

    BucketNotFoundException(String bucketName) {
        super("Bucket [" + RedactableArgument.redactMeta(bucketName) + "] not found.");
        this.bucketName = Objects.requireNonNull(bucketName);
    }

    public static BucketNotFoundException forBucket(String bucketName) {
        return new BucketNotFoundException(bucketName);
    }

    public String bucketName() {
        return this.bucketName;
    }
}

