/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.utils.yasjl;

import com.couchbase.client.core.utils.yasjl.Callbacks.JsonPointerCB;
import com.couchbase.client.core.utils.yasjl.Callbacks.JsonPointerCB1;
import com.couchbase.client.core.utils.yasjl.Callbacks.JsonPointerCB2;
import com.couchbase.client.core.utils.yasjl.JsonArrayByteBufProcessor;
import com.couchbase.client.core.utils.yasjl.JsonBOMByteBufProcessor;
import com.couchbase.client.core.utils.yasjl.JsonBooleanFalseByteBufProcessor;
import com.couchbase.client.core.utils.yasjl.JsonBooleanTrueByteBufProcessor;
import com.couchbase.client.core.utils.yasjl.JsonNullByteBufProcessor;
import com.couchbase.client.core.utils.yasjl.JsonNumberByteBufProcessor;
import com.couchbase.client.core.utils.yasjl.JsonObjectByteBufProcessor;
import com.couchbase.client.core.utils.yasjl.JsonParserUtils;
import com.couchbase.client.core.utils.yasjl.JsonPointer;
import com.couchbase.client.core.utils.yasjl.JsonPointerTree;
import com.couchbase.client.core.utils.yasjl.JsonStringByteBufProcessor;
import com.couchbase.client.core.utils.yasjl.JsonWhiteSpaceByteBufProcessor;
import com.couchbase.client.deps.io.netty.buffer.ByteBuf;
import com.couchbase.client.deps.io.netty.buffer.ByteBufProcessor;
import java.io.EOFException;
import java.nio.charset.Charset;
import java.util.ArrayDeque;
import java.util.Deque;

public class ByteBufJsonParser {
    private static final EOFException NEED_MORE_DATA = new EOFException();
    private final JsonPointerTree tree;
    private final Deque<JsonLevel> levelStack;
    private final JsonWhiteSpaceByteBufProcessor wsProcessor = new JsonWhiteSpaceByteBufProcessor();
    private final JsonStringByteBufProcessor stProcessor = new JsonStringByteBufProcessor();
    private final JsonArrayByteBufProcessor arProcessor = new JsonArrayByteBufProcessor(this.stProcessor);
    private final JsonObjectByteBufProcessor obProcessor = new JsonObjectByteBufProcessor(this.stProcessor);
    private final JsonNullByteBufProcessor nullProcessor = new JsonNullByteBufProcessor();
    private final JsonBOMByteBufProcessor bomProcessor = new JsonBOMByteBufProcessor();
    private final JsonNumberByteBufProcessor numProcessor = new JsonNumberByteBufProcessor();
    private final JsonBooleanTrueByteBufProcessor trueProcessor = new JsonBooleanTrueByteBufProcessor();
    private final JsonBooleanFalseByteBufProcessor falseProcessor = new JsonBooleanFalseByteBufProcessor();
    private ByteBuf content;
    private byte currentChar;
    private boolean startedStreaming;

    public ByteBufJsonParser(JsonPointer[] jsonPointers) {
        this.levelStack = new ArrayDeque<JsonLevel>();
        this.tree = new JsonPointerTree();
        for (JsonPointer jp : jsonPointers) {
            this.tree.addJsonPointer(jp);
        }
    }

    public void initialize(ByteBuf content) {
        this.content = content;
        this.startedStreaming = false;
    }

    public void parse() throws EOFException {
        if (!this.startedStreaming && this.levelStack.isEmpty()) {
            this.readNextChar(null);
            switch (this.currentChar) {
                case -17: {
                    this.pushLevel(JsonParserUtils.Mode.BOM);
                    break;
                }
                case 123: {
                    this.pushLevel(JsonParserUtils.Mode.JSON_OBJECT);
                    break;
                }
                case 91: {
                    this.pushLevel(JsonParserUtils.Mode.JSON_ARRAY);
                    break;
                }
                default: {
                    throw new IllegalStateException("Only UTF-8 is supported");
                }
            }
            this.startedStreaming = true;
        }
        while (!this.levelStack.isEmpty()) {
            JsonLevel currentLevel = this.levelStack.peek();
            switch (currentLevel.peekMode()) {
                case BOM: {
                    this.readBOM();
                    break;
                }
                case JSON_OBJECT: {
                    this.readObject(currentLevel);
                    break;
                }
                case JSON_ARRAY: {
                    this.readArray(currentLevel);
                    break;
                }
                case JSON_OBJECT_VALUE: 
                case JSON_ARRAY_VALUE: 
                case JSON_STRING_HASH_KEY: 
                case JSON_STRING_VALUE: 
                case JSON_BOOLEAN_TRUE_VALUE: 
                case JSON_BOOLEAN_FALSE_VALUE: 
                case JSON_NUMBER_VALUE: 
                case JSON_NULL_VALUE: {
                    this.readValue(currentLevel);
                }
            }
        }
        return;
    }

    private void pushLevel(JsonParserUtils.Mode mode) {
        JsonLevel newJsonLevel = null;
        if (mode == JsonParserUtils.Mode.BOM) {
            newJsonLevel = new JsonLevel(mode, new JsonPointer());
        } else if (mode == JsonParserUtils.Mode.JSON_OBJECT) {
            if (this.levelStack.size() > 0) {
                JsonLevel current = this.levelStack.peek();
                newJsonLevel = new JsonLevel(mode, new JsonPointer(current.jsonPointer().tokens()));
            } else {
                newJsonLevel = new JsonLevel(mode, new JsonPointer());
            }
        } else if (mode == JsonParserUtils.Mode.JSON_ARRAY) {
            if (this.levelStack.size() > 0) {
                JsonLevel current = this.levelStack.peek();
                newJsonLevel = new JsonLevel(mode, new JsonPointer(current.jsonPointer().tokens()));
            } else {
                newJsonLevel = new JsonLevel(mode, new JsonPointer());
            }
            newJsonLevel.isArray(true);
            newJsonLevel.setArrayIndexOnJsonPointer();
        }
        this.levelStack.push(newJsonLevel);
    }

    private void popAndResetToOldLevel() {
        JsonLevel newTop;
        this.levelStack.pop();
        if (!this.levelStack.isEmpty() && (newTop = this.levelStack.peek()) != null) {
            newTop.removeLastTokenFromJsonPointer();
        }
    }

    private void readObject(JsonLevel level) throws EOFException {
        while (true) {
            this.readNextChar(level);
            if (this.currentChar == 34) {
                if (!level.isHashValue()) {
                    level.pushMode(JsonParserUtils.Mode.JSON_STRING_HASH_KEY);
                } else {
                    level.pushMode(JsonParserUtils.Mode.JSON_STRING_VALUE);
                }
                this.readValue(level);
                continue;
            }
            if (this.currentChar == 58) {
                level.isHashValue(true);
                continue;
            }
            if (this.currentChar == 123) {
                if (!level.isHashValue()) {
                    throw new IllegalStateException("Invalid json, json object can only be a hash value not key");
                }
                if (this.tree.isIntermediaryPath(level.jsonPointer())) {
                    this.pushLevel(JsonParserUtils.Mode.JSON_OBJECT);
                    level.removeLastTokenFromJsonPointer();
                    return;
                }
                level.pushMode(JsonParserUtils.Mode.JSON_OBJECT_VALUE);
                this.readValue(level);
                continue;
            }
            if (this.currentChar == 91) {
                if (!level.isHashValue()) {
                    throw new IllegalStateException("Invalid json, json array can only be a hash value not key");
                }
                if (this.tree.isIntermediaryPath(level.jsonPointer())) {
                    this.pushLevel(JsonParserUtils.Mode.JSON_ARRAY);
                    level.removeLastTokenFromJsonPointer();
                    return;
                }
                level.pushMode(JsonParserUtils.Mode.JSON_ARRAY_VALUE);
                this.readValue(level);
                continue;
            }
            if (this.currentChar == 116) {
                if (!level.isHashValue()) {
                    throw new IllegalStateException("Invalid json, json true can only be a hash value not key");
                }
                level.pushMode(JsonParserUtils.Mode.JSON_BOOLEAN_TRUE_VALUE);
                this.readValue(level);
                continue;
            }
            if (this.currentChar == 102) {
                if (!level.isHashValue()) {
                    throw new IllegalStateException("Invalid json, json false can only be a hash value not key");
                }
                level.pushMode(JsonParserUtils.Mode.JSON_BOOLEAN_FALSE_VALUE);
                this.readValue(level);
                continue;
            }
            if (this.currentChar == 110) {
                if (!level.isHashValue()) {
                    throw new IllegalStateException("Invalid json, json null can only be a hash value not key");
                }
                level.pushMode(JsonParserUtils.Mode.JSON_NULL_VALUE);
                this.readValue(level);
                continue;
            }
            if (JsonParserUtils.isNumber(this.currentChar)) {
                if (!level.isHashValue()) {
                    throw new IllegalStateException("Invalid json, json number can only be a hash value not key");
                }
                level.pushMode(JsonParserUtils.Mode.JSON_NUMBER_VALUE);
                this.readValue(level);
                continue;
            }
            if (this.currentChar == 44) {
                level.isHashValue(false);
                continue;
            }
            if (this.currentChar == 125) break;
        }
        this.popAndResetToOldLevel();
    }

    private void readArray(JsonLevel level) throws EOFException {
        while (true) {
            this.readNextChar(level);
            if (this.currentChar == 34) {
                level.pushMode(JsonParserUtils.Mode.JSON_STRING_VALUE);
                this.readValue(level);
                continue;
            }
            if (this.currentChar == 123) {
                if (this.tree.isIntermediaryPath(level.jsonPointer())) {
                    this.pushLevel(JsonParserUtils.Mode.JSON_OBJECT);
                    return;
                }
                level.pushMode(JsonParserUtils.Mode.JSON_OBJECT_VALUE);
                this.readValue(level);
                continue;
            }
            if (this.currentChar == 91) {
                if (this.tree.isIntermediaryPath(level.jsonPointer())) {
                    this.pushLevel(JsonParserUtils.Mode.JSON_ARRAY);
                    return;
                }
                level.pushMode(JsonParserUtils.Mode.JSON_ARRAY_VALUE);
                this.readValue(level);
                continue;
            }
            if (this.currentChar == 116) {
                level.pushMode(JsonParserUtils.Mode.JSON_BOOLEAN_TRUE_VALUE);
                this.readValue(level);
                continue;
            }
            if (this.currentChar == 102) {
                level.pushMode(JsonParserUtils.Mode.JSON_BOOLEAN_FALSE_VALUE);
                this.readValue(level);
                continue;
            }
            if (this.currentChar == 110) {
                level.pushMode(JsonParserUtils.Mode.JSON_NULL_VALUE);
                this.readValue(level);
                continue;
            }
            if (JsonParserUtils.isNumber(this.currentChar)) {
                level.pushMode(JsonParserUtils.Mode.JSON_NUMBER_VALUE);
                this.readValue(level);
                continue;
            }
            if (this.currentChar == 44) {
                level.updateIndex();
                level.setArrayIndexOnJsonPointer();
                continue;
            }
            if (this.currentChar == 93) break;
        }
        this.popAndResetToOldLevel();
    }

    private void readValue(JsonLevel level) throws EOFException {
        int readerIndex = this.content.readerIndex();
        ByteBufProcessor processor = null;
        JsonParserUtils.Mode mode = level.peekMode();
        switch (mode) {
            case JSON_ARRAY_VALUE: {
                this.arProcessor.reset();
                processor = this.arProcessor;
                break;
            }
            case JSON_OBJECT_VALUE: {
                this.obProcessor.reset();
                processor = this.obProcessor;
                break;
            }
            case JSON_STRING_HASH_KEY: 
            case JSON_STRING_VALUE: {
                processor = this.stProcessor;
                break;
            }
            case JSON_NULL_VALUE: {
                this.nullProcessor.reset();
                processor = this.nullProcessor;
                break;
            }
            case JSON_BOOLEAN_TRUE_VALUE: {
                processor = this.trueProcessor;
                break;
            }
            case JSON_BOOLEAN_FALSE_VALUE: {
                processor = this.falseProcessor;
                break;
            }
            case JSON_NUMBER_VALUE: {
                processor = this.numProcessor;
            }
        }
        boolean shouldSaveValue = this.tree.isTerminalPath(level.jsonPointer()) || mode == JsonParserUtils.Mode.JSON_STRING_HASH_KEY;
        int lastValidIndex = this.content.forEachByte(processor);
        if (lastValidIndex == -1) {
            throw NEED_MORE_DATA;
        }
        if (mode == JsonParserUtils.Mode.JSON_OBJECT_VALUE || mode == JsonParserUtils.Mode.JSON_ARRAY_VALUE || mode == JsonParserUtils.Mode.JSON_STRING_VALUE || mode == JsonParserUtils.Mode.JSON_STRING_HASH_KEY || mode == JsonParserUtils.Mode.JSON_NULL_VALUE || mode == JsonParserUtils.Mode.JSON_BOOLEAN_TRUE_VALUE || mode == JsonParserUtils.Mode.JSON_BOOLEAN_FALSE_VALUE) {
            int length = lastValidIndex - readerIndex + 1;
            if (shouldSaveValue) {
                level.setCurrentValue(this.content.copy(readerIndex - 1, length + 1), length);
                level.emitJsonPointerValue();
            }
            this.content.skipBytes(length);
            this.content.discardReadBytes();
        } else {
            int length = lastValidIndex - readerIndex;
            if (length > 0) {
                if (shouldSaveValue) {
                    level.setCurrentValue(this.content.copy(readerIndex - 1, length + 1), length);
                    level.emitJsonPointerValue();
                }
                this.content.skipBytes(length);
                this.content.discardReadBytes();
            } else {
                length = 1;
                if (shouldSaveValue) {
                    level.setCurrentValue(this.content.copy(readerIndex - 1, length), length);
                    this.content.discardReadBytes();
                    level.emitJsonPointerValue();
                }
            }
        }
        if (mode != JsonParserUtils.Mode.JSON_STRING_HASH_KEY) {
            level.removeLastTokenFromJsonPointer();
        }
        level.popMode();
    }

    private void readBOM() throws EOFException {
        int readerIndex = this.content.readerIndex();
        int lastBOMIndex = this.content.forEachByte(this.bomProcessor);
        if (lastBOMIndex == -1) {
            throw NEED_MORE_DATA;
        }
        if (lastBOMIndex > readerIndex) {
            this.content.skipBytes(lastBOMIndex - readerIndex + 1);
            this.content.discardReadBytes();
        }
        this.levelStack.pop();
    }

    private void readNextChar(JsonLevel level) throws EOFException {
        int readerIndex = this.content.readerIndex();
        int lastWsIndex = this.content.forEachByte(this.wsProcessor);
        if (lastWsIndex == -1 && level != null) {
            throw NEED_MORE_DATA;
        }
        if (lastWsIndex > readerIndex) {
            this.content.skipBytes(lastWsIndex - readerIndex);
            this.content.discardReadBytes();
        }
        this.currentChar = this.content.readByte();
    }

    static {
        NEED_MORE_DATA.setStackTrace(new StackTraceElement[0]);
    }

    class JsonLevel {
        private final Deque<JsonParserUtils.Mode> modes = new ArrayDeque<JsonParserUtils.Mode>();
        private final JsonPointer jsonPointer;
        private ByteBuf currentValue;
        private boolean isHashValue;
        private boolean isArray;
        private int arrayIndex;

        JsonLevel(JsonParserUtils.Mode mode, JsonPointer jsonPointer) {
            this.pushMode(mode);
            this.jsonPointer = jsonPointer;
        }

        void isHashValue(boolean isHashValue) {
            this.isHashValue = isHashValue;
        }

        boolean isHashValue() {
            return this.isHashValue;
        }

        void isArray(boolean isArray) {
            this.isArray = isArray;
        }

        void pushMode(JsonParserUtils.Mode mode) {
            this.modes.push(mode);
        }

        JsonParserUtils.Mode peekMode() {
            return this.modes.peek();
        }

        void popMode() {
            this.modes.pop();
        }

        JsonPointer jsonPointer() {
            return this.jsonPointer;
        }

        void updateIndex() {
            ++this.arrayIndex;
        }

        void setCurrentValue(ByteBuf value, int length) {
            this.currentValue = value;
            if (this.peekMode() == JsonParserUtils.Mode.JSON_STRING_HASH_KEY) {
                this.jsonPointer.addToken(this.currentValue.toString(this.currentValue.readerIndex() + 1, length - 1, Charset.defaultCharset()));
            }
        }

        void setArrayIndexOnJsonPointer() {
            this.jsonPointer.addToken(Integer.toString(this.arrayIndex));
        }

        void removeLastTokenFromJsonPointer() {
            this.jsonPointer.removeLastToken();
        }

        void emitJsonPointerValue() {
            if ((this.isHashValue || this.isArray) && this.jsonPointer.jsonPointerCB() != null) {
                JsonPointerCB cb = this.jsonPointer.jsonPointerCB();
                if (cb instanceof JsonPointerCB1) {
                    ((JsonPointerCB1)cb).call(this.currentValue);
                } else if (cb instanceof JsonPointerCB2) {
                    ((JsonPointerCB2)cb).call(this.jsonPointer, this.currentValue);
                }
            } else {
                this.currentValue.release();
            }
        }
    }
}

