/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.utils.yasjl;

import com.couchbase.client.core.utils.yasjl.JsonStringByteBufProcessor;
import com.couchbase.client.deps.io.netty.buffer.ByteBufProcessor;

public class JsonArrayByteBufProcessor
implements ByteBufProcessor {
    private boolean isString;
    private int count;
    private final JsonStringByteBufProcessor stProcessor;

    public JsonArrayByteBufProcessor(JsonStringByteBufProcessor stProcessor) {
        this.stProcessor = stProcessor;
        this.reset();
    }

    public void reset() {
        this.isString = false;
        this.count = 1;
        this.stProcessor.reset();
    }

    @Override
    public boolean process(byte value) throws Exception {
        if (this.isString) {
            this.isString = this.stProcessor.process(value);
            return true;
        }
        switch (value) {
            case 91: {
                ++this.count;
                return true;
            }
            case 93: {
                --this.count;
                return this.count != 0;
            }
            case 34: {
                this.isString = true;
                return true;
            }
        }
        return true;
    }
}

