/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.tracing;

import com.couchbase.client.core.logging.CouchbaseLogger;
import com.couchbase.client.core.logging.CouchbaseLoggerFactory;
import com.couchbase.client.core.message.CouchbaseRequest;
import com.couchbase.client.core.message.CouchbaseResponse;
import com.couchbase.client.core.message.analytics.AnalyticsRequest;
import com.couchbase.client.core.message.config.ConfigRequest;
import com.couchbase.client.core.message.kv.BinaryRequest;
import com.couchbase.client.core.message.kv.BinaryResponse;
import com.couchbase.client.core.message.query.QueryRequest;
import com.couchbase.client.core.message.search.SearchRequest;
import com.couchbase.client.core.message.view.ViewRequest;
import com.couchbase.client.core.tracing.OrphanResponseReporter;
import com.couchbase.client.core.utils.DefaultObjectMapper;
import com.couchbase.client.deps.io.netty.util.internal.shaded.org.jctools.queues.MpscUnboundedArrayQueue;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

public class DefaultOrphanResponseReporter
implements OrphanResponseReporter {
    private static final CouchbaseLogger LOGGER = CouchbaseLoggerFactory.getInstance(DefaultOrphanResponseReporter.class);
    private static final AtomicInteger REPORTER_ID = new AtomicInteger();
    private static final long MIN_LOG_INTERVAL = TimeUnit.SECONDS.toNanos(1L);
    private final Queue<CouchbaseResponse> queue;
    private final long logIntervalNanos;
    private final int sampleSize;
    private final boolean pretty;
    private final Thread worker;
    private volatile boolean running;

    public static Builder builder() {
        return new Builder();
    }

    public static DefaultOrphanResponseReporter disabled() {
        return DefaultOrphanResponseReporter.builder().logInterval(0L, TimeUnit.SECONDS).build();
    }

    public static DefaultOrphanResponseReporter create() {
        return DefaultOrphanResponseReporter.builder().build();
    }

    public DefaultOrphanResponseReporter(Builder builder) {
        this.logIntervalNanos = builder.logIntervalUnit.toNanos(builder.logInterval);
        this.sampleSize = builder.sampleSize;
        if (this.logIntervalNanos > 0L && this.logIntervalNanos < this.minLogInterval()) {
            throw new IllegalArgumentException("The log interval needs to be either 0 or greater than " + MIN_LOG_INTERVAL + " micros");
        }
        this.queue = new MpscUnboundedArrayQueue<CouchbaseResponse>(builder.spanQueueSize);
        this.pretty = builder.pretty;
        this.running = true;
        if (this.logIntervalNanos > 0L) {
            this.worker = new Thread(new Worker());
            this.worker.setDaemon(true);
            this.worker.start();
        } else {
            this.worker = null;
            LOGGER.debug("OrphanResponseLogReporter disabled via config.");
        }
    }

    long minLogInterval() {
        return MIN_LOG_INTERVAL;
    }

    @Override
    public void report(CouchbaseResponse request) {
        if (!this.queue.offer(request)) {
            LOGGER.debug("Could not enqueue CouchbaseRequest {} for orphan reporting, discarding.", (Object)request);
        }
    }

    @Override
    public void shutdown() {
        this.running = false;
        if (this.worker != null) {
            this.worker.interrupt();
        }
    }

    void logOrphans(List<Map<String, Object>> toLog) {
        try {
            String result = this.pretty ? DefaultObjectMapper.prettyWriter().writeValueAsString(toLog) : DefaultObjectMapper.writer().writeValueAsString(toLog);
            LOGGER.warn("Orphan responses observed: {}", (Object)result);
        }
        catch (Exception ex) {
            LOGGER.warn("Could not write orphan log.", ex);
        }
    }

    public static class Builder {
        private static final long DEFAULT_LOG_INTERVAL = 10L;
        private static final TimeUnit DEFAULT_LOG_INTERVAL_UNIT = TimeUnit.SECONDS;
        private static final int DEFAULT_SPAN_QUEUE_SIZE = 1024;
        private static final int DEFAULT_SAMPLE_SIZE = 10;
        private static final boolean DEFAULT_PRETTY = false;
        private long logInterval = 10L;
        private TimeUnit logIntervalUnit = DEFAULT_LOG_INTERVAL_UNIT;
        private int spanQueueSize = 1024;
        private int sampleSize = 10;
        private boolean pretty = false;

        public DefaultOrphanResponseReporter build() {
            return new DefaultOrphanResponseReporter(this);
        }

        public Builder logInterval(long interval, TimeUnit unit) {
            this.logInterval = interval;
            this.logIntervalUnit = unit;
            return this;
        }

        public Builder sampleSize(int sampleSize) {
            this.sampleSize = sampleSize;
            return this;
        }

        public Builder pretty(boolean pretty) {
            this.pretty = pretty;
            return this;
        }
    }

    class Worker
    implements Runnable {
        private final long workerSleepMs = Long.parseLong(System.getProperty("com.couchbase.orphanResponseReporterSleep", "100"));
        private final Set<CouchbaseResponse> kvSet = new LinkedHashSet<CouchbaseResponse>();
        private final Set<CouchbaseResponse> n1qlSet = new LinkedHashSet<CouchbaseResponse>();
        private final Set<CouchbaseResponse> viewSet = new LinkedHashSet<CouchbaseResponse>();
        private final Set<CouchbaseResponse> ftsSet = new LinkedHashSet<CouchbaseResponse>();
        private final Set<CouchbaseResponse> analyticsSet = new LinkedHashSet<CouchbaseResponse>();
        private int kvCount = 0;
        private int n1qlCount = 0;
        private int viewCount = 0;
        private int ftsCount = 0;
        private int analyticsCount = 0;
        private long lastLog;
        private boolean hasWritten;

        Worker() {
        }

        @Override
        public void run() {
            Thread.currentThread().setName("cb-orphan-" + REPORTER_ID.incrementAndGet());
            while (DefaultOrphanResponseReporter.this.running) {
                try {
                    this.handleOrphanQueue();
                    Thread.sleep(this.workerSleepMs);
                }
                catch (InterruptedException ex) {
                    if (!DefaultOrphanResponseReporter.this.running) {
                        return;
                    }
                    Thread.currentThread().interrupt();
                }
                catch (Exception ex) {
                    LOGGER.warn("Got exception on orphan response reporter, ignoring.", ex);
                }
            }
        }

        private void handleOrphanQueue() {
            long now = System.nanoTime();
            if (now > this.lastLog + DefaultOrphanResponseReporter.this.logIntervalNanos) {
                this.prepareAndLogOrphans();
                this.lastLog = now;
            }
            CouchbaseResponse response;
            while ((response = (CouchbaseResponse)DefaultOrphanResponseReporter.this.queue.poll()) != null) {
                CouchbaseRequest request = response.request();
                if (request instanceof BinaryRequest) {
                    this.updateSet(this.kvSet, response);
                    ++this.kvCount;
                    continue;
                }
                if (request instanceof QueryRequest) {
                    this.updateSet(this.n1qlSet, response);
                    ++this.n1qlCount;
                    continue;
                }
                if (request instanceof ViewRequest) {
                    this.updateSet(this.viewSet, response);
                    ++this.viewCount;
                    continue;
                }
                if (request instanceof AnalyticsRequest) {
                    this.updateSet(this.analyticsSet, response);
                    ++this.analyticsCount;
                    continue;
                }
                if (request instanceof SearchRequest) {
                    this.updateSet(this.ftsSet, response);
                    ++this.ftsCount;
                    continue;
                }
                LOGGER.warn("Unknown service in orphan {}", (Object)request);
            }
            return;
        }

        private void updateSet(Set<CouchbaseResponse> set, CouchbaseResponse response) {
            if (set.size() < DefaultOrphanResponseReporter.this.sampleSize) {
                set.add(response);
                this.hasWritten = true;
            }
        }

        private void prepareAndLogOrphans() {
            if (!this.hasWritten) {
                return;
            }
            this.hasWritten = false;
            ArrayList<Map<String, Object>> output = new ArrayList<Map<String, Object>>();
            if (!this.kvSet.isEmpty()) {
                output.add(this.convertThresholdSet(this.kvSet, this.kvCount, "kv"));
                this.kvSet.clear();
                this.kvCount = 0;
            }
            if (!this.n1qlSet.isEmpty()) {
                output.add(this.convertThresholdSet(this.n1qlSet, this.n1qlCount, "n1ql"));
                this.n1qlSet.clear();
                this.n1qlCount = 0;
            }
            if (!this.viewSet.isEmpty()) {
                output.add(this.convertThresholdSet(this.viewSet, this.viewCount, "view"));
                this.viewSet.clear();
                this.viewCount = 0;
            }
            if (!this.ftsSet.isEmpty()) {
                output.add(this.convertThresholdSet(this.ftsSet, this.ftsCount, "search"));
                this.ftsSet.clear();
                this.ftsCount = 0;
            }
            if (!this.analyticsSet.isEmpty()) {
                output.add(this.convertThresholdSet(this.analyticsSet, this.analyticsCount, "analytics"));
                this.analyticsSet.clear();
                this.analyticsCount = 0;
            }
            DefaultOrphanResponseReporter.this.logOrphans(output);
        }

        private Map<String, Object> convertThresholdSet(Set<CouchbaseResponse> set, int count, String serviceType) {
            HashMap<String, Object> output = new HashMap<String, Object>();
            ArrayList<HashMap<String, Object>> top = new ArrayList<HashMap<String, Object>>();
            for (CouchbaseResponse response : set) {
                HashMap<String, Object> fieldMap = new HashMap<String, Object>();
                CouchbaseRequest request = response.request();
                if (request != null) {
                    fieldMap.put("s", this.formatServiceType(request));
                    this.putIfNotNull(fieldMap, "i", request.operationId());
                    this.putIfNotNull(fieldMap, "b", request.bucket());
                    this.putIfNotNull(fieldMap, "c", request.lastLocalId());
                    this.putIfNotNull(fieldMap, "l", request.lastLocalSocket());
                    this.putIfNotNull(fieldMap, "r", request.lastRemoteSocket());
                }
                if (response instanceof BinaryResponse) {
                    this.putIfNotNull(fieldMap, "d", ((BinaryResponse)response).serverDuration());
                }
                top.add(fieldMap);
            }
            output.put("service", serviceType);
            output.put("count", count);
            output.put("top", top);
            return output;
        }

        private void putIfNotNull(Map<String, Object> map, String key, Object value) {
            if (value != null) {
                map.put(key, value);
            }
        }

        private String formatServiceType(CouchbaseRequest request) {
            if (request instanceof BinaryRequest) {
                return "kv";
            }
            if (request instanceof QueryRequest) {
                return "n1ql";
            }
            if (request instanceof ViewRequest) {
                return "view";
            }
            if (request instanceof AnalyticsRequest) {
                return "analytics";
            }
            if (request instanceof SearchRequest) {
                return "search";
            }
            if (request instanceof ConfigRequest) {
                return "config";
            }
            return "unknown";
        }
    }
}

