/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.message.cluster;

import com.couchbase.client.core.config.ConfigurationException;
import com.couchbase.client.core.logging.CouchbaseLogger;
import com.couchbase.client.core.logging.CouchbaseLoggerFactory;
import com.couchbase.client.core.logging.RedactableArgument;
import com.couchbase.client.core.message.AbstractCouchbaseRequest;
import com.couchbase.client.core.message.cluster.ClusterRequest;
import com.couchbase.client.core.utils.NetworkAddress;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class SeedNodesRequest
extends AbstractCouchbaseRequest
implements ClusterRequest {
    private static final CouchbaseLogger LOGGER = CouchbaseLoggerFactory.getInstance(SeedNodesRequest.class);
    private static final String DEFAULT_HOSTNAME = "localhost";
    private Set<NetworkAddress> nodes;

    public SeedNodesRequest() {
        this(DEFAULT_HOSTNAME);
    }

    public SeedNodesRequest(String ... nodes) {
        this(Arrays.asList(nodes));
    }

    public SeedNodesRequest(List<String> nodes) {
        super(null, null);
        if (nodes == null || nodes.isEmpty()) {
            throw new ConfigurationException("Empty or null bootstrap list provided.");
        }
        HashSet<NetworkAddress> parsedNodes = new HashSet<NetworkAddress>();
        for (String node : nodes) {
            if (node == null || node.isEmpty()) {
                LOGGER.info("Empty or null host in bootstrap list.");
                continue;
            }
            try {
                parsedNodes.add(NetworkAddress.create(node));
            }
            catch (Exception e) {
                LOGGER.info("Unknown host {} in bootstrap list.", (Object)RedactableArgument.system(node), (Object)e);
            }
        }
        if (parsedNodes.isEmpty()) {
            throw new ConfigurationException("No valid node found to bootstrap from. Please check your network configuration.");
        }
        this.nodes = parsedNodes;
    }

    public Set<NetworkAddress> nodes() {
        return this.nodes;
    }
}

