/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.message;

import com.couchbase.client.core.message.CouchbaseRequest;
import com.couchbase.client.core.message.CouchbaseResponse;
import com.couchbase.client.core.time.Delay;
import rx.Subscriber;
import rx.subjects.AsyncSubject;
import rx.subjects.Subject;

public abstract class AbstractCouchbaseRequest
implements CouchbaseRequest {
    private final Subject<CouchbaseResponse, CouchbaseResponse> observable;
    private final String bucket;
    private final String username;
    private final String password;
    private final long creationTime;
    private volatile Subscriber subscriber;
    private volatile int retryCount;
    private volatile long retryAfter;
    private volatile long maxRetryDuration;
    private volatile String dispatchHostname;
    private Delay retryDelay;

    protected AbstractCouchbaseRequest(String bucket, String password) {
        this(bucket, bucket, password, (Subject<CouchbaseResponse, CouchbaseResponse>)AsyncSubject.create());
    }

    protected AbstractCouchbaseRequest(String bucket, String username, String password) {
        this(bucket, username, password, (Subject<CouchbaseResponse, CouchbaseResponse>)AsyncSubject.create());
    }

    protected AbstractCouchbaseRequest(String bucket, String username, String password, Subject<CouchbaseResponse, CouchbaseResponse> observable) {
        this.bucket = bucket;
        this.username = username;
        this.password = password;
        this.observable = observable;
        this.creationTime = System.nanoTime();
        this.retryCount = 0;
    }

    @Override
    public Subject<CouchbaseResponse, CouchbaseResponse> observable() {
        return this.observable;
    }

    @Override
    public String bucket() {
        return this.bucket;
    }

    @Override
    public String username() {
        return this.username;
    }

    @Override
    public String password() {
        return this.password;
    }

    @Override
    public long creationTime() {
        return this.creationTime;
    }

    @Override
    public int incrementRetryCount() {
        return this.retryCount++;
    }

    @Override
    public int retryCount() {
        return this.retryCount;
    }

    @Override
    public void retryAfter(long after) {
        this.retryAfter = after;
    }

    @Override
    public long retryAfter() {
        return this.retryAfter;
    }

    @Override
    public void maxRetryDuration(long maxRetryDuration) {
        this.maxRetryDuration = maxRetryDuration;
    }

    @Override
    public long maxRetryDuration() {
        return this.maxRetryDuration;
    }

    @Override
    public void retryDelay(Delay retryDelay) {
        this.retryDelay = retryDelay;
    }

    @Override
    public Delay retryDelay() {
        return this.retryDelay;
    }

    @Override
    public boolean isActive() {
        return this.subscriber == null || !this.subscriber.isUnsubscribed();
    }

    @Override
    public void subscriber(Subscriber subscriber) {
        this.subscriber = subscriber;
    }

    @Override
    public String dispatchHostname() {
        return this.dispatchHostname;
    }

    @Override
    public void dispatchHostname(String hostname) {
        this.dispatchHostname = hostname;
    }

    @Override
    public void emit(CouchbaseResponse response) {
        this.observable.onNext((Object)response);
    }

    @Override
    public void complete() {
        this.observable.onCompleted();
    }

    @Override
    public void succeed(CouchbaseResponse response) {
        this.emit(response);
        this.complete();
    }

    @Override
    public void fail(Throwable throwable) {
        this.observable.onError(throwable);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.getClass().getSimpleName() + "{");
        sb.append("observable=").append(this.observable);
        sb.append(", bucket='").append(this.bucket).append('\'');
        sb.append('}');
        return sb.toString();
    }
}

