/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.config;

import com.couchbase.client.core.config.AbstractBucketConfig;
import com.couchbase.client.core.config.BucketCapabilities;
import com.couchbase.client.core.config.BucketNodeLocator;
import com.couchbase.client.core.config.BucketType;
import com.couchbase.client.core.config.ConfigurationException;
import com.couchbase.client.core.config.CouchbaseBucketConfig;
import com.couchbase.client.core.config.CouchbasePartitionInfo;
import com.couchbase.client.core.config.NodeInfo;
import com.couchbase.client.core.config.Partition;
import com.couchbase.client.core.config.PortInfo;
import com.couchbase.client.core.logging.CouchbaseLogger;
import com.couchbase.client.core.logging.CouchbaseLoggerFactory;
import com.couchbase.client.core.logging.RedactableArgument;
import com.couchbase.client.core.service.ServiceType;
import com.couchbase.client.core.utils.NetworkAddress;
import com.couchbase.client.deps.com.fasterxml.jackson.annotation.JsonCreator;
import com.couchbase.client.deps.com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.couchbase.client.deps.com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

@JsonIgnoreProperties(ignoreUnknown=true)
public class DefaultCouchbaseBucketConfig
extends AbstractBucketConfig
implements CouchbaseBucketConfig {
    private static final CouchbaseLogger LOGGER = CouchbaseLoggerFactory.getInstance(CouchbaseBucketConfig.class);
    public static final int PARTITION_NOT_EXISTENT = -2;
    private final CouchbasePartitionInfo partitionInfo;
    private final List<NodeInfo> partitionHosts;
    private final Set<NetworkAddress> nodesWithPrimaryPartitions;
    private final boolean tainted;
    private final long rev;
    private final boolean ephemeral;

    @JsonCreator
    public DefaultCouchbaseBucketConfig(@JsonProperty(value="rev") long rev, @JsonProperty(value="name") String name, @JsonProperty(value="uri") String uri, @JsonProperty(value="streamingUri") String streamingUri, @JsonProperty(value="vBucketServerMap") CouchbasePartitionInfo partitionInfo, @JsonProperty(value="nodes") List<NodeInfo> nodeInfos, @JsonProperty(value="nodesExt") List<PortInfo> portInfos, @JsonProperty(value="bucketCapabilities") List<BucketCapabilities> bucketCapabilities) {
        super(name, BucketNodeLocator.VBUCKET, uri, streamingUri, nodeInfos, portInfos, bucketCapabilities);
        this.partitionInfo = partitionInfo;
        this.tainted = partitionInfo.tainted();
        List<NodeInfo> extendedNodeInfos = this.nodes();
        this.partitionHosts = DefaultCouchbaseBucketConfig.buildPartitionHosts(extendedNodeInfos, partitionInfo);
        this.nodesWithPrimaryPartitions = DefaultCouchbaseBucketConfig.buildNodesWithPrimaryPartitions(nodeInfos, partitionInfo.partitions());
        this.rev = rev;
        this.ephemeral = bucketCapabilities != null && !bucketCapabilities.contains((Object)BucketCapabilities.COUCHAPI);
    }

    private static Set<NetworkAddress> buildNodesWithPrimaryPartitions(List<NodeInfo> nodeInfos, List<Partition> partitions) {
        HashSet<NetworkAddress> nodes = new HashSet<NetworkAddress>(nodeInfos.size());
        for (Partition partition : partitions) {
            short index = partition.master();
            if (index < 0) continue;
            nodes.add(nodeInfos.get(index).hostname());
        }
        return nodes;
    }

    private static List<NodeInfo> buildPartitionHosts(List<NodeInfo> nodeInfos, CouchbasePartitionInfo partitionInfo) {
        ArrayList<NodeInfo> partitionHosts = new ArrayList<NodeInfo>();
        for (String rawHost : partitionInfo.partitionHosts()) {
            int directPort;
            NetworkAddress convertedHost;
            try {
                String[] parts = rawHost.split(":");
                String host = "";
                String port = parts[parts.length - 1];
                if (parts.length > 2) {
                    for (int i = 0; i < parts.length - 1; ++i) {
                        host = host + parts[i];
                        if (!parts[i].endsWith("]")) {
                            host = host + ":";
                            continue;
                        }
                        break;
                    }
                } else {
                    host = parts[0];
                }
                convertedHost = NetworkAddress.create(host);
                try {
                    directPort = Integer.parseInt(port);
                }
                catch (NumberFormatException e) {
                    LOGGER.warn("Could not parse port from the node address: {}, fallback to 0", (Object)RedactableArgument.system(rawHost));
                    directPort = 0;
                }
            }
            catch (Exception e) {
                throw new ConfigurationException("Could not resolve " + rawHost + "on config building.", e);
            }
            for (NodeInfo nodeInfo : nodeInfos) {
                if (!nodeInfo.services().containsKey((Object)ServiceType.BINARY) || !nodeInfo.hostname().equals(convertedHost) || nodeInfo.services().get((Object)ServiceType.BINARY) != directPort && directPort != 0) continue;
                partitionHosts.add(nodeInfo);
            }
        }
        if (partitionHosts.size() != partitionInfo.partitionHosts().length) {
            throw new ConfigurationException("Partition size is not equal after conversion, this is a bug.");
        }
        return partitionHosts;
    }

    @Override
    public int numberOfReplicas() {
        return this.partitionInfo.numberOfReplicas();
    }

    @Override
    public boolean tainted() {
        return this.tainted;
    }

    @Override
    public boolean hasPrimaryPartitionsOnNode(NetworkAddress hostname) {
        return this.nodesWithPrimaryPartitions.contains(hostname);
    }

    @Override
    public short nodeIndexForMaster(int partition, boolean useFastForward) {
        if (useFastForward && !this.hasFastForwardMap()) {
            throw new IllegalStateException("Could not get index from FF-Map, none found in this config.");
        }
        List<Partition> partitions = useFastForward ? this.partitionInfo.forwardPartitions() : this.partitionInfo.partitions();
        try {
            return partitions.get(partition).master();
        }
        catch (IndexOutOfBoundsException ex) {
            LOGGER.debug("Out of bounds on index for master " + partition + ".", ex);
            return -2;
        }
    }

    @Override
    public short nodeIndexForReplica(int partition, int replica, boolean useFastForward) {
        if (useFastForward && !this.hasFastForwardMap()) {
            throw new IllegalStateException("Could not get index from FF-Map, none found in this config.");
        }
        List<Partition> partitions = useFastForward ? this.partitionInfo.forwardPartitions() : this.partitionInfo.partitions();
        try {
            return partitions.get(partition).replica(replica);
        }
        catch (IndexOutOfBoundsException ex) {
            LOGGER.debug("Out of bounds on index for replica " + partition + ".", ex);
            return -2;
        }
    }

    @Override
    public int numberOfPartitions() {
        return this.partitionInfo.partitions().size();
    }

    @Override
    public NodeInfo nodeAtIndex(int nodeIndex) {
        return this.partitionHosts.get(nodeIndex);
    }

    @Override
    public long rev() {
        return this.rev;
    }

    @Override
    public BucketType type() {
        return BucketType.COUCHBASE;
    }

    @Override
    public boolean hasFastForwardMap() {
        return this.partitionInfo.hasFastForwardMap();
    }

    @Override
    public boolean ephemeral() {
        return this.ephemeral;
    }

    public String toString() {
        return "DefaultCouchbaseBucketConfig{name='" + this.name() + '\'' + ", locator=" + (Object)((Object)this.locator()) + ", uri='" + this.uri() + '\'' + ", streamingUri='" + this.streamingUri() + '\'' + ", nodeInfo=" + this.nodes() + ", partitionInfo=" + this.partitionInfo + ", tainted=" + this.tainted + ", rev=" + this.rev + '}';
    }
}

