/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.deps.io.netty.handler.codec.memcache.binary;

import com.couchbase.client.core.lang.backport.java.util.Objects;
import com.couchbase.client.deps.io.netty.buffer.ByteBuf;
import com.couchbase.client.deps.io.netty.buffer.Unpooled;
import com.couchbase.client.deps.io.netty.handler.codec.memcache.binary.DefaultBinaryMemcacheResponse;
import com.couchbase.client.deps.io.netty.handler.codec.memcache.binary.FullBinaryMemcacheResponse;

public class DefaultFullBinaryMemcacheResponse
extends DefaultBinaryMemcacheResponse
implements FullBinaryMemcacheResponse {
    private final ByteBuf content;

    public DefaultFullBinaryMemcacheResponse(byte[] key, ByteBuf extras) {
        this(key, extras, Unpooled.buffer(0));
    }

    public DefaultFullBinaryMemcacheResponse(byte[] key, ByteBuf extras, ByteBuf content) {
        super(key, extras);
        this.content = Objects.requireNonNull(content, "Supplied content is null.");
    }

    @Override
    public ByteBuf content() {
        return this.content;
    }

    @Override
    public int refCnt() {
        return this.content.refCnt();
    }

    @Override
    public FullBinaryMemcacheResponse retain() {
        super.retain();
        this.content.retain();
        return this;
    }

    @Override
    public FullBinaryMemcacheResponse retain(int increment) {
        super.retain(increment);
        this.content.retain(increment);
        return this;
    }

    @Override
    public boolean release() {
        super.release();
        return this.content.release();
    }

    @Override
    public boolean release(int decrement) {
        super.release(decrement);
        return this.content.release(decrement);
    }

    @Override
    public FullBinaryMemcacheResponse copy() {
        ByteBuf extras = this.getExtras();
        if (extras != null) {
            extras = extras.copy();
        }
        return new DefaultFullBinaryMemcacheResponse(this.getKey(), extras, this.content().copy());
    }

    @Override
    public FullBinaryMemcacheResponse duplicate() {
        ByteBuf extras = this.getExtras();
        if (extras != null) {
            extras = extras.duplicate();
        }
        return new DefaultFullBinaryMemcacheResponse(this.getKey(), extras, this.content().duplicate());
    }
}

