/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.logging;

import com.couchbase.client.core.lang.backport.java.util.Objects;
import com.couchbase.client.core.logging.AbstractCouchbaseLogger;
import com.couchbase.client.core.logging.FormattingTuple;
import com.couchbase.client.core.logging.MessageFormatter;
import com.couchbase.client.core.logging.RedactionLevel;
import org.apache.commons.logging.Log;

class CommonsLogger
extends AbstractCouchbaseLogger {
    private static final long serialVersionUID = 8647838678388394885L;
    private final transient Log logger;

    CommonsLogger(Log logger, String name, RedactionLevel redactionLevel) {
        super(name, redactionLevel);
        this.logger = Objects.requireNonNull(logger, "logger");
    }

    @Override
    public boolean isTraceEnabled() {
        return this.logger.isTraceEnabled();
    }

    @Override
    public void trace(String msg) {
        this.logger.trace((Object)msg);
    }

    @Override
    public void trace(String format, Object arg) {
        if (this.logger.isTraceEnabled()) {
            FormattingTuple ft = MessageFormatter.format(format, arg);
            this.logger.trace((Object)ft.getMessage(), ft.getThrowable());
        }
    }

    @Override
    public void trace(String format, Object argA, Object argB) {
        if (this.logger.isTraceEnabled()) {
            FormattingTuple ft = MessageFormatter.format(format, argA, argB);
            this.logger.trace((Object)ft.getMessage(), ft.getThrowable());
        }
    }

    @Override
    public void trace(String format, Object ... arguments) {
        if (this.logger.isTraceEnabled()) {
            FormattingTuple ft = MessageFormatter.arrayFormat(format, arguments);
            this.logger.trace((Object)ft.getMessage(), ft.getThrowable());
        }
    }

    @Override
    public void trace(String msg, Throwable t) {
        this.logger.trace((Object)msg, t);
    }

    @Override
    public boolean isDebugEnabled() {
        return this.logger.isDebugEnabled();
    }

    @Override
    public void debug(String msg) {
        this.logger.debug((Object)msg);
    }

    @Override
    public void debug(String format, Object arg) {
        if (this.logger.isDebugEnabled()) {
            FormattingTuple ft = MessageFormatter.format(format, arg);
            this.logger.debug((Object)ft.getMessage(), ft.getThrowable());
        }
    }

    @Override
    public void debug(String format, Object argA, Object argB) {
        if (this.logger.isDebugEnabled()) {
            FormattingTuple ft = MessageFormatter.format(format, argA, argB);
            this.logger.debug((Object)ft.getMessage(), ft.getThrowable());
        }
    }

    @Override
    public void debug(String format, Object ... arguments) {
        if (this.logger.isDebugEnabled()) {
            FormattingTuple ft = MessageFormatter.arrayFormat(format, arguments);
            this.logger.debug((Object)ft.getMessage(), ft.getThrowable());
        }
    }

    @Override
    public void debug(String msg, Throwable t) {
        this.logger.debug((Object)msg, t);
    }

    @Override
    public boolean isInfoEnabled() {
        return this.logger.isInfoEnabled();
    }

    @Override
    public void info(String msg) {
        this.logger.info((Object)msg);
    }

    @Override
    public void info(String format, Object arg) {
        if (this.logger.isInfoEnabled() && !this.infoRedacted(format, arg)) {
            FormattingTuple ft = MessageFormatter.format(format, arg);
            this.logger.info((Object)ft.getMessage(), ft.getThrowable());
        }
    }

    @Override
    public void info(String format, Object argA, Object argB) {
        this.info(format, new Object[]{argA, argB});
    }

    @Override
    public void info(String format, Object ... arguments) {
        if (this.logger.isInfoEnabled() && !this.infoRedacted(format, arguments)) {
            FormattingTuple ft = MessageFormatter.arrayFormat(format, arguments);
            this.logger.info((Object)ft.getMessage(), ft.getThrowable());
        }
    }

    @Override
    public void info(String msg, Throwable t) {
        this.logger.info((Object)msg, t);
    }

    @Override
    public boolean isWarnEnabled() {
        return this.logger.isWarnEnabled();
    }

    @Override
    public void warn(String msg) {
        this.logger.warn((Object)msg);
    }

    @Override
    public void warn(String format, Object arg) {
        if (this.logger.isWarnEnabled() && !this.warnRedacted(format, arg)) {
            FormattingTuple ft = MessageFormatter.format(format, arg);
            this.logger.warn((Object)ft.getMessage(), ft.getThrowable());
        }
    }

    @Override
    public void warn(String format, Object argA, Object argB) {
        this.warn(format, new Object[]{argA, argB});
    }

    @Override
    public void warn(String format, Object ... arguments) {
        if (this.logger.isWarnEnabled() && !this.warnRedacted(format, arguments)) {
            FormattingTuple ft = MessageFormatter.arrayFormat(format, arguments);
            this.logger.warn((Object)ft.getMessage(), ft.getThrowable());
        }
    }

    @Override
    public void warn(String msg, Throwable t) {
        this.logger.warn((Object)msg, t);
    }

    @Override
    public boolean isErrorEnabled() {
        return this.logger.isErrorEnabled();
    }

    @Override
    public void error(String msg) {
        this.logger.error((Object)msg);
    }

    @Override
    public void error(String format, Object arg) {
        if (this.logger.isErrorEnabled() && !this.errorRedacted(format, arg)) {
            FormattingTuple ft = MessageFormatter.format(format, arg);
            this.logger.error((Object)ft.getMessage(), ft.getThrowable());
        }
    }

    @Override
    public void error(String format, Object argA, Object argB) {
        this.error(format, new Object[]{argA, argB});
    }

    @Override
    public void error(String format, Object ... arguments) {
        if (this.logger.isErrorEnabled() && !this.errorRedacted(format, arguments)) {
            FormattingTuple ft = MessageFormatter.arrayFormat(format, arguments);
            this.logger.error((Object)ft.getMessage(), ft.getThrowable());
        }
    }

    @Override
    public void error(String msg, Throwable t) {
        this.logger.error((Object)msg, t);
    }
}

