/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.logging;

import com.couchbase.client.core.logging.CouchbaseLogLevel;
import com.couchbase.client.core.logging.CouchbaseLogger;
import com.couchbase.client.core.logging.CouchbaseLoggerFactory;
import com.couchbase.client.core.logging.RedactableArgument;
import com.couchbase.client.core.logging.RedactionLevel;
import com.couchbase.client.deps.io.netty.util.internal.StringUtil;
import java.io.ObjectStreamException;
import java.io.Serializable;

public abstract class AbstractCouchbaseLogger
implements CouchbaseLogger,
Serializable {
    private static final long serialVersionUID = -6382972526573193470L;
    private static final String EXCEPTION_MESSAGE = "Unexpected exception:";
    private final String name;
    private final RedactionLevel redactionLevel;

    protected AbstractCouchbaseLogger(String name, RedactionLevel redactionLevel) {
        if (name == null) {
            throw new NullPointerException("name");
        }
        if (redactionLevel == null) {
            throw new NullPointerException("redactionLevel");
        }
        this.name = name;
        this.redactionLevel = redactionLevel;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public boolean isEnabled(CouchbaseLogLevel level) {
        switch (level) {
            case TRACE: {
                return this.isTraceEnabled();
            }
            case DEBUG: {
                return this.isDebugEnabled();
            }
            case INFO: {
                return this.isInfoEnabled();
            }
            case WARN: {
                return this.isWarnEnabled();
            }
            case ERROR: {
                return this.isErrorEnabled();
            }
        }
        throw new Error();
    }

    @Override
    public void trace(Throwable t) {
        this.trace(EXCEPTION_MESSAGE, t);
    }

    @Override
    public void debug(Throwable t) {
        this.debug(EXCEPTION_MESSAGE, t);
    }

    @Override
    public void info(Throwable t) {
        this.info(EXCEPTION_MESSAGE, t);
    }

    @Override
    public void warn(Throwable t) {
        this.warn(EXCEPTION_MESSAGE, t);
    }

    @Override
    public void error(Throwable t) {
        this.error(EXCEPTION_MESSAGE, t);
    }

    @Override
    public void log(CouchbaseLogLevel level, String msg, Throwable cause) {
        switch (level) {
            case TRACE: {
                this.trace(msg, cause);
                break;
            }
            case DEBUG: {
                this.debug(msg, cause);
                break;
            }
            case INFO: {
                this.info(msg, cause);
                break;
            }
            case WARN: {
                this.warn(msg, cause);
                break;
            }
            case ERROR: {
                this.error(msg, cause);
                break;
            }
            default: {
                throw new Error();
            }
        }
    }

    @Override
    public void log(CouchbaseLogLevel level, Throwable cause) {
        switch (level) {
            case TRACE: {
                this.trace(cause);
                break;
            }
            case DEBUG: {
                this.debug(cause);
                break;
            }
            case INFO: {
                this.info(cause);
                break;
            }
            case WARN: {
                this.warn(cause);
                break;
            }
            case ERROR: {
                this.error(cause);
                break;
            }
            default: {
                throw new Error();
            }
        }
    }

    @Override
    public void log(CouchbaseLogLevel level, String msg) {
        switch (level) {
            case TRACE: {
                this.trace(msg);
                break;
            }
            case DEBUG: {
                this.debug(msg);
                break;
            }
            case INFO: {
                this.info(msg);
                break;
            }
            case WARN: {
                this.warn(msg);
                break;
            }
            case ERROR: {
                this.error(msg);
                break;
            }
            default: {
                throw new Error();
            }
        }
    }

    @Override
    public void log(CouchbaseLogLevel level, String format, Object arg) {
        switch (level) {
            case TRACE: {
                this.trace(format, arg);
                break;
            }
            case DEBUG: {
                this.debug(format, arg);
                break;
            }
            case INFO: {
                this.info(format, arg);
                break;
            }
            case WARN: {
                this.warn(format, arg);
                break;
            }
            case ERROR: {
                this.error(format, arg);
                break;
            }
            default: {
                throw new Error();
            }
        }
    }

    @Override
    public void log(CouchbaseLogLevel level, String format, Object argA, Object argB) {
        switch (level) {
            case TRACE: {
                this.trace(format, argA, argB);
                break;
            }
            case DEBUG: {
                this.debug(format, argA, argB);
                break;
            }
            case INFO: {
                this.info(format, argA, argB);
                break;
            }
            case WARN: {
                this.warn(format, argA, argB);
                break;
            }
            case ERROR: {
                this.error(format, argA, argB);
                break;
            }
            default: {
                throw new Error();
            }
        }
    }

    @Override
    public void log(CouchbaseLogLevel level, String format, Object ... arguments) {
        switch (level) {
            case TRACE: {
                this.trace(format, arguments);
                break;
            }
            case DEBUG: {
                this.debug(format, arguments);
                break;
            }
            case INFO: {
                this.info(format, arguments);
                break;
            }
            case WARN: {
                this.warn(format, arguments);
                break;
            }
            case ERROR: {
                this.error(format, arguments);
                break;
            }
            default: {
                throw new Error();
            }
        }
    }

    protected Object readResolve() throws ObjectStreamException {
        return CouchbaseLoggerFactory.getInstance(this.name());
    }

    protected boolean infoRedacted(String format, Object ... arguments) {
        if (this.redactionLevel == RedactionLevel.NONE) {
            return false;
        }
        Object[] redacted = new Object[arguments.length];
        if (this.redactArgs(arguments, redacted)) {
            this.info(format, redacted);
            this.debug(format, arguments);
            return true;
        }
        return false;
    }

    protected boolean warnRedacted(String format, Object ... arguments) {
        if (this.redactionLevel == RedactionLevel.NONE) {
            return false;
        }
        Object[] redacted = new Object[arguments.length];
        if (this.redactArgs(arguments, redacted)) {
            this.warn(format, redacted);
            this.debug(format, arguments);
            return true;
        }
        return false;
    }

    protected boolean errorRedacted(String format, Object ... arguments) {
        if (this.redactionLevel == RedactionLevel.NONE) {
            return false;
        }
        Object[] redacted = new Object[arguments.length];
        if (this.redactArgs(arguments, redacted)) {
            this.error(format, redacted);
            this.debug(format, arguments);
            return true;
        }
        return false;
    }

    private boolean redactArgs(Object[] arguments, Object[] redacted) {
        boolean atLeastOneRedacted = false;
        for (int i = 0; i < arguments.length; ++i) {
            Object arg = arguments[i];
            if (!(arg instanceof RedactableArgument)) continue;
            arguments[i] = arg.toString();
            if (this.redactionLevel == RedactionLevel.FULL || this.redactionLevel == RedactionLevel.PARTIAL && ((RedactableArgument)arg).type() == RedactableArgument.ArgumentType.USER) {
                redacted[i] = "-REDACTED-";
                atLeastOneRedacted = true;
                continue;
            }
            redacted[i] = arg.toString();
        }
        return atLeastOneRedacted;
    }

    public String toString() {
        return StringUtil.simpleClassName(this) + '(' + this.name() + ')';
    }
}

