/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.message.kv.subdoc.simple;

import com.couchbase.client.core.annotations.InterfaceAudience;
import com.couchbase.client.core.annotations.InterfaceStability;
import com.couchbase.client.core.message.kv.subdoc.simple.AbstractSubdocRequest;
import com.couchbase.client.deps.io.netty.buffer.ByteBuf;

@InterfaceStability.Uncommitted
@InterfaceAudience.Public
public class SubGetCountRequest
extends AbstractSubdocRequest {
    private boolean xattr;
    private boolean accessDeleted;

    public SubGetCountRequest(String key, String path, String bucket) {
        super(key, path, bucket, new ByteBuf[0]);
        if (path.isEmpty()) {
            this.cleanUpAndThrow(EXCEPTION_EMPTY_PATH);
        }
        this.xattr = false;
    }

    @Override
    public byte opcode() {
        return -46;
    }

    public boolean xattr() {
        return this.xattr;
    }

    public void xattr(boolean xattr) {
        this.xattr = xattr;
    }

    public boolean accessDeleted() {
        return this.accessDeleted;
    }

    public void accessDeleted(boolean accessDeleted) {
        if (!this.xattr && accessDeleted) {
            throw new IllegalArgumentException("Invalid to access document attributes with access deleted. It can be used only with xattr.");
        }
        this.accessDeleted = accessDeleted;
    }
}

