/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.message.kv.subdoc.multi;

import com.couchbase.client.core.annotations.InterfaceAudience;
import com.couchbase.client.core.annotations.InterfaceStability;
import com.couchbase.client.core.message.kv.AbstractKeyValueRequest;
import com.couchbase.client.core.message.kv.subdoc.BinarySubdocMultiMutationRequest;
import com.couchbase.client.core.message.kv.subdoc.multi.MutationCommand;
import com.couchbase.client.core.message.kv.subdoc.multi.SubMultiMutationDocOptionsBuilder;
import com.couchbase.client.deps.io.netty.buffer.ByteBuf;
import com.couchbase.client.deps.io.netty.buffer.CompositeByteBuf;
import com.couchbase.client.deps.io.netty.buffer.Unpooled;
import com.couchbase.client.deps.io.netty.util.CharsetUtil;
import java.util.Arrays;
import java.util.List;

@InterfaceStability.Committed
@InterfaceAudience.Public
public class SubMultiMutationRequest
extends AbstractKeyValueRequest
implements BinarySubdocMultiMutationRequest {
    private final List<MutationCommand> commands;
    private final ByteBuf encoded;
    private final int expiration;
    private final long cas;
    private byte docFlags;

    public SubMultiMutationRequest(String key, String bucket, int expiration, long cas, SubMultiMutationDocOptionsBuilder docOptionsBuilder, List<MutationCommand> commands) {
        super(key, bucket);
        if (commands == null || commands.isEmpty()) {
            throw new IllegalArgumentException("At least one mutation command is necessary");
        }
        this.commands = commands;
        this.encoded = SubMultiMutationRequest.encode(commands);
        this.expiration = expiration;
        this.cas = cas;
        if (docOptionsBuilder.createDocument()) {
            this.docFlags = (byte)(this.docFlags | 1);
        }
        if (docOptionsBuilder.insertDocument()) {
            this.docFlags = (byte)(this.docFlags | 2);
        }
    }

    public SubMultiMutationRequest(String key, String bucket, int expiration, long cas, SubMultiMutationDocOptionsBuilder docOptionsBuilder, MutationCommand ... commands) {
        this(key, bucket, expiration, cas, docOptionsBuilder, commands == null ? null : Arrays.asList(commands));
    }

    public SubMultiMutationRequest(String key, String bucket, List<MutationCommand> commands) {
        this(key, bucket, 0, 0L, SubMultiMutationDocOptionsBuilder.builder(), commands);
    }

    public SubMultiMutationRequest(String key, String bucket, SubMultiMutationDocOptionsBuilder docOptionsBuilder, List<MutationCommand> commands) {
        this(key, bucket, 0, 0L, docOptionsBuilder, commands);
    }

    public SubMultiMutationRequest(String key, String bucket, MutationCommand ... commands) {
        this(key, bucket, 0, 0L, SubMultiMutationDocOptionsBuilder.builder(), commands);
    }

    public SubMultiMutationRequest(String key, String bucket, SubMultiMutationDocOptionsBuilder docOptionsBuilder, MutationCommand ... commands) {
        this(key, bucket, 0, 0L, docOptionsBuilder, commands);
    }

    private static ByteBuf encode(List<MutationCommand> commands) {
        CompositeByteBuf compositeBuf = Unpooled.compositeBuffer(commands.size());
        for (MutationCommand command : commands) {
            byte[] pathBytes = command.path().getBytes(CharsetUtil.UTF_8);
            short pathLength = (short)pathBytes.length;
            ByteBuf commandBuf = Unpooled.buffer(4 + pathLength + command.fragment().readableBytes());
            commandBuf.writeByte(command.opCode());
            byte subdocFlags = 0;
            if (command.createIntermediaryPath()) {
                subdocFlags = (byte)(subdocFlags | 1);
            }
            if (command.xattr()) {
                subdocFlags = (byte)(subdocFlags | 4);
            }
            commandBuf.writeByte(subdocFlags);
            commandBuf.writeShort(pathLength);
            commandBuf.writeInt(command.fragment().readableBytes());
            commandBuf.writeBytes(pathBytes);
            commandBuf.writeBytes(command.fragment(), command.fragment().readerIndex(), command.fragment().readableBytes());
            command.fragment().release();
            compositeBuf.addComponent(commandBuf);
            compositeBuf.writerIndex(compositeBuf.writerIndex() + commandBuf.readableBytes());
        }
        return compositeBuf;
    }

    @Override
    public int expiration() {
        return this.expiration;
    }

    @Override
    public long cas() {
        return this.cas;
    }

    @Override
    public List<MutationCommand> commands() {
        return this.commands;
    }

    @Override
    public ByteBuf content() {
        return this.encoded;
    }

    @Override
    public byte docFlags() {
        return this.docFlags;
    }
}

