/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.service.strategies;

import com.couchbase.client.core.endpoint.Endpoint;
import com.couchbase.client.core.message.CouchbaseRequest;
import com.couchbase.client.core.service.strategies.SelectionStrategy;
import com.couchbase.client.core.state.LifecycleState;
import java.util.List;

public class RoundRobinSelectionStrategy
implements SelectionStrategy {
    protected volatile int skip = 0;

    @Override
    public Endpoint select(CouchbaseRequest request, List<Endpoint> endpoints) {
        Endpoint endpoint;
        int offset;
        int i;
        int endpointSize = endpoints.size();
        this.skip = Math.max(0, this.skip + 1);
        for (i = offset = this.skip % endpointSize; i < endpointSize; ++i) {
            endpoint = endpoints.get(i);
            if (!endpoint.isState(LifecycleState.CONNECTED) || !endpoint.isFree()) continue;
            return endpoint;
        }
        for (i = 0; i < offset; ++i) {
            endpoint = endpoints.get(i);
            if (!endpoint.isState(LifecycleState.CONNECTED) || !endpoint.isFree()) continue;
            return endpoint;
        }
        return null;
    }

    protected void setSkip(int newValue) {
        this.skip = newValue < 0 ? 0 : newValue;
    }
}

