/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.message.dcp;

import com.couchbase.client.core.annotations.InterfaceAudience;
import com.couchbase.client.core.annotations.InterfaceStability;
import com.couchbase.client.core.message.dcp.AbstractDCPRequest;

@InterfaceStability.Experimental
@InterfaceAudience.Private
public class SnapshotMarkerMessage
extends AbstractDCPRequest {
    public static final int MEMORY = 1;
    public static final int DISK = 2;
    public static final int CHECKPOINT = 4;
    public static final int ACK = 8;
    private final long startSequenceNumber;
    private final long endSequenceNumber;
    private final int flags;
    private final boolean memory;
    private final boolean disk;
    private final boolean checkpoint;
    private final boolean ack;

    public SnapshotMarkerMessage(short partition, long startSequenceNumber, long endSequenceNumber, int flags, String bucket) {
        this(partition, startSequenceNumber, endSequenceNumber, flags, bucket, null);
    }

    public SnapshotMarkerMessage(short partition, long startSequenceNumber, long endSequenceNumber, int flags, String bucket, String password) {
        super(bucket, password);
        this.partition(partition);
        this.startSequenceNumber = startSequenceNumber;
        this.endSequenceNumber = endSequenceNumber;
        this.flags = flags;
        this.memory = (flags & 1) == 1;
        this.disk = (flags & 2) == 2;
        this.checkpoint = (flags & 4) == 4;
        this.ack = (flags & 8) == 8;
    }

    public long startSequenceNumber() {
        return this.startSequenceNumber;
    }

    public long endSequenceNumber() {
        return this.endSequenceNumber;
    }

    public int flags() {
        return this.flags;
    }

    public boolean memory() {
        return this.memory;
    }

    public boolean disk() {
        return this.disk;
    }

    public boolean checkpoint() {
        return this.checkpoint;
    }

    public boolean ack() {
        return this.ack;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("SnapshotMarkerMessage{");
        sb.append("startSequenceNumber=").append(this.startSequenceNumber);
        sb.append(", endSequenceNumber=").append(this.endSequenceNumber);
        sb.append(", memory=").append(this.memory);
        sb.append(", disk=").append(this.disk);
        sb.append(", checkpoint=").append(this.checkpoint);
        sb.append(", ack=").append(this.ack);
        sb.append('}');
        return sb.toString();
    }
}

