/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.endpoint;

import com.couchbase.client.core.endpoint.kv.KeyValueStatus;
import com.couchbase.client.core.logging.CouchbaseLogger;
import com.couchbase.client.core.logging.CouchbaseLoggerFactory;
import com.couchbase.client.core.message.ResponseStatus;

public class ResponseStatusConverter {
    private static final CouchbaseLogger LOGGER = CouchbaseLoggerFactory.getInstance(ResponseStatusConverter.class);
    public static final int HTTP_OK = 200;
    public static final int HTTP_CREATED = 201;
    public static final int HTTP_ACCEPTED = 202;
    public static final int HTTP_BAD_REQUEST = 400;
    public static final int HTTP_NOT_FOUND = 404;
    public static final int HTTP_INTERNAL_ERROR = 500;

    public static ResponseStatus fromBinary(short code) {
        KeyValueStatus status = KeyValueStatus.valueOf(code);
        switch (status) {
            case SUCCESS: {
                return ResponseStatus.SUCCESS;
            }
            case ERR_EXISTS: {
                return ResponseStatus.EXISTS;
            }
            case ERR_NOT_FOUND: {
                return ResponseStatus.NOT_EXISTS;
            }
            case ERR_NOT_MY_VBUCKET: {
                return ResponseStatus.RETRY;
            }
            case ERR_NOT_STORED: {
                return ResponseStatus.NOT_STORED;
            }
            case ERR_TOO_BIG: {
                return ResponseStatus.TOO_BIG;
            }
            case ERR_TEMP_FAIL: {
                return ResponseStatus.TEMPORARY_FAILURE;
            }
            case ERR_BUSY: {
                return ResponseStatus.SERVER_BUSY;
            }
            case ERR_NO_MEM: {
                return ResponseStatus.OUT_OF_MEMORY;
            }
            case ERR_UNKNOWN_COMMAND: {
                return ResponseStatus.COMMAND_UNAVAILABLE;
            }
            case ERR_NOT_SUPPORTED: {
                return ResponseStatus.COMMAND_UNAVAILABLE;
            }
            case ERR_INTERNAL: {
                return ResponseStatus.INTERNAL_ERROR;
            }
            case ERR_INVALID: {
                return ResponseStatus.INVALID_ARGUMENTS;
            }
            case ERR_DELTA_BADVAL: {
                return ResponseStatus.INVALID_ARGUMENTS;
            }
            case ERR_RANGE: {
                return ResponseStatus.RANGE_ERROR;
            }
            case ERR_ROLLBACK: {
                return ResponseStatus.ROLLBACK;
            }
        }
        LOGGER.warn("Unexpected ResponseStatus with Protocol KeyValue: {} (0x{}, {})", new Object[]{status, Integer.toHexString(status.code()), status.description()});
        return ResponseStatus.FAILURE;
    }

    public static ResponseStatus fromHttp(int code) {
        ResponseStatus status;
        switch (code) {
            case 200: 
            case 201: 
            case 202: {
                status = ResponseStatus.SUCCESS;
                break;
            }
            case 404: {
                status = ResponseStatus.NOT_EXISTS;
                break;
            }
            case 400: {
                status = ResponseStatus.INVALID_ARGUMENTS;
                break;
            }
            case 500: {
                status = ResponseStatus.INTERNAL_ERROR;
                break;
            }
            default: {
                LOGGER.warn("Unknown ResponseStatus with Protocol HTTP: {}", (Object)code);
                status = ResponseStatus.FAILURE;
            }
        }
        return status;
    }
}

