/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.dcp;

import com.couchbase.client.core.annotations.InterfaceAudience;
import com.couchbase.client.core.annotations.InterfaceStability;
import com.couchbase.client.core.dcp.BucketStreamState;
import com.couchbase.client.core.dcp.BucketStreamStateUpdatedEvent;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import rx.Observable;
import rx.subjects.PublishSubject;
import rx.subjects.Subject;

@InterfaceStability.Experimental
@InterfaceAudience.Public
public class BucketStreamAggregatorState
implements Iterable<BucketStreamState> {
    private final String name;
    private final Subject<BucketStreamStateUpdatedEvent, BucketStreamStateUpdatedEvent> updates = PublishSubject.create().toSerialized();
    private final Map<Short, BucketStreamState> feeds = new HashMap<Short, BucketStreamState>(1024);

    public BucketStreamAggregatorState(String name) {
        this.name = name;
    }

    public Observable<BucketStreamStateUpdatedEvent> updates() {
        return this.updates;
    }

    public void put(BucketStreamState state) {
        this.put(state, true);
    }

    public void put(BucketStreamState state, boolean notify) {
        this.feeds.put(state.partition(), state);
        if (notify) {
            this.updates.onNext((Object)new BucketStreamStateUpdatedEvent(this, state));
        }
    }

    public BucketStreamState get(short partition) {
        return this.feeds.get(partition);
    }

    public BucketStreamState remove(short partition) {
        return this.feeds.remove(partition);
    }

    public int size() {
        return this.feeds.size();
    }

    public String name() {
        return this.name;
    }

    @Override
    public Iterator<BucketStreamState> iterator() {
        return this.feeds.values().iterator();
    }

    public String toString() {
        return this.feeds.values().toString();
    }
}

