/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.endpoint.kv;

import com.couchbase.client.core.ResponseEvent;
import com.couchbase.client.core.endpoint.AbstractEndpoint;
import com.couchbase.client.core.endpoint.AbstractGenericHandler;
import com.couchbase.client.core.endpoint.ResponseStatusConverter;
import com.couchbase.client.core.endpoint.ServerFeatures;
import com.couchbase.client.core.endpoint.ServerFeaturesEvent;
import com.couchbase.client.core.logging.CouchbaseLogger;
import com.couchbase.client.core.logging.CouchbaseLoggerFactory;
import com.couchbase.client.core.message.CouchbaseRequest;
import com.couchbase.client.core.message.CouchbaseResponse;
import com.couchbase.client.core.message.ResponseStatus;
import com.couchbase.client.core.message.kv.AbstractKeyValueRequest;
import com.couchbase.client.core.message.kv.AbstractKeyValueResponse;
import com.couchbase.client.core.message.kv.AppendRequest;
import com.couchbase.client.core.message.kv.AppendResponse;
import com.couchbase.client.core.message.kv.BinaryRequest;
import com.couchbase.client.core.message.kv.BinaryStoreRequest;
import com.couchbase.client.core.message.kv.CounterRequest;
import com.couchbase.client.core.message.kv.CounterResponse;
import com.couchbase.client.core.message.kv.FailoverObserveSeqnoResponse;
import com.couchbase.client.core.message.kv.GetBucketConfigRequest;
import com.couchbase.client.core.message.kv.GetBucketConfigResponse;
import com.couchbase.client.core.message.kv.GetRequest;
import com.couchbase.client.core.message.kv.GetResponse;
import com.couchbase.client.core.message.kv.InsertRequest;
import com.couchbase.client.core.message.kv.InsertResponse;
import com.couchbase.client.core.message.kv.MutationToken;
import com.couchbase.client.core.message.kv.NoFailoverObserveSeqnoResponse;
import com.couchbase.client.core.message.kv.ObserveRequest;
import com.couchbase.client.core.message.kv.ObserveResponse;
import com.couchbase.client.core.message.kv.ObserveSeqnoRequest;
import com.couchbase.client.core.message.kv.PrependRequest;
import com.couchbase.client.core.message.kv.PrependResponse;
import com.couchbase.client.core.message.kv.RemoveRequest;
import com.couchbase.client.core.message.kv.RemoveResponse;
import com.couchbase.client.core.message.kv.ReplaceRequest;
import com.couchbase.client.core.message.kv.ReplaceResponse;
import com.couchbase.client.core.message.kv.ReplicaGetRequest;
import com.couchbase.client.core.message.kv.StatRequest;
import com.couchbase.client.core.message.kv.StatResponse;
import com.couchbase.client.core.message.kv.TouchRequest;
import com.couchbase.client.core.message.kv.TouchResponse;
import com.couchbase.client.core.message.kv.UnlockRequest;
import com.couchbase.client.core.message.kv.UnlockResponse;
import com.couchbase.client.core.message.kv.UpsertRequest;
import com.couchbase.client.core.message.kv.UpsertResponse;
import com.couchbase.client.core.service.ServiceType;
import com.couchbase.client.deps.com.lmax.disruptor.EventSink;
import com.couchbase.client.deps.io.netty.buffer.ByteBuf;
import com.couchbase.client.deps.io.netty.buffer.Unpooled;
import com.couchbase.client.deps.io.netty.channel.ChannelHandlerContext;
import com.couchbase.client.deps.io.netty.handler.codec.memcache.binary.BinaryMemcacheRequest;
import com.couchbase.client.deps.io.netty.handler.codec.memcache.binary.DefaultBinaryMemcacheRequest;
import com.couchbase.client.deps.io.netty.handler.codec.memcache.binary.DefaultFullBinaryMemcacheRequest;
import com.couchbase.client.deps.io.netty.handler.codec.memcache.binary.FullBinaryMemcacheRequest;
import com.couchbase.client.deps.io.netty.handler.codec.memcache.binary.FullBinaryMemcacheResponse;
import java.util.Queue;

public class KeyValueHandler
extends AbstractGenericHandler<FullBinaryMemcacheResponse, BinaryMemcacheRequest, BinaryRequest> {
    private static final CouchbaseLogger LOGGER = CouchbaseLoggerFactory.getInstance(KeyValueHandler.class);
    public static final byte OP_GET_BUCKET_CONFIG = -75;
    public static final byte OP_GET = 0;
    public static final byte OP_GET_AND_LOCK = -108;
    public static final byte OP_GET_AND_TOUCH = 29;
    public static final byte OP_GET_REPLICA = -125;
    public static final byte OP_INSERT = 2;
    public static final byte OP_UPSERT = 1;
    public static final byte OP_REPLACE = 3;
    public static final byte OP_REMOVE = 4;
    public static final byte OP_COUNTER_INCR = 5;
    public static final byte OP_COUNTER_DECR = 6;
    public static final byte OP_UNLOCK = -107;
    public static final byte OP_OBSERVE = -110;
    public static final byte OP_OBSERVE_SEQ = -111;
    public static final byte OP_TOUCH = 28;
    public static final byte OP_APPEND = 14;
    public static final byte OP_PREPEND = 15;
    public static final byte OP_NOOP = 10;
    public static final byte OP_STAT = 16;
    boolean seqOnMutation = false;

    public KeyValueHandler(AbstractEndpoint endpoint, EventSink<ResponseEvent> responseBuffer, boolean isTransient) {
        super(endpoint, responseBuffer, isTransient);
    }

    KeyValueHandler(AbstractEndpoint endpoint, EventSink<ResponseEvent> responseBuffer, Queue<BinaryRequest> queue, boolean isTransient) {
        super(endpoint, responseBuffer, queue, isTransient);
    }

    @Override
    protected BinaryMemcacheRequest encodeRequest(ChannelHandlerContext ctx, BinaryRequest msg) throws Exception {
        BinaryMemcacheRequest request;
        if (msg instanceof GetRequest) {
            request = KeyValueHandler.handleGetRequest(ctx, (GetRequest)msg);
        } else if (msg instanceof BinaryStoreRequest) {
            request = KeyValueHandler.handleStoreRequest(ctx, (BinaryStoreRequest)msg);
        } else if (msg instanceof ReplicaGetRequest) {
            request = KeyValueHandler.handleReplicaGetRequest((ReplicaGetRequest)msg);
        } else if (msg instanceof RemoveRequest) {
            request = KeyValueHandler.handleRemoveRequest((RemoveRequest)msg);
        } else if (msg instanceof CounterRequest) {
            request = KeyValueHandler.handleCounterRequest(ctx, (CounterRequest)msg);
        } else if (msg instanceof TouchRequest) {
            request = KeyValueHandler.handleTouchRequest(ctx, (TouchRequest)msg);
        } else if (msg instanceof UnlockRequest) {
            request = KeyValueHandler.handleUnlockRequest((UnlockRequest)msg);
        } else if (msg instanceof ObserveRequest) {
            request = KeyValueHandler.handleObserveRequest(ctx, (ObserveRequest)msg);
        } else if (msg instanceof ObserveSeqnoRequest) {
            request = KeyValueHandler.handleObserveSeqnoRequest(ctx, (ObserveSeqnoRequest)msg);
        } else if (msg instanceof GetBucketConfigRequest) {
            request = KeyValueHandler.handleGetBucketConfigRequest();
        } else if (msg instanceof AppendRequest) {
            request = KeyValueHandler.handleAppendRequest((AppendRequest)msg);
        } else if (msg instanceof PrependRequest) {
            request = KeyValueHandler.handlePrependRequest((PrependRequest)msg);
        } else if (msg instanceof KeepAliveRequest) {
            request = KeyValueHandler.handleKeepAliveRequest((KeepAliveRequest)msg);
        } else if (msg instanceof StatRequest) {
            request = KeyValueHandler.handleStatRequest((StatRequest)msg);
        } else {
            throw new IllegalArgumentException("Unknown incoming BinaryRequest type " + msg.getClass());
        }
        if (msg.partition() >= 0) {
            request.setReserved(msg.partition());
        }
        request.setOpaque(msg.opaque());
        if (!(msg instanceof ObserveRequest) && !(msg instanceof ObserveSeqnoRequest) && request instanceof FullBinaryMemcacheRequest) {
            ((FullBinaryMemcacheRequest)request).content().retain();
        }
        return request;
    }

    private static BinaryMemcacheRequest handleGetRequest(ChannelHandlerContext ctx, GetRequest msg) {
        ByteBuf extras;
        byte opcode;
        if (msg.lock()) {
            opcode = -108;
            extras = ctx.alloc().buffer().writeInt(msg.expiry());
        } else if (msg.touch()) {
            opcode = 29;
            extras = ctx.alloc().buffer().writeInt(msg.expiry());
        } else {
            opcode = 0;
            extras = Unpooled.EMPTY_BUFFER;
        }
        String key = msg.key();
        short keyLength = (short)msg.keyBytes().length;
        byte extrasLength = (byte)extras.readableBytes();
        DefaultBinaryMemcacheRequest request = new DefaultBinaryMemcacheRequest(key);
        request.setOpcode(opcode).setKeyLength(keyLength).setExtras(extras).setExtrasLength(extrasLength).setTotalBodyLength(keyLength + extrasLength);
        return request;
    }

    private static BinaryMemcacheRequest handleGetBucketConfigRequest() {
        DefaultBinaryMemcacheRequest request = new DefaultBinaryMemcacheRequest();
        request.setOpcode((byte)-75);
        return request;
    }

    private static BinaryMemcacheRequest handleReplicaGetRequest(ReplicaGetRequest msg) {
        String key = msg.key();
        short keyLength = (short)msg.keyBytes().length;
        DefaultBinaryMemcacheRequest request = new DefaultBinaryMemcacheRequest(key);
        request.setOpcode((byte)-125).setKeyLength(keyLength).setTotalBodyLength(keyLength);
        return request;
    }

    private static BinaryMemcacheRequest handleStoreRequest(ChannelHandlerContext ctx, BinaryStoreRequest msg) {
        ByteBuf extras = ctx.alloc().buffer(8);
        extras.writeInt(msg.flags());
        extras.writeInt(msg.expiration());
        String key = msg.key();
        short keyLength = (short)msg.keyBytes().length;
        byte extrasLength = (byte)extras.readableBytes();
        DefaultFullBinaryMemcacheRequest request = new DefaultFullBinaryMemcacheRequest(key, extras, msg.content());
        if (msg instanceof InsertRequest) {
            request.setOpcode((byte)2);
        } else if (msg instanceof UpsertRequest) {
            request.setOpcode((byte)1);
        } else if (msg instanceof ReplaceRequest) {
            request.setOpcode((byte)3);
            request.setCAS(((ReplaceRequest)msg).cas());
        } else {
            throw new IllegalArgumentException("Unknown incoming BinaryStoreRequest type " + msg.getClass());
        }
        request.setKeyLength(keyLength);
        request.setTotalBodyLength(keyLength + msg.content().readableBytes() + extrasLength);
        request.setExtrasLength(extrasLength);
        return request;
    }

    private static BinaryMemcacheRequest handleRemoveRequest(RemoveRequest msg) {
        String key = msg.key();
        short keyLength = (short)msg.keyBytes().length;
        DefaultBinaryMemcacheRequest request = new DefaultBinaryMemcacheRequest(key);
        request.setOpcode((byte)4);
        request.setCAS(msg.cas());
        request.setKeyLength(keyLength);
        request.setTotalBodyLength(keyLength);
        return request;
    }

    private static BinaryMemcacheRequest handleCounterRequest(ChannelHandlerContext ctx, CounterRequest msg) {
        ByteBuf extras = ctx.alloc().buffer();
        extras.writeLong(Math.abs(msg.delta()));
        extras.writeLong(msg.initial());
        extras.writeInt(msg.expiry());
        String key = msg.key();
        short keyLength = (short)msg.keyBytes().length;
        byte extrasLength = (byte)extras.readableBytes();
        DefaultBinaryMemcacheRequest request = new DefaultBinaryMemcacheRequest(key, extras);
        request.setOpcode(msg.delta() < 0L ? (byte)6 : 5);
        request.setKeyLength(keyLength);
        request.setTotalBodyLength(keyLength + extrasLength);
        request.setExtrasLength(extrasLength);
        return request;
    }

    private static BinaryMemcacheRequest handleUnlockRequest(UnlockRequest msg) {
        String key = msg.key();
        short keyLength = (short)msg.keyBytes().length;
        DefaultBinaryMemcacheRequest request = new DefaultBinaryMemcacheRequest(key);
        request.setOpcode((byte)-107);
        request.setKeyLength(keyLength);
        request.setTotalBodyLength(keyLength);
        request.setCAS(msg.cas());
        return request;
    }

    private static BinaryMemcacheRequest handleTouchRequest(ChannelHandlerContext ctx, TouchRequest msg) {
        ByteBuf extras = ctx.alloc().buffer();
        extras.writeInt(msg.expiry());
        String key = msg.key();
        short keyLength = (short)msg.keyBytes().length;
        byte extrasLength = (byte)extras.readableBytes();
        DefaultBinaryMemcacheRequest request = new DefaultBinaryMemcacheRequest(key);
        request.setExtras(extras);
        request.setOpcode((byte)28);
        request.setKeyLength(keyLength);
        request.setTotalBodyLength(keyLength + extrasLength);
        request.setExtrasLength(extrasLength);
        return request;
    }

    private static BinaryMemcacheRequest handleObserveRequest(ChannelHandlerContext ctx, ObserveRequest msg) {
        String key = msg.key();
        short keyLength = (short)msg.keyBytes().length;
        ByteBuf content = ctx.alloc().buffer();
        content.writeShort(msg.partition());
        content.writeShort(keyLength);
        content.writeBytes(key.getBytes(CHARSET));
        DefaultFullBinaryMemcacheRequest request = new DefaultFullBinaryMemcacheRequest("", Unpooled.EMPTY_BUFFER, content);
        request.setOpcode((byte)-110);
        request.setTotalBodyLength(content.readableBytes());
        return request;
    }

    private static BinaryMemcacheRequest handleObserveSeqnoRequest(ChannelHandlerContext ctx, ObserveSeqnoRequest msg) {
        ByteBuf content = ctx.alloc().buffer();
        content.writeLong(msg.vbucketUUID());
        DefaultFullBinaryMemcacheRequest request = new DefaultFullBinaryMemcacheRequest("", Unpooled.EMPTY_BUFFER, content);
        request.setOpcode((byte)-111);
        request.setTotalBodyLength(content.readableBytes());
        return request;
    }

    private static BinaryMemcacheRequest handleAppendRequest(AppendRequest msg) {
        String key = msg.key();
        short keyLength = (short)msg.keyBytes().length;
        DefaultFullBinaryMemcacheRequest request = new DefaultFullBinaryMemcacheRequest(key, Unpooled.EMPTY_BUFFER, msg.content());
        request.setOpcode((byte)14);
        request.setKeyLength(keyLength);
        request.setCAS(msg.cas());
        request.setTotalBodyLength(keyLength + msg.content().readableBytes());
        return request;
    }

    private static BinaryMemcacheRequest handlePrependRequest(PrependRequest msg) {
        String key = msg.key();
        short keyLength = (short)msg.keyBytes().length;
        DefaultFullBinaryMemcacheRequest request = new DefaultFullBinaryMemcacheRequest(key, Unpooled.EMPTY_BUFFER, msg.content());
        request.setOpcode((byte)15);
        request.setKeyLength(keyLength);
        request.setCAS(msg.cas());
        request.setTotalBodyLength(keyLength + msg.content().readableBytes());
        return request;
    }

    private static BinaryMemcacheRequest handleKeepAliveRequest(KeepAliveRequest msg) {
        DefaultBinaryMemcacheRequest request = new DefaultBinaryMemcacheRequest();
        request.setOpcode((byte)10).setKeyLength((short)0).setExtras(Unpooled.EMPTY_BUFFER).setExtrasLength((byte)0).setTotalBodyLength(0);
        return request;
    }

    private static BinaryMemcacheRequest handleStatRequest(StatRequest msg) {
        String key = msg.key();
        DefaultBinaryMemcacheRequest request = new DefaultBinaryMemcacheRequest(key);
        short keyLength = (short)msg.keyBytes().length;
        request.setOpcode((byte)16).setKeyLength(keyLength).setTotalBodyLength(keyLength);
        return request;
    }

    @Override
    protected CouchbaseResponse decodeResponse(ChannelHandlerContext ctx, FullBinaryMemcacheResponse msg) throws Exception {
        BinaryRequest request = (BinaryRequest)this.currentRequest();
        if (request.opaque() != msg.getOpaque()) {
            throw new IllegalStateException("Opaque values for " + msg.getClass() + " do not match.");
        }
        ResponseStatus status = ResponseStatusConverter.fromBinary(msg.getStatus());
        if (!status.equals((Object)ResponseStatus.RETRY)) {
            KeyValueHandler.maybeFreeContent(request);
        }
        msg.content().retain();
        CouchbaseResponse response = KeyValueHandler.handleCommonResponseMessages(request, msg, ctx, status, this.seqOnMutation);
        if (response == null) {
            response = KeyValueHandler.handleOtherResponseMessages(request, msg, status, this.seqOnMutation, this.remoteHostname());
        }
        if (response == null) {
            throw new IllegalStateException("Unhandled request/response pair: " + request.getClass() + "/" + msg.getClass());
        }
        if (request instanceof StatRequest) {
            ((StatRequest)request).add((StatResponse)response);
            if (((StatResponse)response).key() == null) {
                this.finishedDecoding();
            }
            return null;
        }
        this.finishedDecoding();
        return response;
    }

    private static CouchbaseResponse handleCommonResponseMessages(BinaryRequest request, FullBinaryMemcacheResponse msg, ChannelHandlerContext ctx, ResponseStatus status, boolean seqOnMutation) {
        AbstractKeyValueResponse response = null;
        ByteBuf content = msg.content();
        long cas = msg.getCAS();
        short statusCode = msg.getStatus();
        String bucket = request.bucket();
        if (request instanceof GetRequest || request instanceof ReplicaGetRequest) {
            int flags = KeyValueHandler.extractFlagsFromGetResponse(ctx, msg.getExtras(), msg.getExtrasLength());
            response = new GetResponse(status, statusCode, cas, flags, bucket, content, request);
        } else if (request instanceof GetBucketConfigRequest) {
            response = new GetBucketConfigResponse(status, statusCode, bucket, content, ((GetBucketConfigRequest)request).hostname());
        } else if (request instanceof InsertRequest) {
            MutationToken descr = KeyValueHandler.extractToken(seqOnMutation, status.isSuccess(), msg.getExtras(), request.partition());
            response = new InsertResponse(status, statusCode, cas, bucket, content, descr, request);
        } else if (request instanceof UpsertRequest) {
            MutationToken descr = KeyValueHandler.extractToken(seqOnMutation, status.isSuccess(), msg.getExtras(), request.partition());
            response = new UpsertResponse(status, statusCode, cas, bucket, content, descr, request);
        } else if (request instanceof ReplaceRequest) {
            MutationToken descr = KeyValueHandler.extractToken(seqOnMutation, status.isSuccess(), msg.getExtras(), request.partition());
            response = new ReplaceResponse(status, statusCode, cas, bucket, content, descr, request);
        } else if (request instanceof RemoveRequest) {
            MutationToken descr = KeyValueHandler.extractToken(seqOnMutation, status.isSuccess(), msg.getExtras(), request.partition());
            response = new RemoveResponse(status, statusCode, cas, bucket, content, descr, request);
        }
        return response;
    }

    private static MutationToken extractToken(boolean seqOnMutation, boolean success, ByteBuf extras, long vbid) {
        if (success && seqOnMutation) {
            return new MutationToken(vbid, extras.readLong(), extras.readLong());
        }
        return null;
    }

    private static CouchbaseResponse handleOtherResponseMessages(BinaryRequest request, FullBinaryMemcacheResponse msg, ResponseStatus status, boolean seqOnMutation, String remoteHostname) {
        AbstractKeyValueResponse response = null;
        ByteBuf content = msg.content();
        long cas = msg.getCAS();
        short statusCode = msg.getStatus();
        String bucket = request.bucket();
        if (request instanceof UnlockRequest) {
            response = new UnlockResponse(status, statusCode, bucket, content, request);
        } else if (request instanceof TouchRequest) {
            response = new TouchResponse(status, statusCode, bucket, content, request);
        } else if (request instanceof AppendRequest) {
            MutationToken descr = KeyValueHandler.extractToken(seqOnMutation, status.isSuccess(), msg.getExtras(), request.partition());
            response = new AppendResponse(status, statusCode, cas, bucket, content, descr, request);
        } else if (request instanceof PrependRequest) {
            MutationToken descr = KeyValueHandler.extractToken(seqOnMutation, status.isSuccess(), msg.getExtras(), request.partition());
            response = new PrependResponse(status, statusCode, cas, bucket, content, descr, request);
        } else if (request instanceof KeepAliveRequest) {
            KeyValueHandler.releaseContent(content);
            response = new KeepAliveResponse(status, statusCode, request);
        } else if (request instanceof CounterRequest) {
            long value = status.isSuccess() ? content.readLong() : 0L;
            KeyValueHandler.releaseContent(content);
            MutationToken descr = KeyValueHandler.extractToken(seqOnMutation, status.isSuccess(), msg.getExtras(), request.partition());
            response = new CounterResponse(status, statusCode, bucket, value, cas, descr, request);
        } else if (request instanceof StatRequest) {
            String key = msg.getKey();
            String value = content.toString(CHARSET);
            KeyValueHandler.releaseContent(content);
            response = new StatResponse(status, statusCode, remoteHostname, key, value, bucket, request);
        } else if (request instanceof ObserveRequest) {
            byte observed = ObserveResponse.ObserveStatus.UNKNOWN.value();
            long observedCas = 0L;
            if (status.isSuccess()) {
                short keyLength = content.getShort(2);
                observed = content.getByte(keyLength + 4);
                observedCas = content.getLong(keyLength + 5);
            }
            KeyValueHandler.releaseContent(content);
            response = new ObserveResponse(status, statusCode, observed, ((ObserveRequest)request).master(), observedCas, bucket, request);
        } else if (request instanceof ObserveSeqnoRequest) {
            if (status.isSuccess()) {
                byte format = content.readByte();
                switch (format) {
                    case 0: {
                        response = new NoFailoverObserveSeqnoResponse(((ObserveSeqnoRequest)request).master(), content.readShort(), content.readLong(), content.readLong(), content.readLong(), status, statusCode, bucket, request);
                        break;
                    }
                    case 1: {
                        response = new FailoverObserveSeqnoResponse(((ObserveSeqnoRequest)request).master(), content.readShort(), content.readLong(), content.readLong(), content.readLong(), content.readLong(), content.readLong(), status, statusCode, bucket, request);
                        break;
                    }
                    default: {
                        throw new IllegalStateException("Unknown format for observe-seq: " + format);
                    }
                }
            } else {
                response = new NoFailoverObserveSeqnoResponse(((ObserveSeqnoRequest)request).master(), 0, 0L, 0L, 0L, status, statusCode, bucket, request);
            }
            KeyValueHandler.releaseContent(content);
        }
        return response;
    }

    private static void maybeFreeContent(BinaryRequest request) {
        ByteBuf content = null;
        if (request instanceof BinaryStoreRequest) {
            content = ((BinaryStoreRequest)request).content();
        } else if (request instanceof AppendRequest) {
            content = ((AppendRequest)request).content();
        } else if (request instanceof PrependRequest) {
            content = ((PrependRequest)request).content();
        }
        KeyValueHandler.releaseContent(content);
    }

    private static void releaseContent(ByteBuf content) {
        if (content != null && content.refCnt() > 0) {
            content.release();
        }
    }

    private static int extractFlagsFromGetResponse(ChannelHandlerContext ctx, ByteBuf extrasReleased, int extrasLength) {
        int flags = 0;
        if (extrasLength > 0) {
            ByteBuf extras = ctx.alloc().buffer(extrasLength);
            extras.writeBytes(extrasReleased, extrasReleased.readerIndex(), extrasReleased.readableBytes());
            flags = extras.getInt(0);
            extras.release();
        }
        return flags;
    }

    @Override
    protected void sideEffectRequestToCancel(BinaryRequest request) {
        super.sideEffectRequestToCancel(request);
        if (request instanceof BinaryStoreRequest) {
            ((BinaryStoreRequest)request).content().release();
        } else if (request instanceof AppendRequest) {
            ((AppendRequest)request).content().release();
        } else if (request instanceof PrependRequest) {
            ((PrependRequest)request).content().release();
        }
    }

    @Override
    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
        if (evt instanceof ServerFeaturesEvent) {
            this.seqOnMutation = this.env().mutationTokensEnabled() && ((ServerFeaturesEvent)evt).supportedFeatures().contains((Object)ServerFeatures.MUTATION_SEQNO);
        }
        super.userEventTriggered(ctx, evt);
    }

    @Override
    protected CouchbaseRequest createKeepAliveRequest() {
        return new KeepAliveRequest();
    }

    @Override
    protected ServiceType serviceType() {
        return ServiceType.BINARY;
    }

    protected static class KeepAliveResponse
    extends AbstractKeyValueResponse {
        public KeepAliveResponse(ResponseStatus status, short serverStatusCode, CouchbaseRequest request) {
            super(status, serverStatusCode, null, null, request);
        }
    }

    protected static class KeepAliveRequest
    extends AbstractKeyValueRequest {
        protected KeepAliveRequest() {
            super((String)null, (String)null, (String)null);
            this.partition((short)0);
        }
    }
}

