/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.config;

import com.couchbase.client.core.ClusterFacade;
import com.couchbase.client.core.config.BucketConfig;
import com.couchbase.client.core.config.ClusterConfig;
import com.couchbase.client.core.config.ConfigurationException;
import com.couchbase.client.core.config.ConfigurationProvider;
import com.couchbase.client.core.config.DefaultClusterConfig;
import com.couchbase.client.core.config.LoaderType;
import com.couchbase.client.core.config.loader.CarrierLoader;
import com.couchbase.client.core.config.loader.HttpLoader;
import com.couchbase.client.core.config.loader.Loader;
import com.couchbase.client.core.config.parser.BucketConfigParser;
import com.couchbase.client.core.config.refresher.CarrierRefresher;
import com.couchbase.client.core.config.refresher.HttpRefresher;
import com.couchbase.client.core.config.refresher.Refresher;
import com.couchbase.client.core.env.CoreEnvironment;
import com.couchbase.client.core.event.EventBus;
import com.couchbase.client.core.event.system.BucketClosedEvent;
import com.couchbase.client.core.event.system.BucketOpenedEvent;
import com.couchbase.client.core.lang.Tuple2;
import com.couchbase.client.core.logging.CouchbaseLogger;
import com.couchbase.client.core.logging.CouchbaseLoggerFactory;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import rx.Observable;
import rx.functions.Action1;
import rx.functions.Func1;
import rx.subjects.PublishSubject;
import rx.subjects.Subject;

public class DefaultConfigurationProvider
implements ConfigurationProvider {
    private static final CouchbaseLogger LOGGER = CouchbaseLoggerFactory.getInstance(ConfigurationProvider.class);
    private final ClusterFacade cluster;
    private final Subject<ClusterConfig, ClusterConfig> configObservable;
    private final AtomicReference<ClusterConfig> currentConfig;
    private final AtomicReference<Set<InetAddress>> seedHosts;
    private final List<Loader> loaderChain;
    private final Map<LoaderType, Refresher> refreshers;
    private final CoreEnvironment environment;
    private final EventBus eventBus;
    private volatile boolean bootstrapped;

    public DefaultConfigurationProvider(final ClusterFacade cluster, final CoreEnvironment environment) {
        this(cluster, environment, Arrays.asList(new CarrierLoader(cluster, environment), new HttpLoader(cluster, environment)), (Map<LoaderType, Refresher>)new HashMap<LoaderType, Refresher>(){
            {
                this.put(LoaderType.Carrier, new CarrierRefresher(environment, cluster));
                this.put(LoaderType.HTTP, new HttpRefresher(cluster));
            }
        });
    }

    public DefaultConfigurationProvider(ClusterFacade cluster, CoreEnvironment environment, List<Loader> loaderChain, Map<LoaderType, Refresher> refreshers) {
        if (cluster == null) {
            throw new IllegalArgumentException("A cluster reference needs to be provided");
        }
        if (loaderChain == null || loaderChain.isEmpty()) {
            throw new IllegalArgumentException("At least one config loader needs to be provided");
        }
        this.cluster = cluster;
        this.loaderChain = loaderChain;
        this.refreshers = refreshers;
        this.environment = environment;
        this.eventBus = environment.eventBus();
        this.configObservable = PublishSubject.create().toSerialized();
        this.seedHosts = new AtomicReference();
        this.bootstrapped = false;
        this.currentConfig = new AtomicReference<DefaultClusterConfig>(new DefaultClusterConfig());
        Observable.from(refreshers.values()).doOnNext((Action1)new Action1<Refresher>(){

            public void call(Refresher refresher) {
                refresher.provider(DefaultConfigurationProvider.this);
            }
        }).flatMap((Func1)new Func1<Refresher, Observable<BucketConfig>>(){

            public Observable<BucketConfig> call(Refresher refresher) {
                return refresher.configs();
            }
        }).subscribe((Action1)new Action1<BucketConfig>(){

            public void call(BucketConfig bucketConfig) {
                DefaultConfigurationProvider.this.upsertBucketConfig(bucketConfig);
            }
        });
    }

    @Override
    public Observable<ClusterConfig> configs() {
        return this.configObservable;
    }

    @Override
    public ClusterConfig config() {
        return this.currentConfig.get();
    }

    @Override
    public boolean seedHosts(Set<InetAddress> hosts, boolean shuffle) {
        if (this.bootstrapped) {
            LOGGER.debug("Seed hosts called with {}, but already bootstrapped.", (Object)hosts);
            return false;
        }
        LOGGER.debug("Setting seed hosts to {}", (Object)hosts);
        if (shuffle) {
            ArrayList<InetAddress> hostsList = new ArrayList<InetAddress>(hosts);
            Collections.shuffle(hostsList);
            this.seedHosts.set(new HashSet<InetAddress>(hostsList));
        } else {
            this.seedHosts.set(hosts);
        }
        return true;
    }

    @Override
    public Observable<ClusterConfig> openBucket(final String bucket, final String password) {
        LOGGER.debug("Got instructed to open bucket {}", (Object)bucket);
        if (this.currentConfig.get() != null && this.currentConfig.get().hasBucket(bucket)) {
            LOGGER.debug("Bucket {} already opened.", (Object)bucket);
            return Observable.just((Object)this.currentConfig.get());
        }
        if (this.seedHosts.get() == null || this.seedHosts.get().isEmpty()) {
            return Observable.error((Throwable)new ConfigurationException("Seed node list not provided or empty."));
        }
        Observable observable = Observable.mergeDelayError((Observable)Observable.from((Iterable)this.seedHosts.get()).map((Func1)new Func1<InetAddress, Observable<Tuple2<LoaderType, BucketConfig>>>(){

            public Observable<Tuple2<LoaderType, BucketConfig>> call(InetAddress seedHost) {
                Observable node = ((Loader)DefaultConfigurationProvider.this.loaderChain.get(0)).loadConfig(seedHost, bucket, password);
                for (int i = 1; i < DefaultConfigurationProvider.this.loaderChain.size(); ++i) {
                    node = node.onErrorResumeNext(((Loader)DefaultConfigurationProvider.this.loaderChain.get(i)).loadConfig(seedHost, bucket, password));
                }
                return node;
            }
        })).take(1);
        return observable.doOnNext((Action1)new Action1<Tuple2<LoaderType, BucketConfig>>(){

            public void call(Tuple2<LoaderType, BucketConfig> tuple) {
                DefaultConfigurationProvider.this.registerBucketForRefresh(tuple.value1(), tuple.value2());
            }
        }).map((Func1)new Func1<Tuple2<LoaderType, BucketConfig>, ClusterConfig>(){

            public ClusterConfig call(Tuple2<LoaderType, BucketConfig> tuple) {
                DefaultConfigurationProvider.this.upsertBucketConfig(tuple.value2());
                return (ClusterConfig)DefaultConfigurationProvider.this.currentConfig.get();
            }
        }).doOnNext((Action1)new Action1<ClusterConfig>(){

            public void call(ClusterConfig clusterConfig) {
                LOGGER.info("Opened bucket " + bucket);
                if (DefaultConfigurationProvider.this.eventBus != null) {
                    DefaultConfigurationProvider.this.eventBus.publish(new BucketOpenedEvent(bucket));
                }
            }
        }).doOnError((Action1)new Action1<Throwable>(){

            public void call(Throwable throwable) {
                LOGGER.debug("Explicitly closing bucket {} after failed open attempt to clean resources.", (Object)bucket);
                DefaultConfigurationProvider.this.removeBucketConfig(bucket);
            }
        }).onErrorResumeNext((Func1)new Func1<Throwable, Observable<ClusterConfig>>(){

            public Observable<ClusterConfig> call(Throwable throwable) {
                return Observable.error((Throwable)new ConfigurationException("Could not open bucket.", throwable));
            }
        });
    }

    @Override
    public Observable<ClusterConfig> closeBucket(String name) {
        LOGGER.debug("Closing bucket {}", (Object)name);
        return Observable.just((Object)name).map((Func1)new Func1<String, ClusterConfig>(){

            public ClusterConfig call(String bucket) {
                DefaultConfigurationProvider.this.removeBucketConfig(bucket);
                LOGGER.info("Closed bucket " + bucket);
                if (DefaultConfigurationProvider.this.eventBus != null) {
                    DefaultConfigurationProvider.this.eventBus.publish(new BucketClosedEvent(bucket));
                }
                return (ClusterConfig)DefaultConfigurationProvider.this.currentConfig.get();
            }
        });
    }

    @Override
    public Observable<Boolean> closeBuckets() {
        LOGGER.debug("Closing all open buckets");
        if (this.currentConfig.get() == null || this.currentConfig.get().bucketConfigs().isEmpty()) {
            return Observable.just((Object)true);
        }
        HashSet<String> configs = new HashSet<String>(this.currentConfig.get().bucketConfigs().keySet());
        return Observable.from(configs).observeOn(this.environment.scheduler()).flatMap((Func1)new Func1<String, Observable<? extends ClusterConfig>>(){

            public Observable<? extends ClusterConfig> call(String bucketName) {
                return DefaultConfigurationProvider.this.closeBucket(bucketName);
            }
        }).last().map((Func1)new Func1<ClusterConfig, Boolean>(){

            public Boolean call(ClusterConfig clusterConfig) {
                return true;
            }
        });
    }

    @Override
    public void proposeBucketConfig(String bucket, String rawConfig) {
        LOGGER.debug("New Bucket {} config proposed.", (Object)bucket);
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("Proposed raw config is {}", (Object)rawConfig);
        }
        BucketConfig config = BucketConfigParser.parse(rawConfig);
        this.upsertBucketConfig(config);
    }

    @Override
    public void signalOutdated() {
        LOGGER.debug("Received signal for outdated configuration.");
        if (this.currentConfig.get().bucketConfigs().isEmpty()) {
            LOGGER.debug("Ignoring outdated signal, since no buckets are open.");
            return;
        }
        for (Refresher refresher : this.refreshers.values()) {
            refresher.refresh(this.currentConfig.get());
        }
    }

    private void registerBucketForRefresh(LoaderType loaderType, BucketConfig bucketConfig) {
        LOGGER.debug("Registering Bucket {} to refresh at Loader {}", (Object)bucketConfig.name(), (Object)loaderType);
        Refresher refresher = this.refreshers.get((Object)loaderType);
        if (refresher == null) {
            throw new IllegalStateException("Could not find refresher for loader type: " + (Object)((Object)loaderType));
        }
        refresher.registerBucket(bucketConfig.name(), bucketConfig.password()).subscribe();
    }

    private void upsertBucketConfig(BucketConfig newConfig) {
        ClusterConfig cluster = this.currentConfig.get();
        BucketConfig oldConfig = cluster.bucketConfig(newConfig.name());
        if (newConfig.rev() > 0L && oldConfig != null && newConfig.rev() <= oldConfig.rev()) {
            LOGGER.trace("Not applying new configuration, older rev ID.");
            return;
        }
        if (newConfig.password() == null && oldConfig != null) {
            newConfig.password(oldConfig.password());
        }
        cluster.setBucketConfig(newConfig.name(), newConfig);
        LOGGER.debug("Applying new configuration {}", (Object)newConfig);
        this.currentConfig.set(cluster);
        boolean tainted = newConfig.tainted();
        for (Refresher refresher : this.refreshers.values()) {
            if (tainted) {
                refresher.markTainted(newConfig);
                continue;
            }
            refresher.markUntainted(newConfig);
        }
        this.configObservable.onNext((Object)this.currentConfig.get());
    }

    private void removeBucketConfig(String name) {
        LOGGER.debug("Removing bucket {} configuration from known configs.", (Object)name);
        ClusterConfig cluster = this.currentConfig.get();
        cluster.deleteBucketConfig(name);
        this.currentConfig.set(cluster);
        this.configObservable.onNext((Object)this.currentConfig.get());
    }
}

