/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.config;

import com.couchbase.client.core.config.AbstractBucketConfig;
import com.couchbase.client.core.config.BucketNodeLocator;
import com.couchbase.client.core.config.BucketType;
import com.couchbase.client.core.config.ConfigurationException;
import com.couchbase.client.core.config.CouchbaseBucketConfig;
import com.couchbase.client.core.config.CouchbasePartitionInfo;
import com.couchbase.client.core.config.NodeInfo;
import com.couchbase.client.core.config.Partition;
import com.couchbase.client.core.config.PortInfo;
import com.couchbase.client.deps.com.fasterxml.jackson.annotation.JsonCreator;
import com.couchbase.client.deps.com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.couchbase.client.deps.com.fasterxml.jackson.annotation.JsonProperty;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

@JsonIgnoreProperties(ignoreUnknown=true)
public class DefaultCouchbaseBucketConfig
extends AbstractBucketConfig
implements CouchbaseBucketConfig {
    private final CouchbasePartitionInfo partitionInfo;
    private final List<NodeInfo> partitionHosts;
    private final Set<InetAddress> nodesWithPrimaryPartitions;
    private final boolean tainted;
    private final long rev;

    @JsonCreator
    public DefaultCouchbaseBucketConfig(@JsonProperty(value="rev") long rev, @JsonProperty(value="name") String name, @JsonProperty(value="nodeLocator") String locator, @JsonProperty(value="uri") String uri, @JsonProperty(value="streamingUri") String streamingUri, @JsonProperty(value="vBucketServerMap") CouchbasePartitionInfo partitionInfo, @JsonProperty(value="nodes") List<NodeInfo> nodeInfos, @JsonProperty(value="nodesExt") List<PortInfo> portInfos) {
        super(name, BucketNodeLocator.fromConfig(locator), uri, streamingUri, nodeInfos, portInfos);
        this.partitionInfo = partitionInfo;
        this.tainted = partitionInfo.tainted();
        this.partitionHosts = DefaultCouchbaseBucketConfig.buildPartitionHosts(nodeInfos, partitionInfo);
        this.nodesWithPrimaryPartitions = DefaultCouchbaseBucketConfig.buildNodesWithPrimaryPartitions(nodeInfos, partitionInfo.partitions());
        this.rev = rev;
    }

    private static Set<InetAddress> buildNodesWithPrimaryPartitions(List<NodeInfo> nodeInfos, List<Partition> partitions) {
        HashSet<InetAddress> nodes = new HashSet<InetAddress>(nodeInfos.size());
        for (Partition partition : partitions) {
            short index = partition.master();
            if (index < 0) continue;
            nodes.add(nodeInfos.get(index).hostname());
        }
        return nodes;
    }

    private static List<NodeInfo> buildPartitionHosts(List<NodeInfo> nodeInfos, CouchbasePartitionInfo partitionInfo) {
        ArrayList<NodeInfo> partitionHosts = new ArrayList<NodeInfo>();
        for (String rawHost : partitionInfo.partitionHosts()) {
            InetAddress convertedHost;
            try {
                convertedHost = InetAddress.getByName(rawHost);
            }
            catch (UnknownHostException e) {
                throw new ConfigurationException("Could not resolve " + rawHost + "on config building.");
            }
            for (NodeInfo nodeInfo : nodeInfos) {
                if (!nodeInfo.hostname().equals(convertedHost)) continue;
                partitionHosts.add(nodeInfo);
            }
        }
        if (partitionHosts.size() != partitionInfo.partitionHosts().length) {
            throw new ConfigurationException("Partition size is not equal after conversion, this is a bug.");
        }
        return partitionHosts;
    }

    @Override
    public int numberOfReplicas() {
        return this.partitionInfo.numberOfReplicas();
    }

    @Override
    public boolean tainted() {
        return this.tainted;
    }

    @Override
    public boolean hasPrimaryPartitionsOnNode(InetAddress hostname) {
        return this.nodesWithPrimaryPartitions.contains(hostname);
    }

    @Override
    public short nodeIndexForMaster(int partition) {
        return this.partitionInfo.partitions().get(partition).master();
    }

    @Override
    public short nodeIndexForReplica(int partition, int replica) {
        return this.partitionInfo.partitions().get(partition).replica(replica);
    }

    @Override
    public int numberOfPartitions() {
        return this.partitionInfo.partitions().size();
    }

    @Override
    public NodeInfo nodeAtIndex(int nodeIndex) {
        return this.partitionHosts.get(nodeIndex);
    }

    @Override
    public long rev() {
        return this.rev;
    }

    @Override
    public BucketType type() {
        return BucketType.COUCHBASE;
    }

    public String toString() {
        return "DefaultCouchbaseBucketConfig{name='" + this.name() + '\'' + ", locator=" + (Object)((Object)this.locator()) + ", uri='" + this.uri() + '\'' + ", streamingUri='" + this.streamingUri() + '\'' + ", nodeInfo=" + this.nodes() + ", partitionInfo=" + this.partitionInfo + ", tainted=" + this.tainted + ", rev=" + this.rev + '}';
    }
}

