/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.state;

import com.couchbase.client.core.logging.CouchbaseLogger;
import com.couchbase.client.core.logging.CouchbaseLoggerFactory;
import com.couchbase.client.core.state.Stateful;
import rx.Observable;
import rx.subjects.BehaviorSubject;

public class AbstractStateMachine<S extends Enum>
implements Stateful<S> {
    private static final CouchbaseLogger LOGGER = CouchbaseLoggerFactory.getInstance(Stateful.class);
    private final BehaviorSubject<S> observable;
    private volatile S currentState;

    protected AbstractStateMachine(S initialState) {
        this.currentState = initialState;
        this.observable = BehaviorSubject.create(this.currentState);
    }

    @Override
    public final Observable<S> states() {
        return this.observable;
    }

    @Override
    public final S state() {
        return this.currentState;
    }

    @Override
    public final boolean isState(S state) {
        return this.currentState == state;
    }

    @Override
    public boolean hasSubscribers() {
        return this.observable.hasObservers();
    }

    protected void transitionState(S newState) {
        if (newState != this.currentState) {
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace("State (" + this.getClass().getSimpleName() + ") " + this.currentState + " -> " + newState);
            }
            this.currentState = newState;
            this.observable.onNext(newState);
        }
    }
}

