/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.message.observe;

import com.couchbase.client.core.ClusterFacade;
import com.couchbase.client.core.DocumentConcurrentlyModifiedException;
import com.couchbase.client.core.ReplicaNotConfiguredException;
import com.couchbase.client.core.annotations.InterfaceAudience;
import com.couchbase.client.core.annotations.InterfaceStability;
import com.couchbase.client.core.config.CouchbaseBucketConfig;
import com.couchbase.client.core.message.cluster.GetClusterConfigRequest;
import com.couchbase.client.core.message.cluster.GetClusterConfigResponse;
import com.couchbase.client.core.message.kv.ObserveRequest;
import com.couchbase.client.core.message.kv.ObserveResponse;
import com.couchbase.client.core.retry.RetryStrategy;
import com.couchbase.client.core.time.Delay;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import rx.Observable;
import rx.functions.Func0;
import rx.functions.Func1;
import rx.functions.Func2;

@InterfaceStability.Uncommitted
@InterfaceAudience.Private
public class Observe {
    private static final Delay DEFAULT_DELAY = Delay.fixed(10L, TimeUnit.MILLISECONDS);

    public static Observable<Boolean> call(ClusterFacade core, String bucket, String id, long cas, boolean remove, PersistTo persistTo, ReplicateTo replicateTo, RetryStrategy retryStrategy) {
        return Observe.call(core, bucket, id, cas, remove, persistTo, replicateTo, DEFAULT_DELAY, retryStrategy);
    }

    public static Observable<Boolean> call(ClusterFacade core, String bucket, final String id, final long cas, final boolean remove, final PersistTo persistTo, final ReplicateTo replicateTo, final Delay delay, RetryStrategy retryStrategy) {
        ObserveResponse.ObserveStatus replicaIdentifier;
        ObserveResponse.ObserveStatus persistIdentifier;
        if (remove) {
            persistIdentifier = ObserveResponse.ObserveStatus.NOT_FOUND_PERSISTED;
            replicaIdentifier = ObserveResponse.ObserveStatus.NOT_FOUND_NOT_PERSISTED;
        } else {
            persistIdentifier = ObserveResponse.ObserveStatus.FOUND_PERSISTED;
            replicaIdentifier = ObserveResponse.ObserveStatus.FOUND_NOT_PERSISTED;
        }
        Observable<ObserveResponse> observeResponses = Observe.sendObserveRequests(core, bucket, id, cas, persistTo, replicateTo, retryStrategy);
        return observeResponses.toList().repeatWhen(new Func1<Observable<? extends Void>, Observable<?>>(){

            public Observable<?> call(Observable<? extends Void> observable) {
                return observable.zipWith(Observable.range((int)1, (int)Integer.MAX_VALUE), (Func2)new Func2<Void, Integer, Integer>(){

                    public Integer call(Void aVoid, Integer attempt) {
                        return attempt;
                    }
                }).flatMap(new Func1<Integer, Observable<?>>(){

                    public Observable<?> call(Integer attempt) {
                        return Observable.timer((long)delay.calculate(attempt.intValue()), (TimeUnit)delay.unit());
                    }
                });
            }
        }).skipWhile((Func1)new Func1<List<ObserveResponse>, Boolean>(){

            public Boolean call(List<ObserveResponse> observeResponses) {
                int replicated = 0;
                int persisted = 0;
                boolean persistedMaster = false;
                for (ObserveResponse response : observeResponses) {
                    boolean validCas;
                    if (response.content() != null && response.content().refCnt() > 0) {
                        response.content().release();
                    }
                    ObserveResponse.ObserveStatus status = response.observeStatus();
                    boolean bl = validCas = cas == response.cas() || remove && response.cas() == 0L && status == persistIdentifier;
                    if (response.master()) {
                        if (!validCas) {
                            throw new DocumentConcurrentlyModifiedException("The CAS on the active node changed for ID \"" + id + "\", indicating it has been modified in the " + "meantime.");
                        }
                        if (status != persistIdentifier) continue;
                        ++persisted;
                        persistedMaster = true;
                        continue;
                    }
                    if (!validCas) continue;
                    if (status == persistIdentifier) {
                        ++persisted;
                        ++replicated;
                        continue;
                    }
                    if (status != replicaIdentifier) continue;
                    ++replicated;
                }
                boolean persistDone = false;
                boolean replicateDone = false;
                if (persistTo == PersistTo.MASTER) {
                    if (persistedMaster) {
                        persistDone = true;
                    }
                } else if (persisted >= persistTo.value()) {
                    persistDone = true;
                }
                if (replicated >= replicateTo.value()) {
                    replicateDone = true;
                }
                return !persistDone || !replicateDone;
            }
        }).take(1).map((Func1)new Func1<List<ObserveResponse>, Boolean>(){

            public Boolean call(List<ObserveResponse> observeResponses) {
                return true;
            }
        });
    }

    private static Observable<ObserveResponse> sendObserveRequests(final ClusterFacade core, final String bucket, final String id, final long cas, final PersistTo persistTo, final ReplicateTo replicateTo, RetryStrategy retryStrategy) {
        final boolean swallowErrors = retryStrategy.shouldRetryObserve();
        return Observable.defer((Func0)new Func0<Observable<ObserveResponse>>(){

            public Observable<ObserveResponse> call() {
                return core.send(new GetClusterConfigRequest()).map((Func1)new Func1<GetClusterConfigResponse, Integer>(){

                    public Integer call(GetClusterConfigResponse response) {
                        CouchbaseBucketConfig conf = (CouchbaseBucketConfig)response.config().bucketConfig(bucket);
                        int numReplicas = conf.numberOfReplicas();
                        if (replicateTo.touchesReplica() && replicateTo.value() > numReplicas) {
                            throw new ReplicaNotConfiguredException("Not enough replicas configured on the bucket.");
                        }
                        if (persistTo.touchesReplica() && persistTo.value() - 1 > numReplicas) {
                            throw new ReplicaNotConfiguredException("Not enough replicas configured on the bucket.");
                        }
                        return numReplicas;
                    }
                }).flatMap((Func1)new Func1<Integer, Observable<ObserveResponse>>(){

                    public Observable<ObserveResponse> call(Integer replicas) {
                        ArrayList<Object> obs = new ArrayList<Object>();
                        Observable masterRes = core.send(new ObserveRequest(id, cas, true, 0, bucket));
                        if (swallowErrors) {
                            obs.add(masterRes.onErrorResumeNext(Observable.empty()));
                        } else {
                            obs.add(masterRes);
                        }
                        if (persistTo.touchesReplica() || replicateTo.touchesReplica()) {
                            for (short i = 1; i <= replicas; i = (short)(i + 1)) {
                                Observable res = core.send(new ObserveRequest(id, cas, false, i, bucket));
                                if (swallowErrors) {
                                    obs.add(res.onErrorResumeNext(Observable.empty()));
                                    continue;
                                }
                                obs.add(res);
                            }
                        }
                        return Observable.merge(obs);
                    }
                });
            }
        });
    }

    public static enum ReplicateTo {
        NONE(0),
        ONE(1),
        TWO(2),
        THREE(3);

        private final short value;

        private ReplicateTo(short value) {
            this.value = value;
        }

        public short value() {
            return this.value;
        }

        public boolean touchesReplica() {
            return this.value > 0;
        }
    }

    public static enum PersistTo {
        MASTER(-1),
        NONE(0),
        ONE(1),
        TWO(2),
        THREE(3),
        FOUR(4);

        private final short value;

        private PersistTo(short value) {
            this.value = value;
        }

        public short value() {
            return this.value;
        }

        public boolean touchesReplica() {
            return this.value > 0;
        }
    }
}

