/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.endpoint;

import com.couchbase.client.core.logging.CouchbaseLogger;
import com.couchbase.client.core.logging.CouchbaseLoggerFactory;
import com.couchbase.client.core.message.ResponseStatus;

public class ResponseStatusConverter {
    private static final CouchbaseLogger LOGGER = CouchbaseLoggerFactory.getInstance(ResponseStatusConverter.class);
    public static final int HTTP_OK = 200;
    public static final int HTTP_CREATED = 201;
    public static final int HTTP_ACCEPTED = 202;
    public static final int HTTP_NOT_FOUND = 404;
    public static final short BINARY_SUCCESS = 0;
    public static final short BINARY_ERR_NOT_FOUND = 1;
    public static final short BINARY_ERR_EXISTS = 2;
    public static final short BINARY_ERR_2BIG = 3;
    public static final short BINARY_ERR_INVAL = 4;
    public static final short BINARY_ERR_NOT_STORED = 5;
    public static final short BINARY_ERR_DELTA_BADVAL = 6;
    public static final short BINARY_ERR_NOT_MY_VBUCKET = 7;
    public static final short BINARY_ERR_UNKNOWN_COMMAND = 129;
    public static final short BINARY_ERR_NO_MEM = 130;
    public static final short BINARY_ERR_NOT_SUPPORTED = 131;
    public static final short BINARY_ERR_INTERNAL = 132;
    public static final short BINARY_ERR_BUSY = 133;
    public static final short BINARY_ERR_TEMP_FAIL = 134;

    public static ResponseStatus fromBinary(short status) {
        switch (status) {
            case 0: {
                return ResponseStatus.SUCCESS;
            }
            case 2: {
                return ResponseStatus.EXISTS;
            }
            case 1: {
                return ResponseStatus.NOT_EXISTS;
            }
            case 7: {
                return ResponseStatus.RETRY;
            }
            case 5: {
                return ResponseStatus.NOT_STORED;
            }
            case 3: {
                return ResponseStatus.TOO_BIG;
            }
            case 134: {
                return ResponseStatus.TEMPORARY_FAILURE;
            }
            case 133: {
                return ResponseStatus.SERVER_BUSY;
            }
            case 130: {
                return ResponseStatus.OUT_OF_MEMORY;
            }
            case 129: {
                return ResponseStatus.COMMAND_UNAVAILABLE;
            }
            case 131: {
                return ResponseStatus.COMMAND_UNAVAILABLE;
            }
            case 132: {
                return ResponseStatus.INTERNAL_ERROR;
            }
            case 4: {
                return ResponseStatus.INVALID_ARGUMENTS;
            }
            case 6: {
                return ResponseStatus.INVALID_ARGUMENTS;
            }
        }
        LOGGER.warn("Unknown ResponseStatus with Protocol KeyValue: {}", (Object)Integer.toHexString(status));
        return ResponseStatus.FAILURE;
    }

    public static ResponseStatus fromHttp(int code) {
        ResponseStatus status;
        switch (code) {
            case 200: 
            case 201: 
            case 202: {
                status = ResponseStatus.SUCCESS;
                break;
            }
            case 404: {
                status = ResponseStatus.NOT_EXISTS;
                break;
            }
            default: {
                LOGGER.warn("Unknown ResponseStatus with Protocol HTTP: {}", (Object)code);
                status = ResponseStatus.FAILURE;
            }
        }
        return status;
    }
}

