/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.env;

import com.couchbase.client.core.ClusterFacade;
import com.couchbase.client.core.env.CoreEnvironment;
import com.couchbase.client.core.env.CoreScheduler;
import com.couchbase.client.core.event.DefaultEventBus;
import com.couchbase.client.core.event.EventBus;
import com.couchbase.client.core.logging.CouchbaseLogger;
import com.couchbase.client.core.logging.CouchbaseLoggerFactory;
import com.couchbase.client.core.retry.BestEffortRetryStrategy;
import com.couchbase.client.core.retry.RetryStrategy;
import com.couchbase.client.core.time.Delay;
import com.couchbase.client.deps.io.netty.channel.EventLoopGroup;
import com.couchbase.client.deps.io.netty.channel.nio.NioEventLoopGroup;
import com.couchbase.client.deps.io.netty.util.concurrent.DefaultThreadFactory;
import com.couchbase.client.deps.io.netty.util.concurrent.Future;
import com.couchbase.client.deps.io.netty.util.concurrent.GenericFutureListener;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import rx.Observable;
import rx.Scheduler;
import rx.Subscriber;

public class DefaultCoreEnvironment
implements CoreEnvironment {
    private static final CouchbaseLogger LOGGER = CouchbaseLoggerFactory.getInstance(CoreEnvironment.class);
    public static final boolean DCP_ENABLED = false;
    public static final boolean SSL_ENABLED = false;
    public static final String SSL_KEYSTORE_FILE = null;
    public static final String SSL_KEYSTORE_PASSWORD = null;
    public static final boolean QUERY_ENABLED = false;
    public static final int QUERY_PORT = 8093;
    public static final boolean BOOTSTRAP_HTTP_ENABLED = true;
    public static final boolean BOOTSTRAP_CARRIER_ENABLED = true;
    public static final int BOOTSTRAP_HTTP_DIRECT_PORT = 8091;
    public static final int BOOTSTRAP_HTTP_SSL_PORT = 18091;
    public static final int BOOTSTRAP_CARRIER_DIRECT_PORT = 11210;
    public static final int BOOTSTRAP_CARRIER_SSL_PORT = 11207;
    public static final int REQUEST_BUFFER_SIZE = 16384;
    public static final int RESPONSE_BUFFER_SIZE = 16384;
    public static final int IO_POOL_SIZE = Runtime.getRuntime().availableProcessors();
    public static final int COMPUTATION_POOL_SIZE = Runtime.getRuntime().availableProcessors();
    public static final int KEYVALUE_ENDPOINTS = 1;
    public static final int VIEW_ENDPOINTS = 1;
    public static final int QUERY_ENDPOINTS = 1;
    public static final Delay OBSERVE_INTERVAL_DELAY = Delay.exponential(TimeUnit.MICROSECONDS, 100000L, 10L);
    public static final Delay RECONNECT_DELAY = Delay.exponential(TimeUnit.MILLISECONDS, 4096L, 32L);
    public static final Delay RETRY_DELAY = Delay.exponential(TimeUnit.MICROSECONDS, 100000L, 100L);
    public static final RetryStrategy RETRY_STRATEGY = BestEffortRetryStrategy.INSTANCE;
    public static final long MAX_REQUEST_LIFETIME = TimeUnit.SECONDS.toMillis(75L);
    public static final long KEEPALIVEINTERVAL = TimeUnit.SECONDS.toMillis(30L);
    public static final long AUTORELEASE_AFTER = TimeUnit.SECONDS.toMillis(2L);
    public static final boolean BUFFER_POOLING_ENABLED = true;
    public static String PACKAGE_NAME_AND_VERSION;
    public static String USER_AGENT;
    private static final String NAMESPACE = "com.couchbase.";
    static final int MIN_POOL_SIZE = 3;
    private static final String VERSION_PROPERTIES = "com.couchbase.client.core.properties";
    private final boolean dcpEnabled;
    private final boolean sslEnabled;
    private final String sslKeystoreFile;
    private final String sslKeystorePassword;
    private final boolean queryEnabled;
    private final int queryPort;
    private final boolean bootstrapHttpEnabled;
    private final boolean bootstrapCarrierEnabled;
    private final int bootstrapHttpDirectPort;
    private final int bootstrapHttpSslPort;
    private final int bootstrapCarrierDirectPort;
    private final int bootstrapCarrierSslPort;
    private final int ioPoolSize;
    private final int computationPoolSize;
    private final int responseBufferSize;
    private final int requestBufferSize;
    private final int kvServiceEndpoints;
    private final int viewServiceEndpoints;
    private final int queryServiceEndpoints;
    private final Delay observeIntervalDelay;
    private final Delay reconnectDelay;
    private final Delay retryDelay;
    private final String userAgent;
    private final String packageNameAndVersion;
    private final RetryStrategy retryStrategy;
    private final long maxRequestLifetime;
    private final long keepAliveInterval;
    private final long autoreleaseAfter;
    private final boolean bufferPoolingEnabled;
    private static final int MAX_ALLOWED_INSTANCES = 1;
    private static volatile int instanceCounter;
    private final EventLoopGroup ioPool;
    private final Scheduler coreScheduler;
    private final EventBus eventBus;
    private volatile boolean shutdown;

    protected DefaultCoreEnvironment(Builder builder) {
        if (++instanceCounter > 1) {
            LOGGER.warn("More than 1 Couchbase Environments found (" + instanceCounter + "), this can have severe impact on performance and stability. Reuse environments!");
        }
        this.dcpEnabled = this.booleanPropertyOr("dcpEnabled", builder.dcpEnabled());
        this.sslEnabled = this.booleanPropertyOr("sslEnabled", builder.sslEnabled());
        this.sslKeystoreFile = this.stringPropertyOr("sslKeystoreFile", builder.sslKeystoreFile());
        this.sslKeystorePassword = this.stringPropertyOr("sslKeystorePassword", builder.sslKeystorePassword());
        this.queryEnabled = this.booleanPropertyOr("queryEnabled", builder.queryEnabled());
        this.queryPort = this.intPropertyOr("queryPort", builder.queryPort());
        this.bootstrapHttpEnabled = this.booleanPropertyOr("bootstrapHttpEnabled", builder.bootstrapHttpEnabled());
        this.bootstrapHttpDirectPort = this.intPropertyOr("bootstrapHttpDirectPort", builder.bootstrapHttpDirectPort());
        this.bootstrapHttpSslPort = this.intPropertyOr("bootstrapHttpSslPort", builder.bootstrapHttpSslPort());
        this.bootstrapCarrierEnabled = this.booleanPropertyOr("bootstrapCarrierEnabled", builder.bootstrapCarrierEnabled());
        this.bootstrapCarrierDirectPort = this.intPropertyOr("bootstrapCarrierDirectPort", builder.bootstrapCarrierDirectPort());
        this.bootstrapCarrierSslPort = this.intPropertyOr("bootstrapCarrierSslPort", builder.bootstrapCarrierSslPort());
        int ioPoolSize = this.intPropertyOr("ioPoolSize", builder.ioPoolSize());
        int computationPoolSize = this.intPropertyOr("computationPoolSize", builder.computationPoolSize());
        this.responseBufferSize = this.intPropertyOr("responseBufferSize", builder.responseBufferSize());
        this.requestBufferSize = this.intPropertyOr("requestBufferSize", builder.requestBufferSize());
        this.kvServiceEndpoints = this.intPropertyOr("kvEndpoints", builder.kvEndpoints());
        this.viewServiceEndpoints = this.intPropertyOr("viewEndpoints", builder.viewEndpoints());
        this.queryServiceEndpoints = this.intPropertyOr("queryEndpoints", builder.queryEndpoints());
        this.packageNameAndVersion = this.stringPropertyOr("packageNameAndVersion", builder.packageNameAndVersion());
        this.userAgent = this.stringPropertyOr("userAgent", builder.userAgent());
        this.observeIntervalDelay = builder.observeIntervalDelay();
        this.reconnectDelay = builder.reconnectDelay();
        this.retryDelay = builder.retryDelay();
        this.retryStrategy = builder.retryStrategy();
        this.maxRequestLifetime = DefaultCoreEnvironment.longPropertyOr("maxRequestLifetime", builder.maxRequestLifetime());
        this.keepAliveInterval = DefaultCoreEnvironment.longPropertyOr("keepAliveInterval", builder.keepAliveInterval());
        this.autoreleaseAfter = DefaultCoreEnvironment.longPropertyOr("autoreleaseAfter", builder.autoreleaseAfter());
        this.bufferPoolingEnabled = this.booleanPropertyOr("bufferPoolingEnabled", builder.bufferPoolingEnabled());
        if (ioPoolSize < 3) {
            LOGGER.info("ioPoolSize is less than {} ({}), setting to: {}", 3, ioPoolSize, 3);
            this.ioPoolSize = 3;
        } else {
            this.ioPoolSize = ioPoolSize;
        }
        if (computationPoolSize < 3) {
            LOGGER.info("computationPoolSize is less than {} ({}), setting to: {}", 3, computationPoolSize, 3);
            this.computationPoolSize = 3;
        } else {
            this.computationPoolSize = computationPoolSize;
        }
        this.ioPool = builder.ioPool() == null ? new NioEventLoopGroup(this.ioPoolSize(), new DefaultThreadFactory("cb-io", true)) : builder.ioPool();
        this.coreScheduler = builder.scheduler() == null ? new CoreScheduler(this.computationPoolSize()) : builder.scheduler();
        this.eventBus = builder.eventBus == null ? new DefaultEventBus(this.coreScheduler) : builder.eventBus();
        this.shutdown = false;
    }

    public static DefaultCoreEnvironment create() {
        return new DefaultCoreEnvironment(DefaultCoreEnvironment.builder());
    }

    public static Builder builder() {
        return new Builder();
    }

    protected boolean booleanPropertyOr(String path, boolean def) {
        String found = System.getProperty(NAMESPACE + path);
        if (found == null) {
            return def;
        }
        return Boolean.parseBoolean(found);
    }

    protected String stringPropertyOr(String path, String def) {
        String found = System.getProperty(NAMESPACE + path);
        return found == null ? def : found;
    }

    protected int intPropertyOr(String path, int def) {
        String found = System.getProperty(NAMESPACE + path);
        if (found == null) {
            return def;
        }
        return Integer.parseInt(found);
    }

    protected static long longPropertyOr(String path, long def) {
        String found = System.getProperty(NAMESPACE + path);
        if (found == null) {
            return def;
        }
        return Integer.parseInt(found);
    }

    @Override
    public EventLoopGroup ioPool() {
        return this.ioPool;
    }

    @Override
    public Observable<Boolean> shutdown() {
        if (this.shutdown) {
            return Observable.just((Object)true);
        }
        return Observable.create((Observable.OnSubscribe)new Observable.OnSubscribe<Boolean>(){

            public void call(final Subscriber<? super Boolean> subscriber) {
                if (DefaultCoreEnvironment.this.shutdown) {
                    subscriber.onNext((Object)true);
                    subscriber.onCompleted();
                }
                DefaultCoreEnvironment.this.ioPool.shutdownGracefully().addListener(new GenericFutureListener(){

                    public void operationComplete(Future future) throws Exception {
                        if (!subscriber.isUnsubscribed()) {
                            if (future.isSuccess()) {
                                subscriber.onNext((Object)future.isSuccess());
                                subscriber.onCompleted();
                            } else {
                                subscriber.onError(future.cause());
                            }
                        }
                    }
                });
            }
        });
    }

    @Override
    public Scheduler scheduler() {
        return this.coreScheduler;
    }

    @Override
    public boolean sslEnabled() {
        return this.sslEnabled;
    }

    @Override
    public boolean dcpEnabled() {
        return this.dcpEnabled;
    }

    @Override
    public String sslKeystoreFile() {
        return this.sslKeystoreFile;
    }

    @Override
    public String sslKeystorePassword() {
        return this.sslKeystorePassword;
    }

    @Override
    public boolean queryEnabled() {
        return this.queryEnabled;
    }

    @Override
    public int queryPort() {
        return this.queryPort;
    }

    @Override
    public boolean bootstrapHttpEnabled() {
        return this.bootstrapHttpEnabled;
    }

    @Override
    public boolean bootstrapCarrierEnabled() {
        return this.bootstrapCarrierEnabled;
    }

    @Override
    public int bootstrapHttpDirectPort() {
        return this.bootstrapHttpDirectPort;
    }

    @Override
    public int bootstrapHttpSslPort() {
        return this.bootstrapHttpSslPort;
    }

    @Override
    public int bootstrapCarrierDirectPort() {
        return this.bootstrapCarrierDirectPort;
    }

    @Override
    public int bootstrapCarrierSslPort() {
        return this.bootstrapCarrierSslPort;
    }

    @Override
    public int ioPoolSize() {
        return this.ioPoolSize;
    }

    @Override
    public int computationPoolSize() {
        return this.computationPoolSize;
    }

    @Override
    public int requestBufferSize() {
        return this.requestBufferSize;
    }

    @Override
    public int responseBufferSize() {
        return this.responseBufferSize;
    }

    @Override
    public int kvEndpoints() {
        return this.kvServiceEndpoints;
    }

    @Override
    public int viewEndpoints() {
        return this.viewServiceEndpoints;
    }

    @Override
    public int queryEndpoints() {
        return this.queryServiceEndpoints;
    }

    @Override
    public String userAgent() {
        return this.userAgent;
    }

    @Override
    public String packageNameAndVersion() {
        return this.packageNameAndVersion;
    }

    @Override
    public Delay observeIntervalDelay() {
        return this.observeIntervalDelay;
    }

    @Override
    public Delay reconnectDelay() {
        return this.reconnectDelay;
    }

    @Override
    public Delay retryDelay() {
        return this.retryDelay;
    }

    @Override
    public RetryStrategy retryStrategy() {
        return this.retryStrategy;
    }

    @Override
    public long maxRequestLifetime() {
        return this.maxRequestLifetime;
    }

    @Override
    public long keepAliveInterval() {
        return this.keepAliveInterval;
    }

    @Override
    public EventBus eventBus() {
        return this.eventBus;
    }

    @Override
    public long autoreleaseAfter() {
        return this.autoreleaseAfter;
    }

    @Override
    public boolean bufferPoolingEnabled() {
        return this.bufferPoolingEnabled;
    }

    protected StringBuilder dumpParameters(StringBuilder sb) {
        sb.append("sslEnabled=").append(this.sslEnabled);
        sb.append(", sslKeystoreFile='").append(this.sslKeystoreFile).append('\'');
        sb.append(", sslKeystorePassword='").append(this.sslKeystorePassword).append('\'');
        sb.append(", queryEnabled=").append(this.queryEnabled);
        sb.append(", queryPort=").append(this.queryPort);
        sb.append(", bootstrapHttpEnabled=").append(this.bootstrapHttpEnabled);
        sb.append(", bootstrapCarrierEnabled=").append(this.bootstrapCarrierEnabled);
        sb.append(", bootstrapHttpDirectPort=").append(this.bootstrapHttpDirectPort);
        sb.append(", bootstrapHttpSslPort=").append(this.bootstrapHttpSslPort);
        sb.append(", bootstrapCarrierDirectPort=").append(this.bootstrapCarrierDirectPort);
        sb.append(", bootstrapCarrierSslPort=").append(this.bootstrapCarrierSslPort);
        sb.append(", ioPoolSize=").append(this.ioPoolSize);
        sb.append(", computationPoolSize=").append(this.computationPoolSize);
        sb.append(", responseBufferSize=").append(this.responseBufferSize);
        sb.append(", requestBufferSize=").append(this.requestBufferSize);
        sb.append(", kvServiceEndpoints=").append(this.kvServiceEndpoints);
        sb.append(", viewServiceEndpoints=").append(this.viewServiceEndpoints);
        sb.append(", queryServiceEndpoints=").append(this.queryServiceEndpoints);
        sb.append(", ioPool=").append(this.ioPool.getClass().getSimpleName());
        sb.append(", coreScheduler=").append(this.coreScheduler.getClass().getSimpleName());
        sb.append(", eventBus=").append(this.eventBus.getClass().getSimpleName());
        sb.append(", packageNameAndVersion=").append(this.packageNameAndVersion);
        sb.append(", dcpEnabled=").append(this.dcpEnabled);
        sb.append(", retryStrategy=").append(this.retryStrategy);
        sb.append(", maxRequestLifetime=").append(this.maxRequestLifetime);
        sb.append(", retryDelay=").append(this.retryDelay);
        sb.append(", reconnectDelay=").append(this.reconnectDelay);
        sb.append(", observeIntervalDelay=").append(this.observeIntervalDelay);
        sb.append(", keepAliveInterval=").append(this.keepAliveInterval);
        sb.append(", autoreleaseAfter=").append(this.autoreleaseAfter);
        sb.append(", bufferPoolingEnabled=").append(this.bufferPoolingEnabled);
        return sb;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("CoreEnvironment: {");
        this.dumpParameters(sb).append('}');
        return sb.toString();
    }

    static {
        USER_AGENT = PACKAGE_NAME_AND_VERSION = "couchbase-jvm-core";
        try {
            Class<ClusterFacade> facadeClass = ClusterFacade.class;
            if (facadeClass == null) {
                throw new IllegalStateException("Could not locate ClusterFacade");
            }
            String version = null;
            String gitVersion = null;
            try {
                Properties versionProp = new Properties();
                versionProp.load(DefaultCoreEnvironment.class.getClassLoader().getResourceAsStream(VERSION_PROPERTIES));
                version = versionProp.getProperty("specificationVersion");
                gitVersion = versionProp.getProperty("implementationVersion");
            }
            catch (Exception e) {
                LOGGER.info("Could not retrieve version properties, defaulting.", e);
            }
            PACKAGE_NAME_AND_VERSION = String.format("couchbase-jvm-core/%s (git: %s)", version == null ? "unknown" : version, gitVersion == null ? "unknown" : gitVersion);
            USER_AGENT = String.format("%s (%s/%s %s; %s %s)", PACKAGE_NAME_AND_VERSION, System.getProperty("os.name"), System.getProperty("os.version"), System.getProperty("os.arch"), System.getProperty("java.vm.name"), System.getProperty("java.runtime.version"));
        }
        catch (Exception ex) {
            LOGGER.info("Could not set up user agent and packages, defaulting.", ex);
        }
        instanceCounter = 0;
    }

    public static class Builder
    implements CoreEnvironment {
        private boolean dcpEnabled = false;
        private boolean sslEnabled = false;
        private String sslKeystoreFile = SSL_KEYSTORE_FILE;
        private String sslKeystorePassword = SSL_KEYSTORE_PASSWORD;
        private String userAgent = USER_AGENT;
        private String packageNameAndVersion = PACKAGE_NAME_AND_VERSION;
        private boolean queryEnabled = false;
        private int queryPort = 8093;
        private boolean bootstrapHttpEnabled = true;
        private boolean bootstrapCarrierEnabled = true;
        private int bootstrapHttpDirectPort = 8091;
        private int bootstrapHttpSslPort = 18091;
        private int bootstrapCarrierDirectPort = 11210;
        private int bootstrapCarrierSslPort = 11207;
        private int ioPoolSize = IO_POOL_SIZE;
        private int computationPoolSize = COMPUTATION_POOL_SIZE;
        private int responseBufferSize = 16384;
        private int requestBufferSize = 16384;
        private int kvServiceEndpoints = 1;
        private int viewServiceEndpoints = 1;
        private int queryServiceEndpoints = 1;
        private Delay observeIntervalDelay = OBSERVE_INTERVAL_DELAY;
        private Delay reconnectDelay = RECONNECT_DELAY;
        private Delay retryDelay = RETRY_DELAY;
        private RetryStrategy retryStrategy = RETRY_STRATEGY;
        private EventLoopGroup ioPool;
        private Scheduler scheduler;
        private EventBus eventBus;
        private long maxRequestLifetime = MAX_REQUEST_LIFETIME;
        private long keepAliveInterval = KEEPALIVEINTERVAL;
        private long autoreleaseAfter = AUTORELEASE_AFTER;
        private boolean bufferPoolingEnabled = true;

        protected Builder() {
        }

        @Override
        public boolean dcpEnabled() {
            return this.dcpEnabled;
        }

        public Builder dcpEnabled(boolean dcpEnabled) {
            this.dcpEnabled = dcpEnabled;
            return this;
        }

        @Override
        public boolean sslEnabled() {
            return this.sslEnabled;
        }

        public Builder sslEnabled(boolean sslEnabled) {
            this.sslEnabled = sslEnabled;
            return this;
        }

        @Override
        public String sslKeystoreFile() {
            return this.sslKeystoreFile;
        }

        public Builder sslKeystoreFile(String sslKeystoreFile) {
            this.sslKeystoreFile = sslKeystoreFile;
            return this;
        }

        @Override
        public String sslKeystorePassword() {
            return this.sslKeystorePassword;
        }

        public Builder sslKeystorePassword(String sslKeystorePassword) {
            this.sslKeystorePassword = sslKeystorePassword;
            return this;
        }

        @Override
        public boolean queryEnabled() {
            return this.queryEnabled;
        }

        public Builder queryEnabled(boolean queryEnabled) {
            this.queryEnabled = queryEnabled;
            return this;
        }

        @Override
        public int queryPort() {
            return this.queryPort;
        }

        public Builder queryPort(int queryPort) {
            this.queryPort = queryPort;
            return this;
        }

        @Override
        public boolean bootstrapHttpEnabled() {
            return this.bootstrapHttpEnabled;
        }

        public Builder bootstrapHttpEnabled(boolean bootstrapHttpEnabled) {
            this.bootstrapHttpEnabled = bootstrapHttpEnabled;
            return this;
        }

        @Override
        public boolean bootstrapCarrierEnabled() {
            return this.bootstrapCarrierEnabled;
        }

        public Builder bootstrapCarrierEnabled(boolean bootstrapCarrierEnabled) {
            this.bootstrapCarrierEnabled = bootstrapCarrierEnabled;
            return this;
        }

        @Override
        public int bootstrapHttpDirectPort() {
            return this.bootstrapHttpDirectPort;
        }

        public Builder bootstrapHttpDirectPort(int bootstrapHttpDirectPort) {
            this.bootstrapHttpDirectPort = bootstrapHttpDirectPort;
            return this;
        }

        @Override
        public int bootstrapHttpSslPort() {
            return this.bootstrapHttpSslPort;
        }

        public Builder bootstrapHttpSslPort(int bootstrapHttpSslPort) {
            this.bootstrapHttpSslPort = bootstrapHttpSslPort;
            return this;
        }

        @Override
        public int bootstrapCarrierDirectPort() {
            return this.bootstrapCarrierDirectPort;
        }

        public Builder bootstrapCarrierDirectPort(int bootstrapCarrierDirectPort) {
            this.bootstrapCarrierDirectPort = bootstrapCarrierDirectPort;
            return this;
        }

        @Override
        public int bootstrapCarrierSslPort() {
            return this.bootstrapCarrierSslPort;
        }

        public Builder bootstrapCarrierSslPort(int bootstrapCarrierSslPort) {
            this.bootstrapCarrierSslPort = bootstrapCarrierSslPort;
            return this;
        }

        @Override
        public int ioPoolSize() {
            return this.ioPoolSize;
        }

        public Builder ioPoolSize(int ioPoolSize) {
            this.ioPoolSize = ioPoolSize;
            return this;
        }

        @Override
        public int computationPoolSize() {
            return this.computationPoolSize;
        }

        public Builder computationPoolSize(int computationPoolSize) {
            this.computationPoolSize = computationPoolSize;
            return this;
        }

        @Override
        public int requestBufferSize() {
            return this.requestBufferSize;
        }

        public Builder requestBufferSize(int requestBufferSize) {
            this.requestBufferSize = requestBufferSize;
            return this;
        }

        @Override
        public int responseBufferSize() {
            return this.responseBufferSize;
        }

        public Builder responseBufferSize(int responseBufferSize) {
            this.responseBufferSize = responseBufferSize;
            return this;
        }

        @Override
        public int kvEndpoints() {
            return this.kvServiceEndpoints;
        }

        public Builder kvEndpoints(int kvServiceEndpoints) {
            this.kvServiceEndpoints = kvServiceEndpoints;
            return this;
        }

        @Override
        public int viewEndpoints() {
            return this.viewServiceEndpoints;
        }

        public Builder viewEndpoints(int viewServiceEndpoints) {
            this.viewServiceEndpoints = viewServiceEndpoints;
            return this;
        }

        @Override
        public int queryEndpoints() {
            return this.queryServiceEndpoints;
        }

        public Builder queryEndpoints(int queryServiceEndpoints) {
            this.queryServiceEndpoints = queryServiceEndpoints;
            return this;
        }

        @Override
        public String userAgent() {
            return this.userAgent;
        }

        public Builder userAgent(String userAgent) {
            this.userAgent = userAgent;
            return this;
        }

        @Override
        public String packageNameAndVersion() {
            return this.packageNameAndVersion;
        }

        public Builder packageNameAndVersion(String packageNameAndVersion) {
            this.packageNameAndVersion = packageNameAndVersion;
            return this;
        }

        @Override
        public Delay observeIntervalDelay() {
            return this.observeIntervalDelay;
        }

        public Builder observeIntervalDelay(Delay observeIntervalDelay) {
            this.observeIntervalDelay = observeIntervalDelay;
            return this;
        }

        @Override
        public Delay reconnectDelay() {
            return this.reconnectDelay;
        }

        public Builder reconnectDelay(Delay reconnectDelay) {
            this.reconnectDelay = reconnectDelay;
            return this;
        }

        @Override
        public Delay retryDelay() {
            return this.retryDelay;
        }

        public Builder retryDelay(Delay retryDelay) {
            this.retryDelay = retryDelay;
            return this;
        }

        @Override
        public Observable<Boolean> shutdown() {
            throw new UnsupportedOperationException("Shutdown should not be called on the Builder.");
        }

        @Override
        public EventLoopGroup ioPool() {
            return this.ioPool;
        }

        public Builder ioPool(EventLoopGroup group) {
            this.ioPool = group;
            return this;
        }

        @Override
        public Scheduler scheduler() {
            return this.scheduler;
        }

        public Builder scheduler(Scheduler scheduler) {
            this.scheduler = scheduler;
            return this;
        }

        @Override
        public RetryStrategy retryStrategy() {
            return this.retryStrategy;
        }

        public Builder retryStrategy(RetryStrategy retryStrategy) {
            this.retryStrategy = retryStrategy;
            return this;
        }

        @Override
        public long maxRequestLifetime() {
            return this.maxRequestLifetime;
        }

        public Builder maxRequestLifetime(long maxRequestLifetime) {
            this.maxRequestLifetime = maxRequestLifetime;
            return this;
        }

        @Override
        public long keepAliveInterval() {
            return this.keepAliveInterval;
        }

        public Builder keepAliveInterval(long keepAliveIntervalMilliseconds) {
            this.keepAliveInterval = keepAliveIntervalMilliseconds;
            return this;
        }

        @Override
        public long autoreleaseAfter() {
            return this.autoreleaseAfter;
        }

        public Builder autoreleaseAfter(long autoreleaseAfter) {
            this.autoreleaseAfter = autoreleaseAfter;
            return this;
        }

        @Override
        public EventBus eventBus() {
            return this.eventBus;
        }

        public Builder eventBus(EventBus eventBus) {
            this.eventBus = eventBus;
            return this;
        }

        @Override
        public boolean bufferPoolingEnabled() {
            return this.bufferPoolingEnabled;
        }

        public Builder bufferPoolingEnabled(boolean bufferPoolingEnabled) {
            this.bufferPoolingEnabled = bufferPoolingEnabled;
            return this;
        }

        public DefaultCoreEnvironment build() {
            return new DefaultCoreEnvironment(this);
        }
    }
}

