/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.retry;

import com.couchbase.client.core.env.CoreEnvironment;
import com.couchbase.client.core.message.CouchbaseRequest;
import com.couchbase.client.core.retry.RetryStrategy;
import java.util.concurrent.TimeUnit;

public class BestEffortRetryStrategy
implements RetryStrategy {
    public static final BestEffortRetryStrategy INSTANCE = new BestEffortRetryStrategy();

    private BestEffortRetryStrategy() {
    }

    @Override
    public boolean shouldRetry(CouchbaseRequest request, CoreEnvironment env) {
        return TimeUnit.MILLISECONDS.toNanos(env.maxRequestLifetime()) > System.nanoTime() - request.creationTime();
    }

    public String toString() {
        return "BestEffort";
    }
}

