/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.endpoint.query;

import com.couchbase.client.core.ResponseEvent;
import com.couchbase.client.core.endpoint.AbstractEndpoint;
import com.couchbase.client.core.endpoint.AbstractGenericHandler;
import com.couchbase.client.core.endpoint.util.ClosingPositionBufProcessor;
import com.couchbase.client.core.logging.CouchbaseLogger;
import com.couchbase.client.core.logging.CouchbaseLoggerFactory;
import com.couchbase.client.core.message.AbstractCouchbaseRequest;
import com.couchbase.client.core.message.AbstractCouchbaseResponse;
import com.couchbase.client.core.message.CouchbaseRequest;
import com.couchbase.client.core.message.CouchbaseResponse;
import com.couchbase.client.core.message.ResponseStatus;
import com.couchbase.client.core.message.query.GenericQueryRequest;
import com.couchbase.client.core.message.query.GenericQueryResponse;
import com.couchbase.client.core.message.query.QueryRequest;
import com.couchbase.client.deps.com.lmax.disruptor.RingBuffer;
import com.couchbase.client.deps.io.netty.buffer.ByteBuf;
import com.couchbase.client.deps.io.netty.channel.ChannelHandlerContext;
import com.couchbase.client.deps.io.netty.handler.codec.http.DefaultFullHttpRequest;
import com.couchbase.client.deps.io.netty.handler.codec.http.HttpContent;
import com.couchbase.client.deps.io.netty.handler.codec.http.HttpMethod;
import com.couchbase.client.deps.io.netty.handler.codec.http.HttpObject;
import com.couchbase.client.deps.io.netty.handler.codec.http.HttpRequest;
import com.couchbase.client.deps.io.netty.handler.codec.http.HttpResponse;
import com.couchbase.client.deps.io.netty.handler.codec.http.HttpVersion;
import com.couchbase.client.deps.io.netty.handler.codec.http.LastHttpContent;
import java.util.Queue;
import rx.Observable;
import rx.Scheduler;
import rx.subjects.AsyncSubject;
import rx.subjects.ReplaySubject;

public class QueryHandler
extends AbstractGenericHandler<HttpObject, HttpRequest, QueryRequest> {
    private static final CouchbaseLogger LOGGER = CouchbaseLoggerFactory.getInstance(QueryHandler.class);
    private static final byte QUERY_STATE_INITIAL = 0;
    private static final byte QUERY_STATE_SIGNATURE = 1;
    private static final byte QUERY_STATE_ROWS = 2;
    private static final byte QUERY_STATE_ERROR = 3;
    private static final byte QUERY_STATE_WARNING = 4;
    private static final byte QUERY_STATE_STATUS = 5;
    private static final byte QUERY_STATE_INFO = 6;
    private static final byte QUERY_STATE_DONE = 7;
    private static final int MINIMUM_WINDOW_FOR_REQUESTID = 55;
    public static final int MINIMUM_WINDOW_FOR_CLIENTID_TOKEN = 27;
    private HttpResponse responseHeader;
    private ByteBuf responseContent;
    private ReplaySubject<ByteBuf> queryRowObservable;
    private ReplaySubject<ByteBuf> queryErrorObservable;
    private AsyncSubject<String> queryStatusObservable;
    private AsyncSubject<ByteBuf> queryInfoObservable;
    private byte queryParsingState = 0;

    public QueryHandler(AbstractEndpoint endpoint, RingBuffer<ResponseEvent> responseBuffer, boolean isTransient) {
        super(endpoint, responseBuffer, isTransient);
    }

    QueryHandler(AbstractEndpoint endpoint, RingBuffer<ResponseEvent> responseBuffer, Queue<QueryRequest> queue, boolean isTransient) {
        super(endpoint, responseBuffer, queue, isTransient);
    }

    @Override
    protected HttpRequest encodeRequest(ChannelHandlerContext ctx, QueryRequest msg) throws Exception {
        DefaultFullHttpRequest request;
        if (msg instanceof GenericQueryRequest) {
            GenericQueryRequest queryRequest = (GenericQueryRequest)msg;
            request = new DefaultFullHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.POST, "/query");
            request.headers().set("User-Agent", (Object)this.env().userAgent());
            if (queryRequest.isJsonFormat()) {
                request.headers().set("Content-Type", (Object)"application/json");
            }
            ByteBuf query = ctx.alloc().buffer(((GenericQueryRequest)msg).query().length());
            query.writeBytes(((GenericQueryRequest)msg).query().getBytes(CHARSET));
            request.headers().add("Content-Length", (Object)query.readableBytes());
            request.content().writeBytes(query);
            query.release();
        } else if (msg instanceof KeepAliveRequest) {
            request = new DefaultFullHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.HEAD, "/");
            request.headers().set("User-Agent", (Object)this.env().userAgent());
        } else {
            throw new IllegalArgumentException("Unknown incoming QueryRequest type " + msg.getClass());
        }
        return request;
    }

    @Override
    protected CouchbaseResponse decodeResponse(ChannelHandlerContext ctx, HttpObject msg) throws Exception {
        CouchbaseResponse response = null;
        if (msg instanceof HttpResponse) {
            this.responseHeader = (HttpResponse)msg;
            if (this.responseContent != null) {
                this.responseContent.clear();
            } else {
                this.responseContent = ctx.alloc().buffer();
            }
        }
        if (this.currentRequest() instanceof KeepAliveRequest) {
            response = new KeepAliveResponse(QueryHandler.statusFromCode(this.responseHeader.getStatus().code()), (CouchbaseRequest)this.currentRequest());
            this.responseContent.clear();
            this.responseContent.discardReadBytes();
            this.finishedDecoding();
        } else if (msg instanceof HttpContent) {
            this.responseContent.writeBytes(((HttpContent)msg).content());
            if (this.currentRequest() instanceof GenericQueryRequest) {
                if (this.queryRowObservable == null) {
                    response = this.handleGenericQueryResponse();
                }
                this.parseQueryResponse(msg instanceof LastHttpContent);
            }
        }
        return response;
    }

    private int bytesBeforeInResponse(char c) {
        return this.responseContent.bytesBefore((byte)c);
    }

    private boolean isEmptySection(int openBracketPos) {
        int nextColon = this.bytesBeforeInResponse(':');
        return nextColon > -1 && nextColon < openBracketPos;
    }

    private static int findSectionClosingPosition(ByteBuf buf, char openingChar, char closingChar) {
        return buf.forEachByte(new ClosingPositionBufProcessor(openingChar, closingChar));
    }

    private CouchbaseResponse handleGenericQueryResponse() {
        String clientId = "";
        if (this.responseContent.readableBytes() < 55) {
            return null;
        }
        this.responseContent.skipBytes(this.bytesBeforeInResponse(':'));
        this.responseContent.skipBytes(this.bytesBeforeInResponse('\"') + 1);
        int endOfId = this.bytesBeforeInResponse('\"');
        ByteBuf slice = this.responseContent.readSlice(endOfId);
        String requestId = slice.toString(CHARSET);
        if (this.responseContent.readableBytes() >= 27 && this.bytesBeforeInResponse(':') < 27) {
            this.responseContent.markReaderIndex();
            ByteBuf slice2 = this.responseContent.readSlice(this.bytesBeforeInResponse(':'));
            if (slice2.toString(CHARSET).contains("clientContextID")) {
                this.responseContent.skipBytes(this.bytesBeforeInResponse('\"') + 1);
                int clientIdSize = this.bytesBeforeInResponse('\"');
                if (clientIdSize < 0) {
                    return null;
                }
                clientId = this.responseContent.readSlice(clientIdSize).toString(CHARSET);
                this.responseContent.skipBytes(1);
                this.responseContent.skipBytes(this.bytesBeforeInResponse('\"'));
            } else {
                this.responseContent.resetReaderIndex();
            }
        }
        boolean success = true;
        if (this.responseContent.readableBytes() >= 20) {
            ByteBuf peekForErrors = this.responseContent.slice(this.responseContent.readerIndex(), 20);
            if (peekForErrors.toString(CHARSET).contains("errors")) {
                success = false;
            }
        } else {
            return null;
        }
        ResponseStatus status = QueryHandler.statusFromCode(this.responseHeader.getStatus().code());
        if (!success) {
            status = ResponseStatus.FAILURE;
        }
        Scheduler scheduler = this.env().scheduler();
        this.queryRowObservable = ReplaySubject.create();
        this.queryErrorObservable = ReplaySubject.create();
        this.queryStatusObservable = AsyncSubject.create();
        this.queryInfoObservable = AsyncSubject.create();
        return new GenericQueryResponse((Observable<ByteBuf>)this.queryErrorObservable.onBackpressureBuffer().observeOn(scheduler), (Observable<ByteBuf>)this.queryRowObservable.onBackpressureBuffer().observeOn(scheduler), (Observable<String>)this.queryStatusObservable.onBackpressureBuffer().observeOn(scheduler), (Observable<ByteBuf>)this.queryInfoObservable.onBackpressureBuffer().observeOn(scheduler), (CouchbaseRequest)this.currentRequest(), status, requestId, clientId);
    }

    private void parseQueryResponse(boolean lastChunk) {
        if (this.queryParsingState == 0) {
            this.queryParsingState = this.transitionToNextToken();
        }
        if (this.queryParsingState == 1) {
            this.skipQuerySignature();
        }
        if (this.queryParsingState == 2) {
            this.parseQueryRows();
        }
        if (this.queryParsingState == 3) {
            this.parseQueryError();
        }
        if (this.queryParsingState == 4) {
            this.parseQueryError();
        }
        if (this.queryParsingState == 5) {
            this.parseQueryStatus();
        }
        if (this.queryParsingState == 6) {
            this.parseQueryInfo(lastChunk);
        }
        if (this.queryParsingState == 7) {
            this.cleanupQueryStates();
        }
    }

    private byte transitionToNextToken() {
        int endNextToken = this.bytesBeforeInResponse(':');
        ByteBuf peekSlice = this.responseContent.readSlice(endNextToken + 1);
        String peek = peekSlice.toString(CHARSET);
        if (peek.contains("\"signature\":")) {
            return 1;
        }
        if (peek.endsWith("\"results\":")) {
            return 2;
        }
        if (peek.endsWith("\"status\":")) {
            return 5;
        }
        if (peek.endsWith("\"errors\":")) {
            return 3;
        }
        if (peek.endsWith("\"warnings\":")) {
            return 4;
        }
        if (peek.endsWith("\"metrics\":")) {
            return 6;
        }
        IllegalStateException e = new IllegalStateException("Error parsing query response (in TRANSITION) at " + peek);
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace(this.responseContent.toString(CHARSET), e);
        }
        throw e;
    }

    private void skipQuerySignature() {
        int closePos;
        int openPos = this.bytesBeforeInResponse('{');
        if (!this.isEmptySection(openPos) && (closePos = QueryHandler.findSectionClosingPosition(this.responseContent, '{', '}')) > 0) {
            int length = closePos - openPos - this.responseContent.readerIndex() + 1;
            this.responseContent.skipBytes(openPos);
            ByteBuf signature = this.responseContent.readSlice(length);
        }
        this.queryParsingState = this.transitionToNextToken();
    }

    private void parseQueryRows() {
        while (true) {
            int openBracketPos;
            if (this.isEmptySection(openBracketPos = this.bytesBeforeInResponse('{'))) {
                this.queryParsingState = this.transitionToNextToken();
                break;
            }
            int closeBracketPos = QueryHandler.findSectionClosingPosition(this.responseContent, '{', '}');
            if (closeBracketPos == -1) break;
            int length = closeBracketPos - openBracketPos - this.responseContent.readerIndex() + 1;
            this.responseContent.skipBytes(openBracketPos);
            ByteBuf resultSlice = this.responseContent.readSlice(length);
            this.queryRowObservable.onNext((Object)resultSlice.copy());
        }
        this.responseContent.discardReadBytes();
    }

    private void parseQueryError() {
        while (true) {
            int openBracketPos;
            if (this.isEmptySection(openBracketPos = this.bytesBeforeInResponse('{'))) {
                this.queryParsingState = this.transitionToNextToken();
                break;
            }
            int closeBracketPos = QueryHandler.findSectionClosingPosition(this.responseContent, '{', '}');
            if (closeBracketPos == -1) break;
            int length = closeBracketPos - openBracketPos - this.responseContent.readerIndex() + 1;
            this.responseContent.skipBytes(openBracketPos);
            ByteBuf resultSlice = this.responseContent.readSlice(length);
            this.queryErrorObservable.onNext((Object)resultSlice.copy());
        }
        this.responseContent.discardReadBytes();
    }

    private void parseQueryStatus() {
        this.queryRowObservable.onCompleted();
        this.queryErrorObservable.onCompleted();
        this.responseContent.skipBytes(this.bytesBeforeInResponse('\"') + 1);
        ByteBuf resultSlice = this.responseContent.readSlice(this.bytesBeforeInResponse('\"'));
        this.queryStatusObservable.onNext((Object)resultSlice.toString(CHARSET));
        this.queryStatusObservable.onCompleted();
        this.queryParsingState = this.transitionToNextToken();
    }

    private void parseQueryInfo(boolean last) {
        if (!last) {
            return;
        }
        int initColon = this.bytesBeforeInResponse(':');
        this.responseContent.readerIndex(initColon);
        while (true) {
            int openBracketPos = this.bytesBeforeInResponse('{');
            int closeBracketPos = QueryHandler.findSectionClosingPosition(this.responseContent, '{', '}');
            if (closeBracketPos == -1) break;
            int from = this.responseContent.readerIndex() + openBracketPos;
            int to = closeBracketPos - openBracketPos - this.responseContent.readerIndex() + 1;
            this.queryInfoObservable.onNext((Object)this.responseContent.slice(from, to).copy());
            this.responseContent.readerIndex(to + openBracketPos);
        }
        this.queryInfoObservable.onCompleted();
        this.queryParsingState = (byte)7;
    }

    private void cleanupQueryStates() {
        this.finishedDecoding();
        this.queryInfoObservable = null;
        this.queryRowObservable = null;
        this.queryErrorObservable = null;
        this.queryStatusObservable = null;
        this.queryParsingState = 0;
    }

    private static ResponseStatus statusFromCode(int code) {
        ResponseStatus status;
        switch (code) {
            case 200: 
            case 201: {
                status = ResponseStatus.SUCCESS;
                break;
            }
            case 404: {
                status = ResponseStatus.NOT_EXISTS;
                break;
            }
            default: {
                status = ResponseStatus.FAILURE;
            }
        }
        return status;
    }

    @Override
    public void handlerRemoved(ChannelHandlerContext ctx) throws Exception {
        if (this.queryRowObservable != null) {
            this.queryRowObservable.onCompleted();
        }
        if (this.queryInfoObservable != null) {
            this.queryInfoObservable.onCompleted();
        }
        if (this.queryErrorObservable != null) {
            this.queryErrorObservable.onCompleted();
        }
        if (this.queryStatusObservable != null) {
            this.queryStatusObservable.onCompleted();
        }
        this.cleanupQueryStates();
        if (this.responseContent != null && this.responseContent.refCnt() > 0) {
            this.responseContent.release();
        }
        super.handlerRemoved(ctx);
    }

    @Override
    protected CouchbaseRequest createKeepAliveRequest() {
        return new KeepAliveRequest();
    }

    protected static class KeepAliveResponse
    extends AbstractCouchbaseResponse {
        protected KeepAliveResponse(ResponseStatus status, CouchbaseRequest request) {
            super(status, request);
        }
    }

    protected static class KeepAliveRequest
    extends AbstractCouchbaseRequest
    implements QueryRequest {
        protected KeepAliveRequest() {
            super(null, null);
        }
    }
}

