/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.endpoint.kv;

import com.couchbase.client.core.ResponseEvent;
import com.couchbase.client.core.endpoint.AbstractEndpoint;
import com.couchbase.client.core.endpoint.AbstractGenericHandler;
import com.couchbase.client.core.message.CouchbaseRequest;
import com.couchbase.client.core.message.CouchbaseResponse;
import com.couchbase.client.core.message.ResponseStatus;
import com.couchbase.client.core.message.kv.AbstractKeyValueRequest;
import com.couchbase.client.core.message.kv.AbstractKeyValueResponse;
import com.couchbase.client.core.message.kv.AppendRequest;
import com.couchbase.client.core.message.kv.AppendResponse;
import com.couchbase.client.core.message.kv.BinaryRequest;
import com.couchbase.client.core.message.kv.BinaryStoreRequest;
import com.couchbase.client.core.message.kv.CounterRequest;
import com.couchbase.client.core.message.kv.CounterResponse;
import com.couchbase.client.core.message.kv.GetBucketConfigRequest;
import com.couchbase.client.core.message.kv.GetBucketConfigResponse;
import com.couchbase.client.core.message.kv.GetRequest;
import com.couchbase.client.core.message.kv.GetResponse;
import com.couchbase.client.core.message.kv.InsertRequest;
import com.couchbase.client.core.message.kv.InsertResponse;
import com.couchbase.client.core.message.kv.ObserveRequest;
import com.couchbase.client.core.message.kv.ObserveResponse;
import com.couchbase.client.core.message.kv.PrependRequest;
import com.couchbase.client.core.message.kv.PrependResponse;
import com.couchbase.client.core.message.kv.RemoveRequest;
import com.couchbase.client.core.message.kv.RemoveResponse;
import com.couchbase.client.core.message.kv.ReplaceRequest;
import com.couchbase.client.core.message.kv.ReplaceResponse;
import com.couchbase.client.core.message.kv.ReplicaGetRequest;
import com.couchbase.client.core.message.kv.TouchRequest;
import com.couchbase.client.core.message.kv.TouchResponse;
import com.couchbase.client.core.message.kv.UnlockRequest;
import com.couchbase.client.core.message.kv.UnlockResponse;
import com.couchbase.client.core.message.kv.UpsertRequest;
import com.couchbase.client.core.message.kv.UpsertResponse;
import com.couchbase.client.deps.com.lmax.disruptor.EventSink;
import com.couchbase.client.deps.io.netty.buffer.ByteBuf;
import com.couchbase.client.deps.io.netty.buffer.Unpooled;
import com.couchbase.client.deps.io.netty.channel.ChannelHandlerContext;
import com.couchbase.client.deps.io.netty.handler.codec.memcache.binary.BinaryMemcacheRequest;
import com.couchbase.client.deps.io.netty.handler.codec.memcache.binary.DefaultBinaryMemcacheRequest;
import com.couchbase.client.deps.io.netty.handler.codec.memcache.binary.DefaultFullBinaryMemcacheRequest;
import com.couchbase.client.deps.io.netty.handler.codec.memcache.binary.FullBinaryMemcacheRequest;
import com.couchbase.client.deps.io.netty.handler.codec.memcache.binary.FullBinaryMemcacheResponse;
import java.util.Queue;

public class KeyValueHandler
extends AbstractGenericHandler<FullBinaryMemcacheResponse, BinaryMemcacheRequest, BinaryRequest> {
    public static final byte OP_GET_BUCKET_CONFIG = -75;
    public static final byte OP_GET = 0;
    public static final byte OP_GET_AND_LOCK = -108;
    public static final byte OP_GET_AND_TOUCH = 29;
    public static final byte OP_GET_REPLICA = -125;
    public static final byte OP_INSERT = 2;
    public static final byte OP_UPSERT = 1;
    public static final byte OP_REPLACE = 3;
    public static final byte OP_REMOVE = 4;
    public static final byte OP_COUNTER_INCR = 5;
    public static final byte OP_COUNTER_DECR = 6;
    public static final byte OP_UNLOCK = -107;
    public static final byte OP_OBSERVE = -110;
    public static final byte OP_TOUCH = 28;
    public static final byte OP_APPEND = 14;
    public static final byte OP_PREPEND = 15;
    public static final byte OP_NOOP = 10;
    public static final byte SUCCESS = 0;
    public static final byte ERR_NOT_FOUND = 1;
    public static final byte ERR_EXISTS = 2;
    public static final byte ERR_2BIG = 3;
    public static final byte ERR_INVAL = 4;
    public static final byte ERR_NOT_STORED = 5;
    public static final byte ERR_DELTA_BADVAL = 6;
    public static final byte ERR_NOT_MY_VBUCKET = 7;
    public static final byte ERR_UNKNOWN_COMMAND = -127;
    public static final byte ERR_NO_MEM = -126;
    public static final byte ERR_NOT_SUPPORTED = -125;
    public static final byte ERR_INTERNAL = -124;
    public static final byte ERR_BUSY = -123;
    public static final byte ERR_TEMP_FAIL = -122;

    public KeyValueHandler(AbstractEndpoint endpoint, EventSink<ResponseEvent> responseBuffer, boolean isTransient) {
        super(endpoint, responseBuffer, isTransient);
    }

    KeyValueHandler(AbstractEndpoint endpoint, EventSink<ResponseEvent> responseBuffer, Queue<BinaryRequest> queue, boolean isTransient) {
        super(endpoint, responseBuffer, queue, isTransient);
    }

    @Override
    protected BinaryMemcacheRequest encodeRequest(ChannelHandlerContext ctx, BinaryRequest msg) throws Exception {
        BinaryMemcacheRequest request;
        if (msg instanceof GetRequest) {
            request = KeyValueHandler.handleGetRequest(ctx, (GetRequest)msg);
        } else if (msg instanceof BinaryStoreRequest) {
            request = KeyValueHandler.handleStoreRequest(ctx, (BinaryStoreRequest)msg);
        } else if (msg instanceof ReplicaGetRequest) {
            request = KeyValueHandler.handleReplicaGetRequest((ReplicaGetRequest)msg);
        } else if (msg instanceof RemoveRequest) {
            request = KeyValueHandler.handleRemoveRequest((RemoveRequest)msg);
        } else if (msg instanceof CounterRequest) {
            request = KeyValueHandler.handleCounterRequest(ctx, (CounterRequest)msg);
        } else if (msg instanceof TouchRequest) {
            request = KeyValueHandler.handleTouchRequest(ctx, (TouchRequest)msg);
        } else if (msg instanceof UnlockRequest) {
            request = KeyValueHandler.handleUnlockRequest((UnlockRequest)msg);
        } else if (msg instanceof ObserveRequest) {
            request = KeyValueHandler.handleObserveRequest(ctx, (ObserveRequest)msg);
        } else if (msg instanceof GetBucketConfigRequest) {
            request = KeyValueHandler.handleGetBucketConfigRequest();
        } else if (msg instanceof AppendRequest) {
            request = KeyValueHandler.handleAppendRequest((AppendRequest)msg);
        } else if (msg instanceof PrependRequest) {
            request = KeyValueHandler.handlePrependRequest((PrependRequest)msg);
        } else if (msg instanceof KeepAliveRequest) {
            request = KeyValueHandler.handleKeepAliveRequest((KeepAliveRequest)msg);
        } else {
            throw new IllegalArgumentException("Unknown incoming BinaryRequest type " + msg.getClass());
        }
        if (msg.partition() >= 0) {
            request.setReserved(msg.partition());
        }
        request.setOpaque(msg.opaque());
        if (!(msg instanceof ObserveRequest) && request instanceof FullBinaryMemcacheRequest) {
            ((FullBinaryMemcacheRequest)request).content().retain();
        }
        return request;
    }

    private static BinaryMemcacheRequest handleGetRequest(ChannelHandlerContext ctx, GetRequest msg) {
        ByteBuf extras;
        byte opcode;
        if (msg.lock()) {
            opcode = -108;
            extras = ctx.alloc().buffer().writeInt(msg.expiry());
        } else if (msg.touch()) {
            opcode = 29;
            extras = ctx.alloc().buffer().writeInt(msg.expiry());
        } else {
            opcode = 0;
            extras = Unpooled.EMPTY_BUFFER;
        }
        String key = msg.key();
        short keyLength = (short)key.length();
        byte extrasLength = (byte)extras.readableBytes();
        DefaultBinaryMemcacheRequest request = new DefaultBinaryMemcacheRequest(key);
        request.setOpcode(opcode).setKeyLength(keyLength).setExtras(extras).setExtrasLength(extrasLength).setTotalBodyLength(keyLength + extrasLength);
        return request;
    }

    private static BinaryMemcacheRequest handleGetBucketConfigRequest() {
        DefaultBinaryMemcacheRequest request = new DefaultBinaryMemcacheRequest();
        request.setOpcode((byte)-75);
        return request;
    }

    private static BinaryMemcacheRequest handleReplicaGetRequest(ReplicaGetRequest msg) {
        String key = msg.key();
        short keyLength = (short)key.length();
        DefaultBinaryMemcacheRequest request = new DefaultBinaryMemcacheRequest(key);
        request.setOpcode((byte)-125).setKeyLength(keyLength).setTotalBodyLength(keyLength);
        return request;
    }

    private static BinaryMemcacheRequest handleStoreRequest(ChannelHandlerContext ctx, BinaryStoreRequest msg) {
        ByteBuf extras = ctx.alloc().buffer(8);
        extras.writeInt(msg.flags());
        extras.writeInt(msg.expiration());
        String key = msg.key();
        short keyLength = (short)key.length();
        byte extrasLength = (byte)extras.readableBytes();
        DefaultFullBinaryMemcacheRequest request = new DefaultFullBinaryMemcacheRequest(key, extras, msg.content());
        if (msg instanceof InsertRequest) {
            request.setOpcode((byte)2);
        } else if (msg instanceof UpsertRequest) {
            request.setOpcode((byte)1);
        } else if (msg instanceof ReplaceRequest) {
            request.setOpcode((byte)3);
            request.setCAS(((ReplaceRequest)msg).cas());
        } else {
            throw new IllegalArgumentException("Unknown incoming BinaryStoreRequest type " + msg.getClass());
        }
        request.setKeyLength(keyLength);
        request.setTotalBodyLength(keyLength + msg.content().readableBytes() + extrasLength);
        request.setExtrasLength(extrasLength);
        return request;
    }

    private static BinaryMemcacheRequest handleRemoveRequest(RemoveRequest msg) {
        String key = msg.key();
        short keyLength = (short)key.length();
        DefaultBinaryMemcacheRequest request = new DefaultBinaryMemcacheRequest(key);
        request.setOpcode((byte)4);
        request.setCAS(msg.cas());
        request.setKeyLength(keyLength);
        request.setTotalBodyLength(keyLength);
        return request;
    }

    private static BinaryMemcacheRequest handleCounterRequest(ChannelHandlerContext ctx, CounterRequest msg) {
        ByteBuf extras = ctx.alloc().buffer();
        extras.writeLong(Math.abs(msg.delta()));
        extras.writeLong(msg.initial());
        extras.writeInt(msg.expiry());
        String key = msg.key();
        short keyLength = (short)key.length();
        byte extrasLength = (byte)extras.readableBytes();
        DefaultBinaryMemcacheRequest request = new DefaultBinaryMemcacheRequest(key, extras);
        request.setOpcode(msg.delta() < 0L ? (byte)6 : 5);
        request.setKeyLength(keyLength);
        request.setTotalBodyLength(keyLength + extrasLength);
        request.setExtrasLength(extrasLength);
        return request;
    }

    private static BinaryMemcacheRequest handleUnlockRequest(UnlockRequest msg) {
        String key = msg.key();
        short keyLength = (short)key.length();
        DefaultBinaryMemcacheRequest request = new DefaultBinaryMemcacheRequest(key);
        request.setOpcode((byte)-107);
        request.setKeyLength(keyLength);
        request.setTotalBodyLength(keyLength);
        request.setCAS(msg.cas());
        return request;
    }

    private static BinaryMemcacheRequest handleTouchRequest(ChannelHandlerContext ctx, TouchRequest msg) {
        ByteBuf extras = ctx.alloc().buffer();
        extras.writeInt(msg.expiry());
        String key = msg.key();
        short keyLength = (short)key.length();
        byte extrasLength = (byte)extras.readableBytes();
        DefaultBinaryMemcacheRequest request = new DefaultBinaryMemcacheRequest(key);
        request.setExtras(extras);
        request.setOpcode((byte)28);
        request.setKeyLength(keyLength);
        request.setTotalBodyLength(keyLength + extrasLength);
        request.setExtrasLength(extrasLength);
        return request;
    }

    private static BinaryMemcacheRequest handleObserveRequest(ChannelHandlerContext ctx, ObserveRequest msg) {
        String key = msg.key();
        ByteBuf content = ctx.alloc().buffer();
        content.writeShort(msg.partition());
        content.writeShort(key.length());
        content.writeBytes(key.getBytes(CHARSET));
        DefaultFullBinaryMemcacheRequest request = new DefaultFullBinaryMemcacheRequest("", Unpooled.EMPTY_BUFFER, content);
        request.setOpcode((byte)-110);
        request.setTotalBodyLength(content.readableBytes());
        return request;
    }

    private static BinaryMemcacheRequest handleAppendRequest(AppendRequest msg) {
        String key = msg.key();
        short keyLength = (short)key.length();
        DefaultFullBinaryMemcacheRequest request = new DefaultFullBinaryMemcacheRequest(key, Unpooled.EMPTY_BUFFER, msg.content());
        request.setOpcode((byte)14);
        request.setKeyLength(keyLength);
        request.setCAS(msg.cas());
        request.setTotalBodyLength(keyLength + msg.content().readableBytes());
        return request;
    }

    private static BinaryMemcacheRequest handlePrependRequest(PrependRequest msg) {
        String key = msg.key();
        short keyLength = (short)key.length();
        DefaultFullBinaryMemcacheRequest request = new DefaultFullBinaryMemcacheRequest(key, Unpooled.EMPTY_BUFFER, msg.content());
        request.setOpcode((byte)15);
        request.setKeyLength(keyLength);
        request.setCAS(msg.cas());
        request.setTotalBodyLength(keyLength + msg.content().readableBytes());
        return request;
    }

    private static BinaryMemcacheRequest handleKeepAliveRequest(KeepAliveRequest msg) {
        DefaultBinaryMemcacheRequest request = new DefaultBinaryMemcacheRequest();
        request.setOpcode((byte)10).setKeyLength((short)0).setExtras(Unpooled.EMPTY_BUFFER).setExtrasLength((byte)0).setTotalBodyLength(0);
        return request;
    }

    @Override
    protected CouchbaseResponse decodeResponse(ChannelHandlerContext ctx, FullBinaryMemcacheResponse msg) throws Exception {
        AbstractKeyValueResponse response;
        BinaryRequest request = (BinaryRequest)this.currentRequest();
        if (request.opaque() != msg.getOpaque()) {
            throw new IllegalStateException("Opaque values for " + msg.getClass() + " do not match.");
        }
        ResponseStatus status = KeyValueHandler.convertStatus(msg.getStatus());
        if (!status.equals((Object)ResponseStatus.RETRY)) {
            ByteBuf content = null;
            if (request instanceof BinaryStoreRequest) {
                content = ((BinaryStoreRequest)request).content();
            } else if (request instanceof AppendRequest) {
                content = ((AppendRequest)request).content();
            } else if (request instanceof PrependRequest) {
                content = ((PrependRequest)request).content();
            }
            if (content != null && content.refCnt() > 0) {
                content.release();
            }
        }
        ByteBuf content = msg.content().retain();
        long cas = msg.getCAS();
        String bucket = request.bucket();
        if (request instanceof GetRequest || request instanceof ReplicaGetRequest) {
            int flags = 0;
            if (msg.getExtrasLength() > 0) {
                ByteBuf extrasReleased = msg.getExtras();
                ByteBuf extras = ctx.alloc().buffer(msg.getExtrasLength());
                extras.writeBytes(extrasReleased, extrasReleased.readerIndex(), extrasReleased.readableBytes());
                flags = extras.getInt(0);
                extras.release();
            }
            response = new GetResponse(status, cas, flags, bucket, content, request);
        } else if (request instanceof GetBucketConfigRequest) {
            response = new GetBucketConfigResponse(status, bucket, content, ((GetBucketConfigRequest)request).hostname());
        } else if (request instanceof InsertRequest) {
            response = new InsertResponse(status, cas, bucket, content, request);
        } else if (request instanceof UpsertRequest) {
            response = new UpsertResponse(status, cas, bucket, content, request);
        } else if (request instanceof ReplaceRequest) {
            response = new ReplaceResponse(status, cas, bucket, content, request);
        } else if (request instanceof RemoveRequest) {
            response = new RemoveResponse(status, cas, bucket, content, request);
        } else if (request instanceof CounterRequest) {
            long value;
            long l = value = status.isSuccess() ? content.readLong() : 0L;
            if (content != null && content.refCnt() > 0) {
                content.release();
            }
            response = new CounterResponse(status, bucket, value, cas, request);
        } else if (request instanceof UnlockRequest) {
            response = new UnlockResponse(status, bucket, content, request);
        } else if (request instanceof TouchRequest) {
            response = new TouchResponse(status, bucket, content, request);
        } else if (request instanceof ObserveRequest) {
            byte observed;
            byte by = observed = status.isSuccess() ? content.getByte(content.getShort(2) + 4) : ObserveResponse.ObserveStatus.UNKNOWN.value();
            if (content != null && content.refCnt() > 0) {
                content.release();
            }
            response = new ObserveResponse(status, observed, ((ObserveRequest)request).master(), bucket, request);
        } else if (request instanceof AppendRequest) {
            response = new AppendResponse(status, cas, bucket, content, request);
        } else if (request instanceof PrependRequest) {
            response = new PrependResponse(status, cas, bucket, content, request);
        } else if (request instanceof KeepAliveRequest) {
            if (content != null && content.refCnt() > 0) {
                content.release();
            }
            response = new KeepAliveResponse(status, request);
        } else {
            throw new IllegalStateException("Unhandled request/response pair: " + request.getClass() + "/" + msg.getClass());
        }
        this.finishedDecoding();
        return response;
    }

    @Override
    protected void sideEffectRequestToCancel(BinaryRequest request) {
        super.sideEffectRequestToCancel(request);
        if (request instanceof BinaryStoreRequest) {
            ((BinaryStoreRequest)request).content().release();
        } else if (request instanceof AppendRequest) {
            ((AppendRequest)request).content().release();
        } else if (request instanceof PrependRequest) {
            ((PrependRequest)request).content().release();
        }
    }

    private static ResponseStatus convertStatus(short status) {
        switch (status) {
            case 0: {
                return ResponseStatus.SUCCESS;
            }
            case 2: {
                return ResponseStatus.EXISTS;
            }
            case 1: {
                return ResponseStatus.NOT_EXISTS;
            }
            case 7: {
                return ResponseStatus.RETRY;
            }
            case 5: {
                return ResponseStatus.NOT_STORED;
            }
            case 3: {
                return ResponseStatus.TOO_BIG;
            }
            case -122: {
                return ResponseStatus.TEMPORARY_FAILURE;
            }
            case -123: {
                return ResponseStatus.TEMPORARY_FAILURE;
            }
            case -126: {
                return ResponseStatus.OUT_OF_MEMORY;
            }
            case -127: {
                return ResponseStatus.COMMAND_UNAVAILABLE;
            }
            case -125: {
                return ResponseStatus.COMMAND_UNAVAILABLE;
            }
            case -124: {
                return ResponseStatus.INTERNAL_ERROR;
            }
            case 4: {
                return ResponseStatus.INVALID_ARGUMENTS;
            }
            case 6: {
                return ResponseStatus.INVALID_ARGUMENTS;
            }
        }
        return ResponseStatus.FAILURE;
    }

    @Override
    protected CouchbaseRequest createKeepAliveRequest() {
        return new KeepAliveRequest();
    }

    protected static class KeepAliveResponse
    extends AbstractKeyValueResponse {
        public KeepAliveResponse(ResponseStatus status, CouchbaseRequest request) {
            super(status, null, null, request);
        }
    }

    protected static class KeepAliveRequest
    extends AbstractKeyValueRequest {
        protected KeepAliveRequest() {
            super((String)null, (String)null, (String)null);
            this.partition((short)0);
        }
    }
}

