/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.config.refresher;

import com.couchbase.client.core.ClusterFacade;
import com.couchbase.client.core.CouchbaseException;
import com.couchbase.client.core.config.BucketConfig;
import com.couchbase.client.core.config.ConfigurationProvider;
import com.couchbase.client.core.config.parser.BucketConfigParser;
import com.couchbase.client.core.config.refresher.Refresher;
import com.couchbase.client.core.logging.CouchbaseLogger;
import com.couchbase.client.core.logging.CouchbaseLoggerFactory;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import rx.Observable;
import rx.subjects.PublishSubject;

public abstract class AbstractRefresher
implements Refresher {
    private static final CouchbaseLogger LOGGER = CouchbaseLoggerFactory.getInstance(Refresher.class);
    private final PublishSubject<BucketConfig> configStream = PublishSubject.create();
    private final ClusterFacade cluster;
    private ConfigurationProvider provider;
    private final Map<String, String> registrations;

    protected AbstractRefresher(ClusterFacade cluster) {
        this.cluster = cluster;
        this.registrations = new ConcurrentHashMap<String, String>();
    }

    @Override
    public Observable<Boolean> deregisterBucket(String name) {
        LOGGER.debug("Deregistering Bucket {} from refresh.", (Object)name);
        if (this.registrations.containsKey(name)) {
            this.registrations.remove(name);
            return Observable.just((Object)true);
        }
        return Observable.just((Object)false);
    }

    @Override
    public Observable<Boolean> registerBucket(String name, String password) {
        LOGGER.debug("Registering Bucket {} for refresh.", (Object)name);
        if (this.registrations.containsKey(name)) {
            return Observable.just((Object)false);
        }
        this.registrations.put(name, password);
        return Observable.just((Object)true);
    }

    @Override
    public Observable<BucketConfig> configs() {
        return this.configStream;
    }

    protected void pushConfig(String config) {
        try {
            this.configStream.onNext((Object)BucketConfigParser.parse(config));
        }
        catch (CouchbaseException e) {
            LOGGER.warn("Exception while pushing new configuration - ignoring.", e);
        }
    }

    protected ClusterFacade cluster() {
        return this.cluster;
    }

    protected ConfigurationProvider provider() {
        return this.provider;
    }

    @Override
    public void provider(ConfigurationProvider provider) {
        this.provider = provider;
    }

    protected Map<String, String> registrations() {
        return this.registrations;
    }
}

