/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.config;

import com.couchbase.client.core.config.BucketConfig;
import com.couchbase.client.core.config.BucketNodeLocator;
import com.couchbase.client.core.config.DefaultNodeInfo;
import com.couchbase.client.core.config.NodeInfo;
import com.couchbase.client.core.config.PortInfo;
import java.util.ArrayList;
import java.util.List;

public abstract class AbstractBucketConfig
implements BucketConfig {
    private final String name;
    private String password;
    private final BucketNodeLocator locator;
    private final String uri;
    private final String streamingUri;
    private final List<NodeInfo> nodeInfo;

    protected AbstractBucketConfig(String name, BucketNodeLocator locator, String uri, String streamingUri, List<NodeInfo> nodeInfos, List<PortInfo> portInfos) {
        this.name = name;
        this.locator = locator;
        this.uri = uri;
        this.streamingUri = streamingUri;
        if (portInfos == null) {
            this.nodeInfo = nodeInfos;
        } else {
            ArrayList<NodeInfo> modified = new ArrayList<NodeInfo>();
            for (int i = 0; i < nodeInfos.size(); ++i) {
                modified.add(new DefaultNodeInfo(nodeInfos.get(i).viewUri(), nodeInfos.get(i).hostname(), portInfos.get(i).ports(), portInfos.get(i).sslPorts()));
            }
            this.nodeInfo = modified;
        }
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public BucketNodeLocator locator() {
        return this.locator;
    }

    @Override
    public String uri() {
        return this.uri;
    }

    @Override
    public String streamingUri() {
        return this.streamingUri;
    }

    @Override
    public List<NodeInfo> nodes() {
        return this.nodeInfo;
    }

    @Override
    public String password() {
        return this.password;
    }

    @Override
    public BucketConfig password(String password) {
        this.password = password;
        return this;
    }
}

