/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core;

import com.couchbase.client.core.ClusterFacade;
import com.couchbase.client.core.CouchbaseException;
import com.couchbase.client.core.ResponseEvent;
import com.couchbase.client.core.config.ConfigurationProvider;
import com.couchbase.client.core.env.CoreEnvironment;
import com.couchbase.client.core.message.CouchbaseMessage;
import com.couchbase.client.core.message.CouchbaseRequest;
import com.couchbase.client.core.message.CouchbaseResponse;
import com.couchbase.client.core.message.ResponseStatus;
import com.couchbase.client.core.message.internal.SignalConfigReload;
import com.couchbase.client.core.message.kv.BinaryResponse;
import com.couchbase.client.deps.com.lmax.disruptor.EventHandler;
import com.couchbase.client.deps.com.lmax.disruptor.EventTranslatorTwoArg;
import com.couchbase.client.deps.io.netty.util.CharsetUtil;
import java.util.concurrent.TimeUnit;
import rx.Scheduler;
import rx.functions.Action0;
import rx.subjects.Subject;

public class ResponseHandler
implements EventHandler<ResponseEvent> {
    private final ClusterFacade cluster;
    private final ConfigurationProvider configurationProvider;
    private final Scheduler.Worker worker;
    public static final EventTranslatorTwoArg<ResponseEvent, CouchbaseMessage, Subject<CouchbaseResponse, CouchbaseResponse>> RESPONSE_TRANSLATOR = new EventTranslatorTwoArg<ResponseEvent, CouchbaseMessage, Subject<CouchbaseResponse, CouchbaseResponse>>(){

        @Override
        public void translateTo(ResponseEvent event, long sequence, CouchbaseMessage message, Subject<CouchbaseResponse, CouchbaseResponse> observable) {
            event.setMessage(message);
            event.setObservable(observable);
        }
    };

    public ResponseHandler(CoreEnvironment environment, ClusterFacade cluster, ConfigurationProvider provider) {
        this.cluster = cluster;
        this.configurationProvider = provider;
        this.worker = environment.scheduler().createWorker();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onEvent(ResponseEvent event, long sequence, boolean endOfBatch) throws Exception {
        block10: {
            try {
                CouchbaseMessage message = event.getMessage();
                if (message instanceof SignalConfigReload) {
                    this.configurationProvider.signalOutdated();
                    break block10;
                }
                if (message instanceof CouchbaseResponse) {
                    CouchbaseResponse response = (CouchbaseResponse)message;
                    ResponseStatus status = response.status();
                    switch (status) {
                        case SUCCESS: 
                        case EXISTS: 
                        case NOT_EXISTS: 
                        case FAILURE: {
                            event.getObservable().onNext((Object)response);
                            event.getObservable().onCompleted();
                            break;
                        }
                        case RETRY: {
                            this.retry(event);
                            break;
                        }
                        default: {
                            throw new UnsupportedOperationException("The ResponseStatus " + (Object)((Object)status) + " is not supported.");
                        }
                    }
                    break block10;
                }
                if (message instanceof CouchbaseRequest) {
                    this.retry(event);
                    break block10;
                }
                throw new IllegalStateException("Got message type I do not understand: " + message);
            }
            finally {
                event.setMessage(null);
                event.setObservable(null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void retry(ResponseEvent event) {
        CouchbaseMessage message = event.getMessage();
        if (message instanceof CouchbaseRequest) {
            this.scheduleForRetry((CouchbaseRequest)message);
        } else {
            BinaryResponse response;
            CouchbaseRequest request = ((CouchbaseResponse)message).request();
            if (request != null) {
                this.scheduleForRetry(request);
            } else {
                event.getObservable().onError((Throwable)new CouchbaseException("Operation failed because it does not support cloning."));
            }
            if (message instanceof BinaryResponse && (response = (BinaryResponse)message).content() != null && response.content().readableBytes() > 0) {
                try {
                    String config = response.content().toString(CharsetUtil.UTF_8).trim();
                    if (config.startsWith("{")) {
                        this.configurationProvider.proposeBucketConfig(response.bucket(), config);
                    }
                }
                finally {
                    response.content().release();
                }
            }
        }
    }

    private void scheduleForRetry(final CouchbaseRequest request) {
        this.worker.schedule(new Action0(){

            public void call() {
                ResponseHandler.this.cluster.send(request);
            }
        }, 10L, TimeUnit.MILLISECONDS);
    }
}

