/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.service;

import com.couchbase.client.core.ResponseEvent;
import com.couchbase.client.core.ResponseHandler;
import com.couchbase.client.core.endpoint.Endpoint;
import com.couchbase.client.core.env.CoreEnvironment;
import com.couchbase.client.core.logging.CouchbaseLogger;
import com.couchbase.client.core.logging.CouchbaseLoggerFactory;
import com.couchbase.client.core.message.CouchbaseRequest;
import com.couchbase.client.core.message.internal.SignalFlush;
import com.couchbase.client.core.service.BucketServiceMapping;
import com.couchbase.client.core.service.Service;
import com.couchbase.client.core.service.strategies.SelectionStrategy;
import com.couchbase.client.core.state.AbstractStateMachine;
import com.couchbase.client.core.state.LifecycleState;
import com.couchbase.client.deps.com.lmax.disruptor.RingBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import rx.Observable;
import rx.functions.Action1;
import rx.functions.Func1;
import rx.functions.FuncN;

public abstract class AbstractService
extends AbstractStateMachine<LifecycleState>
implements Service {
    private static final CouchbaseLogger LOGGER = CouchbaseLoggerFactory.getInstance(Service.class);
    private final SelectionStrategy strategy;
    private final Endpoint[] endpoints;
    private final RingBuffer<ResponseEvent> responseBuffer;
    protected List<Observable<LifecycleState>> endpointStates;

    protected AbstractService(final String hostname, String bucket, String password, int port, CoreEnvironment env, int numEndpoints, SelectionStrategy strategy, RingBuffer<ResponseEvent> responseBuffer, Service.EndpointFactory factory) {
        super(LifecycleState.DISCONNECTED);
        this.strategy = strategy;
        this.responseBuffer = responseBuffer;
        this.endpointStates = new ArrayList<Observable<LifecycleState>>();
        this.endpoints = new Endpoint[numEndpoints];
        for (int i = 0; i < numEndpoints; ++i) {
            Endpoint endpoint;
            this.endpoints[i] = endpoint = factory.create(hostname, bucket, password, port, env, responseBuffer);
            this.endpointStates.add(endpoint.states());
        }
        Observable.combineLatest(this.endpointStates, (FuncN)new FuncN<LifecycleState>(){

            public LifecycleState call(Object ... args) {
                LifecycleState[] states = (LifecycleState[])Arrays.copyOf(args, args.length, LifecycleState[].class);
                return AbstractService.calculateStateFrom(Arrays.asList(states));
            }
        }).subscribe((Action1)new Action1<LifecycleState>(){

            public void call(LifecycleState state) {
                if (state == AbstractService.this.state()) {
                    return;
                }
                if (state == LifecycleState.CONNECTED) {
                    LOGGER.debug(AbstractService.logIdent(hostname, AbstractService.this) + "Connected Service.");
                } else if (state == LifecycleState.DISCONNECTED) {
                    LOGGER.debug(AbstractService.logIdent(hostname, AbstractService.this) + "Disconnected Service.");
                }
                AbstractService.this.transitionState(state);
            }
        });
    }

    @Override
    public BucketServiceMapping mapping() {
        return this.type().mapping();
    }

    @Override
    public void send(CouchbaseRequest request) {
        if (request instanceof SignalFlush) {
            int length = this.endpoints.length;
            for (int i = 0; i < length; ++i) {
                this.endpoints[i].send(request);
            }
            return;
        }
        Endpoint endpoint = this.strategy.select(request, this.endpoints);
        if (endpoint == null) {
            this.responseBuffer.publishEvent(ResponseHandler.RESPONSE_TRANSLATOR, request, request.observable());
        } else {
            endpoint.send(request);
        }
    }

    @Override
    public Observable<LifecycleState> connect() {
        if (this.state() == LifecycleState.CONNECTED || this.state() == LifecycleState.CONNECTING) {
            return Observable.just(this.state());
        }
        return Observable.from((Object[])this.endpoints).flatMap((Func1)new Func1<Endpoint, Observable<LifecycleState>>(){

            public Observable<LifecycleState> call(Endpoint endpoint) {
                return endpoint.connect();
            }
        }).lastOrDefault((Object)LifecycleState.DISCONNECTED).map((Func1)new Func1<LifecycleState, LifecycleState>(){

            public LifecycleState call(LifecycleState state) {
                return (LifecycleState)((Object)AbstractService.this.state());
            }
        });
    }

    @Override
    public Observable<LifecycleState> disconnect() {
        if (this.state() == LifecycleState.DISCONNECTED || this.state() == LifecycleState.DISCONNECTING) {
            return Observable.just(this.state());
        }
        return Observable.from((Object[])this.endpoints).flatMap((Func1)new Func1<Endpoint, Observable<LifecycleState>>(){

            public Observable<LifecycleState> call(Endpoint endpoint) {
                return endpoint.disconnect();
            }
        }).lastOrDefault((Object)LifecycleState.DISCONNECTED).map((Func1)new Func1<LifecycleState, LifecycleState>(){

            public LifecycleState call(LifecycleState state) {
                return (LifecycleState)((Object)AbstractService.this.state());
            }
        });
    }

    private static LifecycleState calculateStateFrom(List<LifecycleState> endpointStates) {
        if (endpointStates.isEmpty()) {
            return LifecycleState.DISCONNECTED;
        }
        int connected = 0;
        int connecting = 0;
        int disconnecting = 0;
        for (LifecycleState endpointState : endpointStates) {
            switch (endpointState) {
                case CONNECTED: {
                    ++connected;
                    break;
                }
                case CONNECTING: {
                    ++connecting;
                    break;
                }
                case DISCONNECTING: {
                    ++disconnecting;
                }
            }
        }
        if (endpointStates.size() == connected) {
            return LifecycleState.CONNECTED;
        }
        if (connected > 0) {
            return LifecycleState.DEGRADED;
        }
        if (connecting > 0) {
            return LifecycleState.CONNECTING;
        }
        if (disconnecting > 0) {
            return LifecycleState.DISCONNECTING;
        }
        return LifecycleState.DISCONNECTED;
    }

    protected static String logIdent(String hostname, Service service) {
        return "[" + hostname + "][" + service.getClass().getSimpleName() + "]: ";
    }
}

