/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.endpoint.query;

import com.couchbase.client.core.ResponseEvent;
import com.couchbase.client.core.endpoint.AbstractEndpoint;
import com.couchbase.client.core.endpoint.AbstractGenericHandler;
import com.couchbase.client.core.message.CouchbaseRequest;
import com.couchbase.client.core.message.CouchbaseResponse;
import com.couchbase.client.core.message.ResponseStatus;
import com.couchbase.client.core.message.query.GenericQueryRequest;
import com.couchbase.client.core.message.query.GenericQueryResponse;
import com.couchbase.client.core.message.query.QueryRequest;
import com.couchbase.client.deps.com.lmax.disruptor.RingBuffer;
import com.couchbase.client.deps.io.netty.buffer.ByteBuf;
import com.couchbase.client.deps.io.netty.channel.ChannelHandlerContext;
import com.couchbase.client.deps.io.netty.handler.codec.http.DefaultFullHttpRequest;
import com.couchbase.client.deps.io.netty.handler.codec.http.HttpContent;
import com.couchbase.client.deps.io.netty.handler.codec.http.HttpMethod;
import com.couchbase.client.deps.io.netty.handler.codec.http.HttpObject;
import com.couchbase.client.deps.io.netty.handler.codec.http.HttpRequest;
import com.couchbase.client.deps.io.netty.handler.codec.http.HttpResponse;
import com.couchbase.client.deps.io.netty.handler.codec.http.HttpVersion;
import com.couchbase.client.deps.io.netty.handler.codec.http.LastHttpContent;
import java.util.Queue;
import rx.Observable;
import rx.subjects.ReplaySubject;

public class QueryHandler
extends AbstractGenericHandler<HttpObject, HttpRequest, QueryRequest> {
    private static final byte QUERY_STATE_INITIAL = 0;
    private static final byte QUERY_STATE_ROWS = 1;
    private static final byte QUERY_STATE_INFO = 2;
    private static final byte QUERY_STATE_ERROR = 3;
    private static final byte QUERY_STATE_DONE = 4;
    private HttpResponse responseHeader;
    private ByteBuf responseContent;
    private ReplaySubject<ByteBuf> queryRowObservable;
    private ReplaySubject<ByteBuf> queryInfoObservable;
    private byte queryParsingState = 0;

    public QueryHandler(AbstractEndpoint endpoint, RingBuffer<ResponseEvent> responseBuffer) {
        super(endpoint, responseBuffer);
    }

    QueryHandler(AbstractEndpoint endpoint, RingBuffer<ResponseEvent> responseBuffer, Queue<QueryRequest> queue) {
        super(endpoint, responseBuffer, queue);
    }

    @Override
    protected HttpRequest encodeRequest(ChannelHandlerContext ctx, QueryRequest msg) throws Exception {
        if (!(msg instanceof GenericQueryRequest)) {
            throw new IllegalArgumentException("Unknown incoming QueryRequest type " + msg.getClass());
        }
        DefaultFullHttpRequest request = new DefaultFullHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.POST, "/query");
        request.headers().set("User-Agent", (Object)this.env().userAgent());
        ByteBuf query = ctx.alloc().buffer(((GenericQueryRequest)msg).query().length());
        query.writeBytes(((GenericQueryRequest)msg).query().getBytes(CHARSET));
        request.headers().add("Content-Length", (Object)query.readableBytes());
        request.content().writeBytes(query);
        query.release();
        return request;
    }

    @Override
    protected CouchbaseResponse decodeResponse(ChannelHandlerContext ctx, HttpObject msg) throws Exception {
        CouchbaseResponse response = null;
        if (msg instanceof HttpResponse) {
            this.responseHeader = (HttpResponse)msg;
            if (this.responseContent != null) {
                this.responseContent.clear();
            } else {
                this.responseContent = ctx.alloc().buffer();
            }
        }
        if (msg instanceof HttpContent) {
            this.responseContent.writeBytes(((HttpContent)msg).content());
            if (this.currentRequest() instanceof GenericQueryRequest) {
                if (this.queryRowObservable == null) {
                    response = this.handleGenericQueryResponse();
                }
                this.parseQueryResponse(msg instanceof LastHttpContent);
            }
        }
        return response;
    }

    private CouchbaseResponse handleGenericQueryResponse() {
        boolean success = true;
        if (this.responseContent.readableBytes() >= 20) {
            ByteBuf firstPart = this.responseContent.slice(0, 20);
            if (firstPart.toString(CHARSET).contains("error")) {
                success = false;
            }
        } else {
            return null;
        }
        ResponseStatus status = QueryHandler.statusFromCode(this.responseHeader.getStatus().code());
        if (!success) {
            status = ResponseStatus.FAILURE;
        }
        this.queryRowObservable = ReplaySubject.create();
        this.queryInfoObservable = ReplaySubject.create();
        return new GenericQueryResponse((Observable<ByteBuf>)this.queryRowObservable, (Observable<ByteBuf>)this.queryInfoObservable, status, (CouchbaseRequest)this.currentRequest());
    }

    private void parseQueryResponse(boolean lastChunk) {
        if (this.queryParsingState == 0) {
            this.parseQueryInitial();
        }
        if (this.queryParsingState == 1) {
            this.parseQueryRows();
        }
        if (this.queryParsingState == 2) {
            this.parseQueryInfo(lastChunk);
        }
        if (this.queryParsingState == 3) {
            this.parseQueryError(lastChunk);
        }
        if (this.queryParsingState == 4) {
            this.cleanupQueryStates();
        }
    }

    private void parseQueryInitial() {
        ByteBuf content = this.responseContent;
        if (content.readableBytes() >= 20) {
            ByteBuf prefixBuf = content.slice(0, 20);
            String prefix = prefixBuf.toString(CHARSET);
            if (prefix.contains("resultset")) {
                this.queryParsingState = 1;
            } else if (prefix.contains("error")) {
                this.queryRowObservable.onCompleted();
                this.queryParsingState = (byte)3;
            } else {
                throw new IllegalStateException("Error parsing query response (in INITIAL): " + content.toString(CHARSET));
            }
            content.readerIndex(prefixBuf.bytesBefore((byte)58) + 1);
        }
    }

    private void parseQueryRows() {
        while (true) {
            int openBracketPos = this.responseContent.bytesBefore((byte)123);
            int nextColonPos = this.responseContent.bytesBefore((byte)58);
            if (nextColonPos < openBracketPos) {
                this.queryParsingState = (byte)2;
                this.queryRowObservable.onCompleted();
                break;
            }
            int closeBracketPos = -1;
            int openBrackets = 0;
            for (int i = this.responseContent.readerIndex(); i <= this.responseContent.writerIndex(); ++i) {
                byte current = this.responseContent.getByte(i);
                if (current == 123) {
                    ++openBrackets;
                    continue;
                }
                if (current != 125 || openBrackets <= 0 || --openBrackets != 0) continue;
                closeBracketPos = i;
                break;
            }
            if (closeBracketPos == -1) break;
            int from = this.responseContent.readerIndex() + openBracketPos;
            int to = closeBracketPos - openBracketPos - this.responseContent.readerIndex() + 1;
            this.queryRowObservable.onNext((Object)this.responseContent.slice(from, to).copy());
            this.responseContent.readerIndex(closeBracketPos);
        }
        this.responseContent.discardReadBytes();
    }

    private void parseQueryInfo(boolean last) {
        if (!last) {
            return;
        }
        int initColon = this.responseContent.bytesBefore((byte)58);
        this.responseContent.readerIndex(initColon);
        while (true) {
            int openBracketPos = this.responseContent.bytesBefore((byte)123);
            int closeBracketPos = -1;
            int openBrackets = 0;
            for (int i = this.responseContent.readerIndex(); i <= this.responseContent.writerIndex(); ++i) {
                byte current = this.responseContent.getByte(i);
                if (current == 123) {
                    ++openBrackets;
                    continue;
                }
                if (current != 125 || openBrackets <= 0 || --openBrackets != 0) continue;
                closeBracketPos = i;
                break;
            }
            if (closeBracketPos == -1) break;
            int from = this.responseContent.readerIndex() + openBracketPos;
            int to = closeBracketPos - openBracketPos - this.responseContent.readerIndex() + 1;
            this.queryInfoObservable.onNext((Object)this.responseContent.slice(from, to).copy());
            this.responseContent.readerIndex(to + openBracketPos);
        }
        this.queryInfoObservable.onCompleted();
        this.queryParsingState = (byte)4;
    }

    private void parseQueryError(boolean last) {
        if (!last) {
            return;
        }
        int found = 0;
        int foundIndex = 0;
        for (int i = this.responseContent.writerIndex(); i > this.responseContent.readerIndex(); --i) {
            if (this.responseContent.getByte(i) == 125) {
                found = (short)(found + 1);
            }
            if (found != 2) continue;
            foundIndex = i;
            break;
        }
        int length = foundIndex - this.responseContent.readerIndex() + 1;
        this.queryInfoObservable.onNext((Object)this.responseContent.copy(this.responseContent.readerIndex(), length));
        this.queryInfoObservable.onCompleted();
        this.queryParsingState = (byte)4;
    }

    private void cleanupQueryStates() {
        this.finishedDecoding();
        this.queryInfoObservable = null;
        this.queryRowObservable = null;
        this.queryParsingState = 0;
    }

    private static ResponseStatus statusFromCode(int code) {
        ResponseStatus status;
        switch (code) {
            case 200: 
            case 201: {
                status = ResponseStatus.SUCCESS;
                break;
            }
            case 404: {
                status = ResponseStatus.NOT_EXISTS;
                break;
            }
            default: {
                status = ResponseStatus.FAILURE;
            }
        }
        return status;
    }

    @Override
    public void handlerRemoved(ChannelHandlerContext ctx) throws Exception {
        if (this.queryRowObservable != null) {
            this.queryRowObservable.onCompleted();
        }
        if (this.queryInfoObservable != null) {
            this.queryInfoObservable.onCompleted();
        }
        this.cleanupQueryStates();
        super.handlerRemoved(ctx);
    }
}

